/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StreamError;
import org.jxmpp.jid.Jid;

public abstract class XMPPException
extends Exception {
    private static final long serialVersionUID = 6881651633890968625L;

    protected XMPPException() {
    }

    protected XMPPException(String message) {
        super(message);
    }

    protected XMPPException(String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
    }

    public static class StreamErrorException
    extends XMPPException {
        private static final long serialVersionUID = 3400556867134848886L;
        private final StreamError streamError;

        public StreamErrorException(StreamError streamError) {
            super(streamError.getCondition().toString() + " You can read more about the meaning of this stream error at http://xmpp.org/rfcs/rfc6120.html#streams-error-conditions\n" + streamError.toString());
            this.streamError = streamError;
        }

        public StreamError getStreamError() {
            return this.streamError;
        }
    }

    public static class FailedNonzaException
    extends XMPPException {
        private static final long serialVersionUID = 1L;
        private final StanzaError.Condition condition;
        private final Nonza nonza;

        public FailedNonzaException(Nonza failedNonza) {
            this(failedNonza, null);
        }

        public FailedNonzaException(Nonza nonza, StanzaError.Condition condition) {
            this.condition = condition;
            this.nonza = nonza;
        }

        public StanzaError.Condition getCondition() {
            return this.condition;
        }

        public Nonza getNonza() {
            return this.nonza;
        }
    }

    public static class XMPPErrorException
    extends XMPPException {
        private static final long serialVersionUID = 212790389529249604L;
        private final StanzaError error;
        private final Stanza stanza;
        private final Stanza request;

        public XMPPErrorException(Stanza stanza, StanzaError error) {
            this(stanza, error, null);
        }

        public XMPPErrorException(Stanza stanza, StanzaError error, Stanza request) {
            this.error = error;
            this.stanza = stanza;
            this.request = request;
        }

        public StanzaError getStanzaError() {
            return this.error;
        }

        public Stanza getRequest() {
            return this.request;
        }

        @Override
        public String getMessage() {
            Jid from;
            StringBuilder sb = new StringBuilder();
            if (this.stanza != null && (from = this.stanza.getFrom()) != null) {
                sb.append("XMPP error reply received from " + from + ": ");
            }
            sb.append(this.error);
            if (this.request != null) {
                sb.append(" as result of the following request: ");
                sb.append(this.request);
            }
            return sb.toString();
        }

        public static void ifHasErrorThenThrow(Stanza packet) throws XMPPErrorException {
            XMPPErrorException.ifHasErrorThenThrow(packet, null);
        }

        public static void ifHasErrorThenThrow(Stanza packet, Stanza request) throws XMPPErrorException {
            StanzaError xmppError = packet.getError();
            if (xmppError != null) {
                throw new XMPPErrorException(packet, xmppError, request);
            }
        }
    }
}

