/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> Collection<T> requireNotEmpty(Collection<T> collection, String collectionName) {
        if (collection == null) {
            throw new NullPointerException(collectionName + " must not be null.");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException(collectionName + " must not be empty.");
        }
        return collection;
    }

    public static <T, C extends Collection<T>> List<T> removeUntil(C collection, Predicate<T> predicate) {
        T t;
        ArrayList<T> removedElements = new ArrayList<T>(collection.size());
        Iterator<T> it = collection.iterator();
        while (it.hasNext() && !predicate.test(t = it.next())) {
            removedElements.add(t);
            it.remove();
        }
        return removedElements;
    }

    public static <T> ArrayList<T> newListWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new ArrayList<T>(collection);
    }

    public static <T> List<T> cloneAndSeal(Collection<? extends T> collection) {
        if (collection == null) {
            return Collections.emptyList();
        }
        ArrayList<? extends T> clone = CollectionUtil.newListWith(collection);
        return Collections.unmodifiableList(clone);
    }

    public static <K, V> Map<K, V> cloneAndSeal(Map<K, V> map) {
        HashMap<K, V> clone = new HashMap<K, V>(map);
        return Collections.unmodifiableMap(clone);
    }

    public static <T> Set<T> newSetWith(Collection<? extends T> collection) {
        if (collection == null) {
            return null;
        }
        return new HashSet<T>(collection);
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }
}

