/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import org.jivesoftware.smack.Smack;
import org.junit.Assert;
import org.junit.jupiter.api.Test;

public class SmackTest {
    @Test
    public void getNoticeStreamTest() throws IOException {
        HashSet expectedStrings = Sets.newHashSet((Object[])new String[]{"Florian Schmaus", "Paul Schaub"});
        int maxLineLength = 0;
        try (InputStream inputStream = Smack.getNoticeStream();){
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            while (reader.ready()) {
                String line = reader.readLine();
                int lineLength = line.length();
                maxLineLength = Math.max(maxLineLength, lineLength);
                expectedStrings.removeIf(s -> s.equals(line));
            }
        }
        Assert.assertTrue((boolean)expectedStrings.isEmpty());
        Assert.assertTrue((maxLineLength < 60 ? 1 : 0) != 0);
    }
}

