/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import com.jamesmurty.utils.XMLBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.xml.sax.SAXException;

public class PacketParserUtilsTest {
    private static Properties outputProperties = new Properties();

    public PacketParserUtilsTest() {
        outputProperties.put("omit-xml-declaration", "yes");
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void singleMessageBodyTest(SmackTestUtil.XmlPullParserKind parserKind) throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertTrue((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(null));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertNull((Object)message.getBody(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)SmackTestUtil.getParserFor((String)control, (SmackTestUtil.XmlPullParserKind)parserKind));
        Assert.assertNull((Object)message.getBody());
        Assert.assertFalse((boolean)message.getBodyLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(defaultLanguage));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertNull((Object)message.getBody(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
    }

    @Test
    public void singleMessageSubjectTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").t(defaultLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertTrue((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(null));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertNull((Object)message.getSubject(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertNull((Object)message.getSubject());
        Assert.assertFalse((boolean)message.getSubjectLanguages().isEmpty());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(defaultLanguage));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertNull((Object)message.getSubject(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
    }

    @Test
    public void multipleMessageBodiesTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).up().e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
        control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("body").t(otherLanguage).up().e("body").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        Assert.assertTrue((boolean)message.getBodyLanguages().contains(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
    }

    @Disabled
    @Test
    public void duplicateMessageBodiesTest() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("body").t(defaultLanguage).up().e("body").a("xml:lang", defaultLanguage).t(defaultLanguage + "2").asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(defaultLanguage));
        Assert.assertEquals((long)1L, (long)message.getBodies().size());
        Assert.assertEquals((long)0L, (long)message.getBodyLanguages().size());
        XmlAssertUtil.assertXmlNotSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
    }

    @Disabled
    @Test
    public void duplicateMessageBodiesTest2() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("xml:lang", defaultLanguage).a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).up().e("body").t(otherLanguage).asString(outputProperties);
        PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
    }

    @Test
    public void messageNoLanguageFirstBodyNoLanguageSecondBodyOtherTest() throws FactoryConfigurationError, XmlPullParserException, IOException, Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").e("body").t(defaultLanguage).up().e("body").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getBody(null));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getBody(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getBodies().size());
        Assert.assertEquals((long)1L, (long)message.getBodyLanguages().size());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML().toString());
    }

    @Test
    public void multipleMessageSubjectsTest() throws Exception {
        String defaultLanguage = Stanza.getDefaultLanguage();
        String otherLanguage = PacketParserUtilsTest.determineNonDefaultLanguage();
        String control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", defaultLanguage).e("subject").t(defaultLanguage).up().e("subject").a("xml:lang", otherLanguage).t(otherLanguage).asString(outputProperties);
        Message message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject());
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject(otherLanguage));
        Assert.assertEquals((long)2L, (long)message.getSubjects().size());
        Assert.assertEquals((long)1L, (long)message.getSubjectLanguages().size());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(otherLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
        control = XMLBuilder.create((String)"message").ns("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", otherLanguage).e("subject").t(otherLanguage).up().e("subject").a("xml:lang", defaultLanguage).t(defaultLanguage).asString(outputProperties);
        message = PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)control));
        Assert.assertEquals((Object)otherLanguage, (Object)message.getSubject());
        Assert.assertEquals((Object)defaultLanguage, (Object)message.getSubject(defaultLanguage));
        Assert.assertEquals((long)2L, (long)message.getSubjects().size());
        Assert.assertEquals((long)1L, (long)message.getSubjectLanguages().size());
        Assert.assertTrue((boolean)message.getSubjectLanguages().contains(defaultLanguage));
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
    }

    @Test
    public void invalidMessageBodyContainingTagTest() throws Exception {
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").a("xmlns", "http://www.w3.org/1999/xhtml").e("span").a("style", "font-weight: bold;").t("Bad Message Body").asString(outputProperties);
        Assertions.assertThrows(XmlPullParserException.class, () -> PacketParserUtils.parseMessage((XmlPullParser)TestUtils.getMessageParser((String)control)));
    }

    @Test
    public void invalidXMLInMessageBody() throws Exception {
        String validControl = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").t("Good Message Body").asString(outputProperties);
        Assertions.assertThrows(XmlPullParserException.class, () -> {
            String invalidControl = validControl.replace("Good Message Body", "Bad </span> Body");
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
        });
        Assertions.assertThrows(XmlPullParserException.class, () -> {
            String invalidControl = validControl.replace("Good Message Body", "Bad </body> Body");
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
        });
        Assertions.assertThrows(XmlPullParserException.class, () -> {
            String invalidControl = validControl.replace("Good Message Body", "Bad </message> Body");
            PacketParserUtils.parseMessage((XmlPullParser)PacketParserUtils.getParserFor((String)invalidControl));
        });
    }

    @Test
    public void multipleMessageBodiesParsingTest() throws Exception {
        String control = XMLBuilder.create((String)"message").namespace("jabber:client").a("from", "romeo@montague.lit/orchard").a("to", "juliet@capulet.lit/balcony").a("id", "zid615d9").a("type", "chat").a("xml:lang", "en").e("body").t("This is a test of the emergency broadcast system, 1.").up().e("body").a("xml:lang", "ru").t("This is a test of the emergency broadcast system, 2.").up().e("body").a("xml:lang", "sp").t("This is a test of the emergency broadcast system, 3.").asString(outputProperties);
        Stanza message = PacketParserUtils.parseStanza((String)control);
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)message.toXML());
    }

    @Test
    public void validateSimplePresence() throws Exception {
        String stanza = "<presence from='juliet@example.com/balcony' to='romeo@example.net'/>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XmlAssertUtil.assertXmlSimilar((CharSequence)stanza, (CharSequence)presence.toXML("jabber:client").toString());
    }

    @Test
    public void validatePresenceProbe() throws Exception {
        String stanza = "<presence from='mercutio@example.com' id='xv291f38' to='juliet@example.com' type='unsubscribed'/>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XmlAssertUtil.assertXmlSimilar((CharSequence)stanza, (CharSequence)presence.toXML("jabber:client").toString());
        Assert.assertEquals((Object)Presence.Type.unsubscribed, (Object)presence.getType());
    }

    @Test
    public void validatePresenceOptionalElements() throws Exception {
        String stanza = "<presence xml:lang='en' type='unsubscribed'><show>dnd</show><status>Wooing Juliet</status><priority>1</priority></presence>";
        Presence presence = PacketParserUtils.parsePresence((XmlPullParser)PacketParserUtils.getParserFor((String)stanza));
        XmlAssertUtil.assertXmlSimilar((CharSequence)stanza, (CharSequence)presence.toXML("jabber:client").toString());
        Assert.assertEquals((Object)Presence.Type.unsubscribed, (Object)presence.getType());
        Assert.assertEquals((Object)"dnd", (Object)presence.getMode().name());
        Assert.assertEquals((Object)"en", (Object)presence.getLanguage());
        Assert.assertEquals((Object)"Wooing Juliet", (Object)presence.getStatus());
        Assert.assertEquals((long)1L, (long)presence.getPriority());
    }

    @Test
    public void parseElementMultipleNamespace() throws ParserConfigurationException, FactoryConfigurationError, XmlPullParserException, IOException, TransformerException, SAXException {
        String stanza = XMLBuilder.create((String)"outer", (String)"outerNamespace").a("outerAttribute", "outerValue").element("inner", "innerNamespace").a("innerAttribute", "innerValue").element("innermost").t("some text").asString();
        XmlPullParser parser = TestUtils.getParser((String)stanza, (String)"outer");
        CharSequence result = PacketParserUtils.parseElement((XmlPullParser)parser, (boolean)true);
        XmlAssertUtil.assertXmlSimilar((CharSequence)stanza, (CharSequence)result.toString());
    }

    private static String determineNonDefaultLanguage() {
        String otherLanguage = "jp";
        Locale[] availableLocales = Locale.getAvailableLocales();
        for (int i = 0; i < availableLocales.length && (availableLocales[i] == Locale.getDefault() || (otherLanguage = availableLocales[i].getLanguage().toLowerCase(Locale.US)).length() <= 0); ++i) {
        }
        return otherLanguage;
    }

    @Test
    public void descriptiveTextNullLangPassedMap() throws Exception {
        String text = "Dummy descriptive text";
        HashMap<Object, String> texts = new HashMap<Object, String>();
        texts.put(null, "Dummy descriptive text");
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).setDescriptiveTexts(texts)).build());
    }

    @Test
    public void ensureNoEmptyLangInDescriptiveText() throws Exception {
        String text = "Dummy descriptive text";
        HashMap<String, String> texts = new HashMap<String, String>();
        texts.put("", "Dummy descriptive text");
        StanzaError error = ((StanzaError.Builder)StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.internal_server_error).setDescriptiveTexts(texts)).build();
        String errorXml = XMLBuilder.create((String)"error").a("type", "cancel").up().element("internal-server-error", "urn:ietf:params:xml:ns:xmpp-stanzas").up().element("text", "urn:ietf:params:xml:ns:xmpp-stanzas").t("Dummy descriptive text").up().asString();
        XmlAssertUtil.assertXmlSimilar((CharSequence)errorXml, (CharSequence)error.toXML("jabber:client"));
    }

    @Test
    public void ensureNoNullLangInParsedDescriptiveTexts() throws Exception {
        String text = "Dummy descriptive text";
        String errorXml = XMLBuilder.create((String)"error").a("type", "cancel").up().element("internal-server-error", "urn:ietf:params:xml:ns:xmpp-stanzas").up().element("text", "urn:ietf:params:xml:ns:xmpp-stanzas").t("Dummy descriptive text").up().asString();
        XmlPullParser parser = TestUtils.getParser((String)errorXml);
        StanzaError error = PacketParserUtils.parseError((XmlPullParser)parser);
        Assert.assertEquals((Object)"Dummy descriptive text", (Object)error.getDescriptiveText());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParseElementSimple(SmackTestUtil.XmlPullParserKind parserKind) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, XmlPullParserException, IOException {
        String unknownElement = XMLBuilder.create((String)"unknown-element").ns("https://example.org/non-existent").e("inner").t("test").asString(outputProperties);
        XmlPullParser xmlPullParser = SmackTestUtil.getParserFor((String)unknownElement, (SmackTestUtil.XmlPullParserKind)parserKind);
        CharSequence unknownElementParsed = PacketParserUtils.parseElement((XmlPullParser)xmlPullParser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)unknownElement, (CharSequence)unknownElementParsed);
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testParseElementExtended(SmackTestUtil.XmlPullParserKind parserKind) throws TransformerException, ParserConfigurationException, FactoryConfigurationError, XmlPullParserException, IOException {
        String unknownElement = XMLBuilder.create((String)"unknown-element").ns("https://example.org/non-existent").a("attribute-outer", "foo").e("inner").a("attribute-inner", "bar").a("attribute-inner-2", "baz").t("test").up().e("empty-element").up().asString(outputProperties);
        XmlPullParser xmlPullParser = SmackTestUtil.getParserFor((String)unknownElement, (SmackTestUtil.XmlPullParserKind)parserKind);
        CharSequence unknownElementParsed = PacketParserUtils.parseElement((XmlPullParser)xmlPullParser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)unknownElement, (CharSequence)unknownElementParsed);
    }
}

