/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;

public class ThreadedDummyConnection
extends DummyConnection {
    private static final Logger LOGGER = Logger.getLogger(ThreadedDummyConnection.class.getName());
    private final BlockingQueue<IQ> replyQ = new ArrayBlockingQueue<IQ>(1);
    private final BlockingQueue<Stanza> messageQ = new LinkedBlockingQueue<Stanza>(5);
    private volatile boolean timeout = false;

    @Override
    protected void sendStanzaInternal(Stanza packet) {
        super.sendStanzaInternal(packet);
        if (packet instanceof IQ && !this.timeout) {
            this.timeout = false;
            IQ replyPacket = (IQ)this.replyQ.peek();
            if (replyPacket == null) {
                replyPacket = IQ.createResultIQ((IQ)((IQ)packet));
                this.replyQ.add(replyPacket);
            }
            replyPacket.setStanzaId(packet.getStanzaId());
            replyPacket.setTo(packet.getFrom());
            if (replyPacket.getType() == null) {
                replyPacket.setType(IQ.Type.result);
            }
            new ProcessQueue(this.replyQ).start();
        }
    }

    public void setTimeout() {
        this.timeout = true;
    }

    public void addMessage(Message msgToProcess) {
        this.messageQ.add((Stanza)msgToProcess);
    }

    public void addIQReply(IQ reply) {
        this.replyQ.add(reply);
    }

    public void processMessages() {
        if (!this.messageQ.isEmpty()) {
            new ProcessQueue(this.messageQ).start();
        } else {
            LOGGER.warning("No messages to process");
        }
    }

    public static ThreadedDummyConnection newInstance() throws SmackException, IOException, XMPPException, InterruptedException {
        ThreadedDummyConnection threadedDummyConnection = new ThreadedDummyConnection();
        threadedDummyConnection.connect();
        return threadedDummyConnection;
    }

    class ProcessQueue
    extends Thread {
        private BlockingQueue<? extends Stanza> processQ;

        ProcessQueue(BlockingQueue<? extends Stanza> queue) {
            this.processQ = queue;
        }

        @Override
        public void run() {
            try {
                ThreadedDummyConnection.this.processStanza(this.processQ.take());
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.WARNING, "exception", e);
            }
        }
    }
}

