/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.altconnections;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.altconnections.HttpLookupMethod;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.jxmpp.stringprep.XmppStringprepException;

public class HttpLookupMethodTest {
    private static final String XRD_XML = "<XRD xmlns='http://docs.oasis-open.org/ns/xri/xrd-1.0'><Link rel='urn:xmpp:alt-connections:xbosh' href='https://igniterealtime.org:443/http-bind/'/><Link rel='urn:xmpp:alt-connections:websocket' href='wss://xmpp.igniterealtime.org:7483/ws/'/><Link rel='urn:xmpp:alt-connections:websocket' href='ws://xmpp.igniterealtime.org:7070/ws/'/></XRD>";

    @Test
    public void parseXrdLinkReferencesForWebsockets() throws XmppStringprepException, IOException, XmlPullParserException, URISyntaxException {
        ArrayList<URI> endpoints = new ArrayList<URI>();
        endpoints.add(new URI("wss://xmpp.igniterealtime.org:7483/ws/"));
        endpoints.add(new URI("ws://xmpp.igniterealtime.org:7070/ws/"));
        List expectedEndpoints = HttpLookupMethod.parseXrdLinkReferencesFor((XmlPullParser)PacketParserUtils.getParserFor((String)XRD_XML), (HttpLookupMethod.LinkRelation)HttpLookupMethod.LinkRelation.WEBSOCKET);
        Assertions.assertEquals((Object)expectedEndpoints, endpoints);
    }

    @Test
    public void parseXrdLinkReferencesForBosh() throws URISyntaxException, IOException, XmlPullParserException {
        ArrayList<URI> endpoints = new ArrayList<URI>();
        endpoints.add(new URI("https://igniterealtime.org:443/http-bind/"));
        List expectedEndpoints = HttpLookupMethod.parseXrdLinkReferencesFor((XmlPullParser)PacketParserUtils.getParserFor((String)XRD_XML), (HttpLookupMethod.LinkRelation)HttpLookupMethod.LinkRelation.BOSH);
        Assertions.assertEquals((Object)expectedEndpoints, endpoints);
    }
}

