/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.test.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Function;
import java.util.logging.Logger;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.Manager;
import org.junit.jupiter.api.Assertions;
import org.jxmpp.stringprep.XmppStringprepException;

public class MemoryLeakTestUtil {
    private static final Logger LOGGER = Logger.getLogger(MemoryLeakTestUtil.class.getName());

    public static <M extends Manager> void noResourceLeakTest(Function<DummyConnection, M> managerSupplier) throws XmppStringprepException, IllegalArgumentException, InterruptedException {
        int numConnections = 10;
        ReferenceQueue connectionsReferenceQueue = new ReferenceQueue();
        ReferenceQueue managerReferenceQueue = new ReferenceQueue();
        HashSet<PhantomReference<DummyConnection>> connectionsPhantomReferences = new HashSet<PhantomReference<DummyConnection>>();
        HashSet<PhantomReference<Manager>> managersPhantomReferences = new HashSet<PhantomReference<Manager>>();
        ArrayList<DummyConnection> connections = new ArrayList<DummyConnection>(10);
        for (int i = 0; i < 10; ++i) {
            DummyConnection connection = new DummyConnection("foo" + i, "bar", "baz");
            PhantomReference<DummyConnection> connectionPhantomReference = new PhantomReference<DummyConnection>(connection, connectionsReferenceQueue);
            connectionsPhantomReferences.add(connectionPhantomReference);
            Manager manager = (Manager)managerSupplier.apply(connection);
            PhantomReference<Manager> managerPhantomReference = new PhantomReference<Manager>(manager, managerReferenceQueue);
            managersPhantomReferences.add(managerPhantomReference);
            connections.add(connection);
        }
        connections = null;
        MemoryLeakTestUtil.triggerGarbageCollection();
        MemoryLeakTestUtil.assertReferencesQueueSize(connectionsReferenceQueue, 10);
        MemoryLeakTestUtil.assertReferencesQueueIsEmpty(managerReferenceQueue);
        DummyConnection connection = new DummyConnection("last", "bar", "baz");
        Manager manager = (Manager)managerSupplier.apply(connection);
        MemoryLeakTestUtil.triggerGarbageCollection();
        MemoryLeakTestUtil.assertReferencesQueueSize(managerReferenceQueue, 10);
    }

    private static void assertReferencesQueueSize(ReferenceQueue<?> referenceQueue, int expectedSize) throws IllegalArgumentException, InterruptedException {
        int timeout = 120000;
        int maxAttempts = 3;
        for (int itemsRemoved = 0; itemsRemoved < expectedSize; ++itemsRemoved) {
            int attempt = 0;
            Reference<?> reference = null;
            while ((reference = referenceQueue.remove(120000L)) == null) {
                String message = "No reference to a gc'ed object found after 120000ms in the " + ++attempt + ". attempt.";
                if (attempt >= 3) {
                    Assertions.fail((String)message);
                }
                LOGGER.warning(message);
                MemoryLeakTestUtil.triggerGarbageCollection();
            }
            reference.clear();
        }
        Reference<?> reference = referenceQueue.poll();
        Assertions.assertNull(reference, (String)"Reference queue is not empty when it should be");
    }

    private static void assertReferencesQueueIsEmpty(ReferenceQueue<?> referenceQueue) {
        Reference<?> reference = referenceQueue.poll();
        Assertions.assertNull(reference);
    }

    private static void triggerGarbageCollection() {
        Object object = new Object();
        WeakReference<Object> weakReference = new WeakReference<Object>(object);
        object = null;
        int gcCalls = 0;
        do {
            if (gcCalls > 1000) {
                throw new AssertionError((Object)("No observed gargabe collection after " + gcCalls + " calls of System.gc()"));
            }
            System.gc();
            ++gcCalls;
        } while (weakReference.get() != null);
        LOGGER.finer("Observed garbage collection after " + gcCalls + " calls of System.gc()");
    }
}

