/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

public class PresenceTest {
    @Test
    public void setPresenceTypeTest() throws IOException, SAXException {
        Presence.Type type = Presence.Type.unavailable;
        Presence.Type type2 = Presence.Type.subscribe;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" type=\"").append(type).append("\">").append("</presence>");
        String control = controlBuilder.toString();
        Presence presenceTypeInConstructor = StanzaBuilder.buildPresence().ofType(type).build();
        Assert.assertEquals((Object)type, (Object)presenceTypeInConstructor.getType());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presenceTypeInConstructor.toXML("jabber:client").toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" type=\"").append(type2).append("\">").append("</presence>");
        control = controlBuilder.toString();
        PresenceBuilder presenceTypeSet = PresenceTest.getNewPresence();
        presenceTypeSet.ofType(type2);
        Assert.assertEquals((Object)type2, (Object)presenceTypeSet.getType());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presenceTypeSet.build().toXML("jabber:client").toString());
    }

    @Test
    public void setNullPresenceTypeTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PresenceTest.getNewPresence().ofType(null));
    }

    @Test
    public void isPresenceAvailableTest() {
        PresenceBuilder presence = PresenceTest.getNewPresence();
        presence.ofType(Presence.Type.available);
        Assert.assertTrue((boolean)presence.build().isAvailable());
        presence.ofType(Presence.Type.unavailable);
        Assert.assertFalse((boolean)presence.build().isAvailable());
    }

    @Test
    public void setPresenceStatusTest() throws IOException, SAXException {
        String status = "This is a test of the emergency broadcast system.";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<status>").append("This is a test of the emergency broadcast system.").append("</status>").append("</presence>");
        String control = controlBuilder.toString();
        PresenceBuilder presence = PresenceTest.getNewPresence();
        presence.setStatus("This is a test of the emergency broadcast system.");
        Assert.assertEquals((Object)"This is a test of the emergency broadcast system.", (Object)presence.getStatus());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presence.build().toXML("jabber:client").toString());
    }

    @Test
    public void setPresencePriorityTest() throws IOException, SAXException {
        int priority = 10;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<priority>").append(10).append("</priority>").append("</presence>");
        String control = controlBuilder.toString();
        PresenceBuilder presence = PresenceTest.getNewPresence();
        presence.setPriority(10);
        Assert.assertEquals((long)10L, (long)presence.getPriority());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presence.build().toXML("jabber:client").toString());
    }

    @Test
    public void setIllegalPriorityTest() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PresenceTest.getNewPresence().setPriority(Integer.MIN_VALUE));
    }

    @Test
    public void setPresenceModeTest() throws IOException, SAXException {
        Presence.Mode mode1 = Presence.Mode.dnd;
        int priority = 10;
        String status = "This is a test of the emergency broadcast system.";
        Presence.Mode mode2 = Presence.Mode.chat;
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<status>").append("This is a test of the emergency broadcast system.").append("</status>").append("<priority>").append(10).append("</priority>").append("<show>").append(mode1).append("</show>").append("</presence>");
        String control = controlBuilder.toString();
        Presence presenceBuildWithBuilder = StanzaBuilder.buildPresence().ofType(Presence.Type.available).setStatus("This is a test of the emergency broadcast system.").setPriority(10).setMode(mode1).build();
        Assert.assertEquals((Object)mode1, (Object)presenceBuildWithBuilder.getMode());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presenceBuildWithBuilder.toXML("jabber:client").toString());
        controlBuilder = new StringBuilder();
        controlBuilder.append("<presence>").append("<show>").append(mode2).append("</show>").append("</presence>");
        control = controlBuilder.toString();
        PresenceBuilder presenceModeSet = PresenceTest.getNewPresence();
        presenceModeSet.setMode(mode2);
        Assert.assertEquals((Object)mode2, (Object)presenceModeSet.getMode());
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presenceModeSet.build().toXML("jabber:client").toString());
    }

    @Test
    public void isModeAwayTest() {
        PresenceBuilder presence = PresenceTest.getNewPresence();
        presence.setMode(Presence.Mode.away);
        Assert.assertTrue((boolean)presence.build().isAway());
        presence.setMode(Presence.Mode.chat);
        Assert.assertFalse((boolean)presence.build().isAway());
    }

    @Test
    public void presenceXmlLangTest() throws IOException, SAXException {
        String lang = "sp";
        StringBuilder controlBuilder = new StringBuilder();
        controlBuilder.append("<presence").append(" xml:lang=\"").append("sp").append("\">").append("</presence>");
        String control = controlBuilder.toString();
        PresenceBuilder presence = PresenceTest.getNewPresence();
        presence.setLanguage("sp");
        XmlAssertUtil.assertXmlSimilar((CharSequence)control, (CharSequence)presence.build().toXML("jabber:client").toString());
    }

    private static PresenceBuilder getNewPresence() {
        PresenceBuilder presence = StanzaBuilder.buildPresence().ofType(Presence.Type.available);
        return presence;
    }
}

