/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.JidTestUtil;

public class ToStringTest {
    @Test
    public void messageTest() {
        Message message = ((MessageBuilder)StanzaBuilder.buildMessage((String)"message-id").ofType(Message.Type.headline).to((Jid)JidTestUtil.BARE_JID_1)).build();
        String string = message.toString();
        Assert.assertEquals((Object)"Message Stanza [to=one@exampleone.org,id=message-id,type=headline,]", (Object)string);
    }

    @Test
    public void presenceTest() {
        Presence presence = StanzaBuilder.buildPresence().ofType(Presence.Type.subscribe).setPriority(0).setMode(Presence.Mode.away).build();
        presence.setStanzaId("presence-id");
        String string = presence.toString();
        Assert.assertEquals((Object)"Presence Stanza [id=presence-id,type=subscribe,mode=away,prio=0,]", (Object)string);
    }

    @Test
    public void iqTest() {
        Bind bindIq = Bind.newResult((EntityFullJid)JidTestUtil.DUMMY_AT_EXAMPLE_ORG_SLASH_DUMMYRESOURCE);
        bindIq.setStanzaId("bind-id");
        String string = bindIq.toString();
        Assert.assertEquals((Object)"IQ Stanza (bind urn:ietf:params:xml:ns:xmpp-bind) [id=bind-id,type=get,]", (Object)string);
    }
}

