/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlElement;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.JidTestUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class DummyConnection
extends AbstractXMPPConnection {
    private final BlockingQueue<TopLevelStreamElement> queue = new LinkedBlockingQueue<TopLevelStreamElement>();

    public static DummyConnectionConfiguration.Builder getDummyConfigurationBuilder() {
        return (DummyConnectionConfiguration.Builder)((DummyConnectionConfiguration.Builder)DummyConnectionConfiguration.builder().setXmppDomain(JidTestUtil.EXAMPLE_ORG)).setUsernameAndPassword("dummy", "dummypass");
    }

    public DummyConnection() {
        this(DummyConnection.getDummyConfigurationBuilder().build());
    }

    public DummyConnection(CharSequence username, String password, String serviceName) throws XmppStringprepException {
        this(((DummyConnectionConfiguration.Builder)((DummyConnectionConfiguration.Builder)DummyConnection.getDummyConfigurationBuilder().setUsernameAndPassword(username, password)).setXmppDomain(JidCreate.domainBareFrom((String)serviceName))).build());
    }

    private EntityFullJid getUserJid() {
        try {
            return JidCreate.entityFullFrom((String)(this.config.getUsername() + "@" + this.config.getXMPPServiceDomain() + "/" + (this.config.getResource() != null ? this.config.getResource() : "Test")));
        }
        catch (XmppStringprepException e) {
            throw new IllegalStateException(e);
        }
    }

    public DummyConnection(DummyConnectionConfiguration configuration) {
        super((ConnectionConfiguration)configuration);
        for (ConnectionCreationListener listener : XMPPConnectionRegistry.getConnectionCreationListeners()) {
            listener.connectionCreated((XMPPConnection)this);
        }
        this.user = this.getUserJid();
    }

    protected void connectInternal() {
        this.connected = true;
        this.streamId = "dummy-" + new Random(new Date().getTime()).nextInt();
    }

    protected void shutdown() {
        this.user = null;
        this.authenticated = false;
        this.callConnectionClosedListener();
    }

    public void instantShutdown() {
        this.shutdown();
    }

    public boolean isSecureConnection() {
        return false;
    }

    public boolean isUsingCompression() {
        return false;
    }

    protected void loginInternal(String username, String password, Resourcepart resource) throws XMPPException {
        this.user = this.getUserJid();
        this.authenticated = true;
    }

    protected void sendInternal(TopLevelStreamElement element) {
        this.queue.add(element);
    }

    protected void sendNonBlockingInternal(TopLevelStreamElement element) throws SmackException.OutgoingQueueFullException {
        boolean enqueued = this.queue.add(element);
        if (!enqueued) {
            throw new SmackException.OutgoingQueueFullException();
        }
    }

    public InetAddress getLocalAddress() {
        return null;
    }

    public int getNumberOfSentPackets() {
        return this.queue.size();
    }

    public <P extends TopLevelStreamElement> P getSentPacket() {
        return this.getSentPacket(300);
    }

    public <P extends TopLevelStreamElement> P getSentPacket(int wait) {
        try {
            return (P)this.queue.poll(wait, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void processStanza(Stanza packet) {
        this.invokeStanzaCollectorsAndNotifyRecvListeners(packet);
    }

    public void enableStreamFeature(ExtensionElement streamFeature) {
        this.addStreamFeature((XmlElement)streamFeature);
    }

    public static DummyConnection newConnectedDummyConnection() {
        DummyConnection dummyConnection = new DummyConnection();
        try {
            dummyConnection.connect();
            dummyConnection.login();
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            throw new IllegalStateException(e);
        }
        return dummyConnection;
    }

    public static class DummyConnectionConfiguration
    extends ConnectionConfiguration {
        protected DummyConnectionConfiguration(Builder builder) {
            super((ConnectionConfiguration.Builder)builder);
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        extends ConnectionConfiguration.Builder<Builder, DummyConnectionConfiguration> {
            private Builder() {
                this.setSecurityMode(ConnectionConfiguration.SecurityMode.disabled);
            }

            public DummyConnectionConfiguration build() {
                return new DummyConnectionConfiguration(this);
            }

            protected Builder getThis() {
                return this;
            }
        }
    }
}

