/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.List;
import java.util.Locale;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.MessageOrPresence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.PresenceView;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;

public final class Presence
extends MessageOrPresence<PresenceBuilder>
implements PresenceView {
    public static final String ELEMENT = "presence";
    private Type type = Type.available;
    private String status = null;
    private Byte priority;
    private Mode mode = null;

    Presence(PresenceBuilder presenceBuilder) {
        super(presenceBuilder);
        this.type = presenceBuilder.type;
        this.status = presenceBuilder.status;
        this.priority = presenceBuilder.priority;
        this.mode = presenceBuilder.mode;
    }

    public Presence(Presence other) {
        super(other);
        this.type = other.type;
        this.status = other.status;
        this.priority = other.priority;
        this.mode = other.mode;
    }

    public boolean isAvailable() {
        return this.type == Type.available;
    }

    public boolean isAway() {
        return this.type == Type.available && (this.mode == Mode.away || this.mode == Mode.xa || this.mode == Mode.dnd);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public int getPriority() {
        return this.getPriorityByte();
    }

    @Override
    public byte getPriorityByte() {
        if (this.priority == null) {
            return 0;
        }
        return this.priority;
    }

    @Deprecated
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public Mode getMode() {
        if (this.mode == null) {
            return Mode.available;
        }
        return this.mode;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public PresenceBuilder asBuilder() {
        return StanzaBuilder.buildPresenceFrom(this, this.getStanzaId());
    }

    @Override
    public PresenceBuilder asBuilder(String id) {
        return StanzaBuilder.buildPresenceFrom(this, id);
    }

    @Override
    public PresenceBuilder asBuilder(XMPPConnection connection) {
        return connection.getStanzaFactory().buildPresenceStanzaFrom(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Presence Stanza [");
        this.logCommonAttributes(sb);
        sb.append("type=").append((Object)this.type).append(',');
        if (this.mode != null) {
            sb.append("mode=").append((Object)this.mode).append(',');
        }
        if (!StringUtils.isNullOrEmpty((CharSequence)this.status)) {
            sb.append("status=").append(this.status).append(',');
        }
        if (this.priority != null) {
            sb.append("prio=").append(this.priority).append(',');
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder buf = new XmlStringBuilder(this, enclosingNamespace);
        this.addCommonAttributes(buf);
        if (this.type != Type.available) {
            buf.attribute("type", this.type);
        }
        List<XmlElement> extensions = this.getExtensions();
        if (this.status == null && this.priority == null && (this.mode == null || this.mode == Mode.available) && extensions.isEmpty() && this.getError() == null) {
            return buf.closeEmptyElement();
        }
        buf.rightAngleBracket();
        buf.optElement("status", this.status);
        buf.optElement("priority", this.priority);
        if (this.mode != null && this.mode != Mode.available) {
            buf.element("show", this.mode);
        }
        buf.append(extensions);
        this.appendErrorIfExists(buf);
        buf.closeElement(ELEMENT);
        return buf;
    }

    public static enum Mode {
        chat,
        available,
        away,
        xa,
        dnd;


        public static Mode fromString(String string) {
            return Mode.valueOf(string.toLowerCase(Locale.US));
        }
    }

    public static enum Type {
        available,
        unavailable,
        subscribe,
        subscribed,
        unsubscribe,
        unsubscribed,
        error,
        probe;


        public static Type fromString(String string) {
            return Type.valueOf(string.toLowerCase(Locale.US));
        }
    }
}

