/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.atomic.AtomicInteger;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.junit.Assert;
import org.junit.Test;

public class StanzaCollectorTest {
    @Test
    public void verifyRollover() throws InterruptedException {
        TestPacket testPacket;
        int i;
        StanzaCollector collector = StanzaCollectorTest.createTestStanzaCollector(null, new OKEverything(), 5);
        for (i = 0; i < 6; ++i) {
            testPacket = new TestPacket(i);
            collector.processStanza((Stanza)testPacket);
        }
        Assert.assertEquals((Object)"1", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"2", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"3", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"4", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"5", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        for (i = 10; i < 15; ++i) {
            testPacket = new TestPacket(i);
            collector.processStanza((Stanza)testPacket);
        }
        Assert.assertEquals((Object)"10", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"11", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"12", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"13", (Object)collector.nextResultBlockForever().getStanzaId());
        Assert.assertEquals((Object)"14", (Object)collector.pollResult().getStanzaId());
        Assert.assertNull((Object)collector.pollResult());
        Assert.assertNull((Object)collector.nextResult(10L));
    }

    @Test
    public void verifyThreadSafety() throws InterruptedException {
        int insertCount = 500;
        final StanzaCollector collector = StanzaCollectorTest.createTestStanzaCollector(null, new OKEverything(), 500);
        final AtomicInteger consumer1Dequeued = new AtomicInteger();
        final AtomicInteger consumer2Dequeued = new AtomicInteger();
        final AtomicInteger consumer3Dequeued = new AtomicInteger();
        Thread consumer1 = new Thread(new Runnable(){

            @Override
            public void run() {
                int dequeueCount = 0;
                try {
                    try {
                        while (true) {
                            Thread.yield();
                            Stanza packet = collector.nextResultBlockForever();
                            if (packet == null) continue;
                            ++dequeueCount;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        consumer1Dequeued.set(dequeueCount);
                    }
                }
                catch (Throwable throwable) {
                    consumer1Dequeued.set(dequeueCount);
                    throw throwable;
                }
            }
        });
        consumer1.setName("consumer 1");
        Thread consumer2 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p;
                int dequeueCount = 0;
                do {
                    Thread.yield();
                    try {
                        p = collector.nextResult(1000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (p == null) continue;
                    ++dequeueCount;
                } while (p != null);
                consumer2Dequeued.set(dequeueCount);
            }
        });
        consumer2.setName("consumer 2");
        Thread consumer3 = new Thread(new Runnable(){

            @Override
            public void run() {
                Stanza p;
                int dequeueCount = 0;
                do {
                    Thread.yield();
                    p = collector.pollResult();
                    if (p == null) continue;
                    ++dequeueCount;
                } while (p != null);
                consumer3Dequeued.set(dequeueCount);
            }
        });
        consumer3.setName("consumer 3");
        for (int i = 0; i < 500; ++i) {
            collector.processStanza((Stanza)new TestPacket(i));
        }
        consumer1.start();
        consumer2.start();
        consumer3.start();
        consumer3.join();
        consumer2.join();
        consumer1.interrupt();
        consumer1.join();
        Assert.assertNull((Object)collector.pollResult());
        int consumer1DequeuedLocal = consumer1Dequeued.get();
        int consumer2DequeuedLocal = consumer2Dequeued.get();
        int consumer3DequeuedLocal = consumer3Dequeued.get();
        int totalDequeued = consumer1DequeuedLocal + consumer2DequeuedLocal + consumer3DequeuedLocal;
        Assert.assertEquals((String)("Inserted 500 but only " + totalDequeued + " c1: " + consumer1DequeuedLocal + " c2: " + consumer2DequeuedLocal + " c3: " + consumer3DequeuedLocal), (long)500L, (long)totalDequeued);
    }

    private static StanzaCollector createTestStanzaCollector(XMPPConnection connection, StanzaFilter packetFilter, int size) {
        return new StanzaCollector(connection, StanzaCollector.newConfiguration().setStanzaFilter(packetFilter).setSize(size));
    }

    static class OKEverything
    implements StanzaFilter {
        OKEverything() {
        }

        public boolean accept(Stanza packet) {
            return true;
        }
    }

    static class TestPacket
    extends Stanza {
        TestPacket(int i) {
            this.setStanzaId(String.valueOf(i));
        }

        public String toXML(XmlEnvironment enclosingNamespace) {
            return "<packetId>" + this.getStanzaId() + "</packetId>";
        }

        public String toString() {
            return this.toXML().toString();
        }

        public String getElementName() {
            return "packetId";
        }
    }
}

