/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compress.provider;

import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.compress.provider.FailureProvider;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.junit.Assert;
import org.junit.Test;

public class FailureProviderTest {
    @Test
    public void simpleFailureTest() throws Exception {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'><processing-failed/></failure>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<failure xmlns='http://jabber.org/protocol/compress'><processing-failed/></failure>");
        Failure failure = (Failure)FailureProvider.INSTANCE.parse(parser);
        Assert.assertEquals((Object)Failure.CompressFailureError.processing_failed, (Object)failure.getCompressFailureError());
    }

    @Test
    public void withStanzaErrrorFailureTest() throws Exception {
        String xml = "<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/><error xmlns='jabber:client' type='modify'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></failure>";
        XmlPullParser parser = PacketParserUtils.getParserFor((String)"<failure xmlns='http://jabber.org/protocol/compress'><setup-failed/><error xmlns='jabber:client' type='modify'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error></failure>");
        Failure failure = (Failure)FailureProvider.INSTANCE.parse(parser);
        Assert.assertEquals((Object)Failure.CompressFailureError.setup_failed, (Object)failure.getCompressFailureError());
        StanzaError error = failure.getStanzaError();
        Assert.assertEquals((Object)StanzaError.Condition.bad_request, (Object)error.getCondition());
    }
}

