/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.text.ParseException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.AbstractProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AbstractProviderTest {
    private static final ExtensionElementProvider<ExtensionElement> NUMBER_FORMAT_THROWING_PROVIDER = new ExtensionElementProvider<ExtensionElement>(){

        public ExtensionElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
            throw new NumberFormatException();
        }
    };
    private static final String MESSAGE = "dummy message";
    private static final int VALUE = 14768234;
    private static final ExtensionElementProvider<ExtensionElement> PARSE_EXCEPTION_THROWING_PROVIDER = new ExtensionElementProvider<ExtensionElement>(){

        public ExtensionElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException, ParseException {
            throw new ParseException(AbstractProviderTest.MESSAGE, 14768234);
        }
    };

    @Test
    public void testWrapsNumberFormatException() throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackTestUtil.createDummyParser();
        Assertions.assertThrows(AbstractProvider.NumberFormatParseException.class, () -> NUMBER_FORMAT_THROWING_PROVIDER.parse(parser));
    }

    @Test
    public void testWrapsParseException() throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackTestUtil.createDummyParser();
        AbstractProvider.TextParseException testParseException = (AbstractProvider.TextParseException)Assertions.assertThrows(AbstractProvider.TextParseException.class, () -> PARSE_EXCEPTION_THROWING_PROVIDER.parse(parser));
        ParseException parseException = testParseException.getParseException();
        Assertions.assertEquals((Object)MESSAGE, (Object)parseException.getMessage());
        Assertions.assertEquals((int)14768234, (int)parseException.getErrorOffset());
    }
}

