/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter.jidtype;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jxmpp.jid.Jid;

public abstract class AbstractJidTypeFilter
implements StanzaFilter {
    private final JidType jidType;

    protected AbstractJidTypeFilter(JidType jidType) {
        this.jidType = Objects.requireNonNull(jidType, "jidType must not be null");
    }

    @Override
    public boolean accept(Stanza stanza) {
        Jid toMatch = this.getJidToMatchFrom(stanza);
        if (toMatch == null) {
            return false;
        }
        return this.jidType.isTypeOf(toMatch);
    }

    protected abstract Jid getJidToMatchFrom(Stanza var1);

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + this.jidType;
    }

    public static enum JidType {
        BareJid,
        DomainBareJid,
        DomainFullJid,
        DomainJid,
        EntityBareJid,
        EntityFullJid,
        EntityJid,
        FullJid;


        public boolean isTypeOf(Jid jid) {
            if (jid == null) {
                return false;
            }
            switch (this) {
                case BareJid: {
                    return jid.hasNoResource();
                }
                case DomainBareJid: {
                    return jid.isDomainBareJid();
                }
                case DomainFullJid: {
                    return jid.isDomainFullJid();
                }
                case EntityBareJid: {
                    return jid.isEntityBareJid();
                }
                case EntityFullJid: {
                    return jid.isEntityFullJid();
                }
                case EntityJid: {
                    return jid.isEntityJid();
                }
                case FullJid: {
                    return jid.hasResource();
                }
            }
            throw new IllegalStateException();
        }
    }
}

