/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.MultiMap;

public class StateDescriptorGraph {
    private static GraphVertex<StateDescriptor> addNewStateDescriptorGraphVertex(Class<? extends StateDescriptor> stateDescriptorClass, Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> graphVertexes) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Constructor<? extends StateDescriptor> stateDescriptorConstructor = stateDescriptorClass.getDeclaredConstructor(new Class[0]);
        stateDescriptorConstructor.setAccessible(true);
        StateDescriptor stateDescriptor = stateDescriptorConstructor.newInstance(new Object[0]);
        GraphVertex<StateDescriptor> graphVertexStateDescriptor = new GraphVertex<StateDescriptor>(stateDescriptor);
        GraphVertex<StateDescriptor> previous = graphVertexes.put(stateDescriptorClass, graphVertexStateDescriptor);
        assert (previous == null);
        return graphVertexStateDescriptor;
    }

    private static void handleStateDescriptorGraphVertex(GraphVertex<StateDescriptor> node, HandleStateDescriptorGraphVertexContext context, boolean failOnUnknownStates) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> stateDescriptorClass = ((StateDescriptor)node.element).getClass();
        boolean alreadyHandled = context.recurseInto(stateDescriptorClass);
        if (alreadyHandled) {
            return;
        }
        Set<Class<? extends StateDescriptor>> successorClasses = ((StateDescriptor)node.element).getSuccessors();
        int numSuccessors = successorClasses.size();
        HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> successorStateDescriptors = new HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>>(numSuccessors);
        for (Class<? extends StateDescriptor> clazz : successorClasses) {
            GraphVertex<StateDescriptor> successorGraphNode = context.getOrConstruct(clazz);
            successorStateDescriptors.put(clazz, successorGraphNode);
        }
        switch (numSuccessors) {
            case 0: {
                throw new IllegalStateException("State " + stateDescriptorClass + " has no successor");
            }
            case 1: {
                GraphVertex soleSuccessorNode = (GraphVertex)successorStateDescriptors.values().iterator().next();
                node.addOutgoingEdge(soleSuccessorNode);
                StateDescriptorGraph.handleStateDescriptorGraphVertex(soleSuccessorNode, context, failOnUnknownStates);
                return;
            }
        }
        HashMap<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>> preferenceGraph = new HashMap<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>>(numSuccessors);
        for (GraphVertex successorStateDescriptorGraphNode : successorStateDescriptors.values()) {
            StateDescriptor stateDescriptor = (StateDescriptor)successorStateDescriptorGraphNode.element;
            Class<?> successorStateDescriptorClass = stateDescriptor.getClass();
            for (Class<? extends StateDescriptor> subordinateClass : stateDescriptor.getSubordinates()) {
                if (failOnUnknownStates && !successorClasses.contains(subordinateClass)) {
                    throw new IllegalStateException(stateDescriptor + " points to a subordinate '" + subordinateClass + "' which is not part of the successor set");
                }
                GraphVertex<Class<? extends StateDescriptor>> superiorClassNode = StateDescriptorGraph.lookupAndCreateIfRequired(preferenceGraph, (Class<? extends StateDescriptor>)successorStateDescriptorClass);
                GraphVertex<Class<? extends StateDescriptor>> subordinateClassNode = StateDescriptorGraph.lookupAndCreateIfRequired(preferenceGraph, subordinateClass);
                superiorClassNode.addOutgoingEdge(subordinateClassNode);
            }
            for (Class<? extends StateDescriptor> superiorClass : stateDescriptor.getSuperiors()) {
                if (failOnUnknownStates && !successorClasses.contains(superiorClass)) {
                    throw new IllegalStateException(stateDescriptor + " points to a superior '" + superiorClass + "' which is not part of the successor set");
                }
                GraphVertex<Class<? extends StateDescriptor>> subordinateClassNode = StateDescriptorGraph.lookupAndCreateIfRequired(preferenceGraph, (Class<? extends StateDescriptor>)successorStateDescriptorClass);
                GraphVertex<Class<? extends StateDescriptor>> superiorClassNode = StateDescriptorGraph.lookupAndCreateIfRequired(preferenceGraph, superiorClass);
                superiorClassNode.addOutgoingEdge(subordinateClassNode);
            }
        }
        List<GraphVertex<GraphVertex<Class<? extends StateDescriptor>>>> list = StateDescriptorGraph.topologicalSort(preferenceGraph.values());
        block8: for (Class<? extends StateDescriptor> clazz : successorClasses) {
            for (GraphVertex graphVertex : list) {
                if (graphVertex.getElement() != clazz) continue;
                continue block8;
            }
            list.add(new GraphVertex<Class<? extends StateDescriptor>>(clazz));
        }
        for (GraphVertex graphVertex : list) {
            GraphVertex successorVertex = (GraphVertex)successorStateDescriptors.get(graphVertex.element);
            if (successorVertex == null) continue;
            node.addOutgoingEdge(successorVertex);
            StateDescriptorGraph.handleStateDescriptorGraphVertex(successorVertex, context, failOnUnknownStates);
        }
    }

    public static GraphVertex<StateDescriptor> constructStateDescriptorGraph(Set<Class<? extends StateDescriptor>> backwardEdgeStateDescriptors, boolean failOnUnknownStates) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> graphVertexes = new HashMap<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>>();
        Class<ModularXmppClientToServerConnection.DisconnectedStateDescriptor> initialStatedescriptorClass = ModularXmppClientToServerConnection.DisconnectedStateDescriptor.class;
        GraphVertex<StateDescriptor> initialNode = StateDescriptorGraph.addNewStateDescriptorGraphVertex(initialStatedescriptorClass, graphVertexes);
        MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>> inferredForwardEdges = new MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>>();
        for (Class<? extends StateDescriptor> backwardsEdge : backwardEdgeStateDescriptors) {
            GraphVertex<StateDescriptor> graphVertexStateDescriptor = StateDescriptorGraph.addNewStateDescriptorGraphVertex(backwardsEdge, graphVertexes);
            for (Class<? extends StateDescriptor> predecessor : graphVertexStateDescriptor.getElement().getPredeccessors()) {
                inferredForwardEdges.put(predecessor, backwardsEdge);
            }
        }
        for (Class<StateDescriptor> inferredSuccessorOfInitialStateDescriptor : inferredForwardEdges.getAll(initialStatedescriptorClass)) {
            initialNode.getElement().addSuccessor(inferredSuccessorOfInitialStateDescriptor);
        }
        HandleStateDescriptorGraphVertexContext context = new HandleStateDescriptorGraphVertexContext(graphVertexes, inferredForwardEdges);
        StateDescriptorGraph.handleStateDescriptorGraphVertex(initialNode, context, failOnUnknownStates);
        return initialNode;
    }

    private static GraphVertex<State> convertToStateGraph(GraphVertex<StateDescriptor> stateDescriptorVertex, ModularXmppClientToServerConnectionInternal connectionInternal, Map<StateDescriptor, GraphVertex<State>> handledStateDescriptors) {
        StateDescriptor stateDescriptor = stateDescriptorVertex.getElement();
        GraphVertex<State> stateVertex = handledStateDescriptors.get(stateDescriptor);
        if (stateVertex != null) {
            return stateVertex;
        }
        State state = stateDescriptor.constructState(connectionInternal);
        stateVertex = new GraphVertex<State>(state);
        handledStateDescriptors.put(stateDescriptor, stateVertex);
        for (GraphVertex<StateDescriptor> successorStateDescriptorVertex : stateDescriptorVertex.getOutgoingEdges()) {
            GraphVertex<State> successorStateVertex = StateDescriptorGraph.convertToStateGraph(successorStateDescriptorVertex, connectionInternal, handledStateDescriptors);
            stateVertex.addOutgoingEdge(successorStateVertex);
        }
        return stateVertex;
    }

    public static GraphVertex<State> convertToStateGraph(GraphVertex<StateDescriptor> initialStateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        HashMap<StateDescriptor, GraphVertex<State>> handledStateDescriptors = new HashMap<StateDescriptor, GraphVertex<State>>();
        GraphVertex<State> initialState = StateDescriptorGraph.convertToStateGraph(initialStateDescriptor, connectionInternal, handledStateDescriptors);
        return initialState;
    }

    private static GraphVertex<Class<? extends StateDescriptor>> lookupAndCreateIfRequired(Map<Class<? extends StateDescriptor>, GraphVertex<Class<? extends StateDescriptor>>> map, Class<? extends StateDescriptor> clazz) {
        GraphVertex<Class<? extends StateDescriptor>> vertex = map.get(clazz);
        if (vertex == null) {
            vertex = new GraphVertex<Class<? extends StateDescriptor>>(clazz);
            map.put(clazz, vertex);
        }
        return vertex;
    }

    private static <E> List<GraphVertex<E>> topologicalSort(Collection<GraphVertex<E>> vertexes) {
        ArrayList res = new ArrayList();
        StateDescriptorGraph.dfs(vertexes, vertex -> res.add(0, (GraphVertex)vertex), null);
        return res;
    }

    private static <E> void dfsVisit(GraphVertex<E> vertex, Consumer<GraphVertex<E>> dfsFinishedVertex, DfsEdgeFound<E> dfsEdgeFound) {
        vertex.color = GraphVertex.VertexColor.grey;
        int totalEdgeCount = vertex.getOutgoingEdges().size();
        int edgeCount = 0;
        for (GraphVertex<E> successorVertex : vertex.getOutgoingEdges()) {
            ++edgeCount;
            if (dfsEdgeFound != null) {
                dfsEdgeFound.onEdgeFound(vertex, successorVertex, edgeCount, totalEdgeCount);
            }
            if (successorVertex.color != GraphVertex.VertexColor.white) continue;
            StateDescriptorGraph.dfsVisit(successorVertex, dfsFinishedVertex, dfsEdgeFound);
        }
        vertex.color = GraphVertex.VertexColor.black;
        if (dfsFinishedVertex != null) {
            dfsFinishedVertex.accept(vertex);
        }
    }

    private static <E> void dfs(Collection<GraphVertex<E>> vertexes, Consumer<GraphVertex<E>> dfsFinishedVertex, DfsEdgeFound<E> dfsEdgeFound) {
        for (GraphVertex<E> vertex : vertexes) {
            if (vertex.color != GraphVertex.VertexColor.white) continue;
            StateDescriptorGraph.dfsVisit(vertex, dfsFinishedVertex, dfsEdgeFound);
        }
    }

    public static void stateDescriptorGraphToDot(Collection<GraphVertex<StateDescriptor>> vertexes, PrintWriter dotOut, boolean breakStateName) {
        dotOut.append("digraph {\n");
        StateDescriptorGraph.dfs(vertexes, finishedVertex -> {
            boolean isMultiVisitState = ((StateDescriptor)finishedVertex.element).isMultiVisitState();
            boolean isFinalState = ((StateDescriptor)finishedVertex.element).isFinalState();
            boolean isNotImplemented = ((StateDescriptor)finishedVertex.element).isNotImplemented();
            String style = null;
            if (isMultiVisitState) {
                style = "bold";
            } else if (isFinalState) {
                style = "filled";
            } else if (isNotImplemented) {
                style = "dashed";
            }
            if (style == null) {
                return;
            }
            dotOut.append('\"').append(((StateDescriptor)finishedVertex.element).getFullStateName(breakStateName)).append("\" [ ").append("style=").append(style).append(" ]\n");
        }, (from, to, edgeId, totalEdgeCount) -> {
            dotOut.append("  \"").append(((StateDescriptor)from.element).getFullStateName(breakStateName)).append("\" -> \"").append(((StateDescriptor)to.element).getFullStateName(breakStateName)).append('\"');
            if (totalEdgeCount > 1) {
                dotOut.append(" [xlabel=\"").append(Integer.toString(edgeId)).append("\"]");
            }
            dotOut.append(";\n");
        });
        dotOut.append("}\n");
    }

    public static final class GraphVertex<E> {
        private final E element;
        private final List<GraphVertex<E>> outgoingEdges = new ArrayList<GraphVertex<E>>();
        private VertexColor color = VertexColor.white;

        private GraphVertex(E element) {
            this.element = element;
        }

        private void addOutgoingEdge(GraphVertex<E> vertex) {
            assert (vertex != null);
            if (this.outgoingEdges.contains(vertex)) {
                throw new IllegalArgumentException("This " + this + " already has an outgoing edge to " + vertex);
            }
            this.outgoingEdges.add(vertex);
        }

        public E getElement() {
            return this.element;
        }

        public List<GraphVertex<E>> getOutgoingEdges() {
            return Collections.unmodifiableList(this.outgoingEdges);
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean includeOutgoingEdges) {
            StringBuilder sb = new StringBuilder();
            sb.append("GraphVertex " + this.element + " [color=" + this.color + ", identityHashCode=" + System.identityHashCode(this) + ", outgoingEdgeCount=" + this.outgoingEdges.size());
            if (includeOutgoingEdges) {
                sb.append(", outgoingEdges={");
                Iterator<GraphVertex<E>> it = this.outgoingEdges.iterator();
                while (it.hasNext()) {
                    GraphVertex<E> outgoingEdgeVertex = it.next();
                    sb.append(outgoingEdgeVertex.toString(false));
                    if (!it.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append('}');
            }
            sb.append(']');
            return sb.toString();
        }

        private static enum VertexColor {
            white,
            grey,
            black;

        }
    }

    private static final class HandleStateDescriptorGraphVertexContext {
        private final Set<Class<? extends StateDescriptor>> handledStateDescriptors = new HashSet<Class<? extends StateDescriptor>>();
        Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> graphVertexes;
        MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>> inferredForwardEdges;

        private HandleStateDescriptorGraphVertexContext(Map<Class<? extends StateDescriptor>, GraphVertex<StateDescriptor>> graphVertexes, MultiMap<Class<? extends StateDescriptor>, Class<? extends StateDescriptor>> inferredForwardEdges) {
            this.graphVertexes = graphVertexes;
            this.inferredForwardEdges = inferredForwardEdges;
        }

        private boolean recurseInto(Class<? extends StateDescriptor> stateDescriptorClass) {
            boolean wasAdded = this.handledStateDescriptors.add(stateDescriptorClass);
            boolean alreadyHandled = !wasAdded;
            return alreadyHandled;
        }

        private GraphVertex<StateDescriptor> getOrConstruct(Class<? extends StateDescriptor> stateDescriptorClass) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            GraphVertex<StateDescriptor> graphVertexStateDescriptor = this.graphVertexes.get(stateDescriptorClass);
            if (graphVertexStateDescriptor == null) {
                graphVertexStateDescriptor = StateDescriptorGraph.addNewStateDescriptorGraphVertex(stateDescriptorClass, this.graphVertexes);
                for (Class<? extends StateDescriptor> inferredSuccessor : this.inferredForwardEdges.getAll(stateDescriptorClass)) {
                    graphVertexStateDescriptor.getElement().addSuccessor(inferredSuccessor);
                }
            }
            return graphVertexStateDescriptor;
        }
    }

    private static interface DfsEdgeFound<E> {
        public void onEdgeFound(GraphVertex<E> var1, GraphVertex<E> var2, int var3, int var4);
    }
}

