/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.initializer;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.initializer.SmackInitializer;
import org.jivesoftware.smack.provider.ProviderFileLoader;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;

public abstract class UrlInitializer
implements SmackInitializer {
    private static final Logger LOGGER = Logger.getLogger(UrlInitializer.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Exception> initialize() {
        String configUriString;
        InputStream is = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        String providerUriString = this.getProvidersUri();
        if (providerUriString != null) {
            try {
                URI providerUri = URI.create(providerUriString);
                is = FileUtils.getStreamForUri(providerUri, classLoader);
                LOGGER.log(Level.FINE, "Loading providers for providerUri [" + providerUri + "]");
                ProviderFileLoader pfl = new ProviderFileLoader(is, classLoader);
                ProviderManager.addLoader(pfl);
                exceptions.addAll(pfl.getLoadingExceptions());
            }
            catch (Exception e) {
                try {
                    LOGGER.log(Level.SEVERE, "Error trying to load provider file " + providerUriString, e);
                    exceptions.add(e);
                }
                catch (Throwable throwable) {
                    UrlInitializer.maybeClose(is);
                    throw throwable;
                }
                UrlInitializer.maybeClose(is);
            }
            UrlInitializer.maybeClose(is);
        }
        if ((configUriString = this.getConfigUri()) != null) {
            try {
                URI configUri = URI.create(configUriString);
                is = FileUtils.getStreamForUri(configUri, classLoader);
                SmackInitialization.processConfigFile(is, exceptions, classLoader);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                UrlInitializer.maybeClose(is);
            }
        }
        return exceptions;
    }

    protected String getProvidersUri() {
        return null;
    }

    protected String getConfigUri() {
        return null;
    }

    private static void maybeClose(InputStream is) {
        CloseableUtil.maybeClose(is, LOGGER);
    }
}

