/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.ParseException;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class AbstractProvider<E extends Element> {
    private final Class<E> elementClass;

    protected AbstractProvider() {
        Type currentType = this.getClass().getGenericSuperclass();
        while (!(currentType instanceof ParameterizedType)) {
            Class currentClass = (Class)currentType;
            currentType = currentClass.getGenericSuperclass();
        }
        ParameterizedType parameterizedGenericSuperclass = (ParameterizedType)currentType;
        Type[] actualTypeArguments = parameterizedGenericSuperclass.getActualTypeArguments();
        Type elementType = actualTypeArguments[0];
        if (elementType instanceof Class) {
            this.elementClass = (Class)elementType;
        } else if (elementType instanceof ParameterizedType) {
            ParameterizedType parameteriezedElementType = (ParameterizedType)elementType;
            this.elementClass = (Class)parameteriezedElementType.getRawType();
        } else if (elementType instanceof TypeVariable) {
            TypeVariable typeVariableElementType = (TypeVariable)elementType;
            this.elementClass = typeVariableElementType.getClass();
        } else {
            throw new AssertionError((Object)("Element type '" + elementType + "' (" + elementType.getClass() + ") is neither of type Class, ParameterizedType or TypeVariable"));
        }
    }

    public final Class<E> getElementClass() {
        return this.elementClass;
    }

    protected static <E> E wrapExceptions(WrappableParser<E> parser) throws XmlPullParserException, IOException, SmackParsingException {
        E e;
        try {
            e = parser.parse();
        }
        catch (ParseException parseException) {
            throw new TextParseException(parseException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatParseException(numberFormatException);
        }
        return e;
    }

    protected static interface WrappableParser<E> {
        public E parse() throws XmlPullParserException, IOException, SmackParsingException, ParseException;
    }

    public static final class TextParseException
    extends SmackParsingException {
        private static final long serialVersionUID = 1L;
        private final ParseException parseException;

        private TextParseException(ParseException parseException) {
            super(parseException);
            this.parseException = parseException;
        }

        public ParseException getParseException() {
            return this.parseException;
        }
    }

    public static final class NumberFormatParseException
    extends SmackParsingException {
        private static final long serialVersionUID = 1L;

        private NumberFormatParseException(NumberFormatException numberFormatException) {
            super(numberFormatException);
        }
    }
}

