/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509TrustManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.util.StringUtils;

public class TLSUtils {
    private static final Logger LOGGER = Logger.getLogger(TLSUtils.class.getName());
    public static final String SSL = "SSL";
    public static final String TLS = "TLS";
    public static final String PROTO_SSL3 = "SSLv3";
    public static final String PROTO_TLSV1 = "TLSv1";
    public static final String PROTO_TLSV1_1 = "TLSv1.1";
    public static final String PROTO_TLSV1_2 = "TLSv1.2";
    public static final String PROTO_TLSV1_3 = "TLSv1.3";
    private static final File DEFAULT_TRUSTSTORE_PATH;
    private static final int JKS_MAGIC = -17957139;
    private static final int JKS_VERSION_1 = 1;
    private static final int JKS_VERSION_2 = 2;

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B setEnabledTlsProtocolsToRecommended(B builder) {
        builder.setEnabledSSLProtocols(new String[]{PROTO_TLSV1_3, PROTO_TLSV1_2});
        return builder;
    }

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B acceptAllCertificates(B builder) {
        builder.setCustomX509TrustManager(new AcceptAllTrustManager());
        return builder;
    }

    public static <B extends ConnectionConfiguration.Builder<B, ?>> B disableHostnameVerificationForTlsCertificates(B builder) {
        builder.setHostnameVerifier((hostname, session) -> true);
        return builder;
    }

    public static void setEnabledProtocolsAndCiphers(SSLSocket sslSocket, String[] enabledProtocols, String[] enabledCiphers) throws SmackException.SecurityNotPossibleException {
        if (enabledProtocols != null) {
            HashSet<String> enabledProtocolsSet = new HashSet<String>(Arrays.asList(enabledProtocols));
            HashSet<String> supportedProtocolsSet = new HashSet<String>(Arrays.asList(sslSocket.getSupportedProtocols()));
            HashSet<String> protocolsIntersection = new HashSet<String>(supportedProtocolsSet);
            protocolsIntersection.retainAll(enabledProtocolsSet);
            if (protocolsIntersection.isEmpty()) {
                throw new SmackException.SecurityNotPossibleException("Request to enable SSL/TLS protocols '" + StringUtils.collectionToString(enabledProtocolsSet) + "', but only '" + StringUtils.collectionToString(supportedProtocolsSet) + "' are supported.");
            }
            enabledProtocols = new String[protocolsIntersection.size()];
            enabledProtocols = protocolsIntersection.toArray(enabledProtocols);
            sslSocket.setEnabledProtocols(enabledProtocols);
        }
        if (enabledCiphers != null) {
            HashSet<String> enabledCiphersSet = new HashSet<String>(Arrays.asList(enabledCiphers));
            HashSet<String> supportedCiphersSet = new HashSet<String>(Arrays.asList(sslSocket.getEnabledCipherSuites()));
            HashSet<String> ciphersIntersection = new HashSet<String>(supportedCiphersSet);
            ciphersIntersection.retainAll(enabledCiphersSet);
            if (ciphersIntersection.isEmpty()) {
                throw new SmackException.SecurityNotPossibleException("Request to enable SSL/TLS ciphers '" + StringUtils.collectionToString(enabledCiphersSet) + "', but only '" + StringUtils.collectionToString(supportedCiphersSet) + "' are supported.");
            }
            enabledCiphers = new String[ciphersIntersection.size()];
            enabledCiphers = ciphersIntersection.toArray(enabledCiphers);
            sslSocket.setEnabledCipherSuites(enabledCiphers);
        }
    }

    public static byte[] getChannelBindingTlsServerEndPoint(SSLSession sslSession) throws SSLPeerUnverifiedException, CertificateEncodingException, NoSuchAlgorithmException {
        String algorithm;
        String certificateAlgorithm;
        Certificate[] peerCertificates = sslSession.getPeerCertificates();
        Certificate certificate = peerCertificates[0];
        switch (certificateAlgorithm = certificate.getPublicKey().getAlgorithm()) {
            case "MD5": 
            case "SHA-1": {
                algorithm = "SHA-256";
                break;
            }
            default: {
                algorithm = certificateAlgorithm;
            }
        }
        MessageDigest messageDigest = MessageDigest.getInstance(algorithm);
        byte[] certificateDerEncoded = certificate.getEncoded();
        messageDigest.update(certificateDerEncoded);
        return messageDigest.digest();
    }

    public static FileInputStream getDefaultTruststoreStreamIfPossible() {
        try {
            return new FileInputStream(DEFAULT_TRUSTSTORE_PATH);
        }
        catch (FileNotFoundException e) {
            LOGGER.log(Level.WARNING, "Could not open default truststore at " + DEFAULT_TRUSTSTORE_PATH, e);
            return null;
        }
    }

    public static DefaultTrustStoreType getDefaultTruststoreType() throws IOException {
        try (FileInputStream inputStream = TLSUtils.getDefaultTruststoreStreamIfPossible();){
            if (inputStream == null) {
                DefaultTrustStoreType defaultTrustStoreType = DefaultTrustStoreType.no_default;
                return defaultTrustStoreType;
            }
            DataInputStream dis = new DataInputStream(inputStream);
            int magic = dis.readInt();
            int version = dis.readInt();
            if (magic == -17957139 && (version == 1 || version == 2)) {
                DefaultTrustStoreType defaultTrustStoreType = DefaultTrustStoreType.jks;
                return defaultTrustStoreType;
            }
        }
        return DefaultTrustStoreType.unknown;
    }

    public static void setDefaultTrustStoreTypeToJksIfRequired() {
        DefaultTrustStoreType defaultTrustStoreType;
        try {
            defaultTrustStoreType = TLSUtils.getDefaultTruststoreType();
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not set keystore type to jks if required", e);
            return;
        }
        if (defaultTrustStoreType == DefaultTrustStoreType.jks) {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
        }
    }

    static {
        String javaHome = System.getProperty("java.home");
        String defaultTruststorePath = javaHome + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts";
        DEFAULT_TRUSTSTORE_PATH = new File(defaultTruststorePath);
    }

    public static class AcceptAllTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    static enum DefaultTrustStoreType {
        jks,
        unknown,
        no_default;

    }
}

