/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.ScheduledAction;

public class SmackReactor {
    private static final Logger LOGGER = Logger.getLogger(SmackReactor.class.getName());
    private static final int DEFAULT_REACTOR_THREAD_COUNT = 2;
    private static final int PENDING_SET_INTEREST_OPS_MAX_BATCH_SIZE = 1024;
    private static SmackReactor INSTANCE;
    private final Selector selector;
    private final String reactorName;
    private final List<Reactor> reactorThreads = Collections.synchronizedList(new ArrayList());
    private final DelayQueue<ScheduledAction> scheduledActions = new DelayQueue();
    private final Lock registrationLock = new ReentrantLock();
    private final Semaphore actionsSemaphore = new Semaphore(-1, false);
    private final Queue<SelectionKey> pendingSelectionKeys = new ConcurrentLinkedQueue<SelectionKey>();
    private final Queue<SetInterestOps> pendingSetInterestOps = new ConcurrentLinkedQueue<SetInterestOps>();

    static synchronized SmackReactor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SmackReactor("DefaultReactor");
        }
        return INSTANCE;
    }

    SmackReactor(String reactorName) {
        this.reactorName = reactorName;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.setReactorThreadCount(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SelectionKey registerWithSelector(SelectableChannel channel, int ops, ChannelSelectedCallback callback) throws ClosedChannelException {
        SelectionKeyAttachment selectionKeyAttachment = new SelectionKeyAttachment(callback);
        this.registrationLock.lock();
        try {
            this.selector.wakeup();
            SelectionKey selectionKey = channel.register(this.selector, ops, selectionKeyAttachment);
            return selectionKey;
        }
        finally {
            this.registrationLock.unlock();
        }
    }

    public void setInterestOps(SelectionKey selectionKey, int interestOps) {
        SetInterestOps setInterestOps = new SetInterestOps(selectionKey, interestOps);
        this.pendingSetInterestOps.add(setInterestOps);
        this.selector.wakeup();
    }

    ScheduledAction schedule(Runnable runnable, long delay, TimeUnit unit, ScheduledAction.Kind scheduledActionKind) {
        long releaseTimeEpoch = System.currentTimeMillis() + unit.toMillis(delay);
        Date releaseTimeDate = new Date(releaseTimeEpoch);
        ScheduledAction scheduledAction = new ScheduledAction(runnable, releaseTimeDate, this, scheduledActionKind);
        this.scheduledActions.add(scheduledAction);
        this.selector.wakeup();
        return scheduledAction;
    }

    boolean cancel(ScheduledAction scheduledAction) {
        return this.scheduledActions.remove(scheduledAction);
    }

    private static void handleSelectedKeys(Collection<SelectionKey> selectedKeys) {
        for (SelectionKey selectionKey : selectedKeys) {
            SelectableChannel channel = selectionKey.channel();
            SelectionKeyAttachment selectionKeyAttachment = (SelectionKeyAttachment)selectionKey.attachment();
            ChannelSelectedCallback channelSelectedCallback = selectionKeyAttachment.channelSelectedCallback;
            channelSelectedCallback.onChannelSelected(channel, selectionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReactorThreadCount(int reactorThreadCount) {
        if (reactorThreadCount < 2) {
            throw new IllegalArgumentException("Must have at least two reactor threads, but you requested " + reactorThreadCount);
        }
        List<Reactor> list = this.reactorThreads;
        synchronized (list) {
            int deltaThreads = reactorThreadCount - this.reactorThreads.size();
            if (deltaThreads > 0) {
                for (int i = 0; i < deltaThreads; ++i) {
                    Reactor reactor = new Reactor();
                    reactor.setDaemon(true);
                    reactor.setName("Smack " + this.reactorName + " Thread #" + i);
                    this.reactorThreads.add(reactor);
                    reactor.start();
                }
                this.actionsSemaphore.release(deltaThreads);
            } else {
                int i;
                deltaThreads -= deltaThreads;
                for (i = deltaThreads - 1; i > 0; --i) {
                    this.actionsSemaphore.acquireUninterruptibly();
                }
                for (i = deltaThreads - 1; i > 0; --i) {
                    Reactor reactor = this.reactorThreads.remove(i);
                    reactor.requestShutdown();
                }
                this.selector.wakeup();
            }
        }
    }

    public static final class SelectionKeyAttachment {
        private final ChannelSelectedCallback channelSelectedCallback;
        private final AtomicBoolean reactorThreadRacing = new AtomicBoolean();

        private SelectionKeyAttachment(ChannelSelectedCallback channelSelectedCallback) {
            this.channelSelectedCallback = channelSelectedCallback;
        }

        private void setRacing() {
            this.reactorThreadRacing.lazySet(true);
        }

        public void resetReactorThreadRacing() {
            this.reactorThreadRacing.set(false);
        }

        public boolean isReactorThreadRacing() {
            return this.reactorThreadRacing.get();
        }
    }

    public static interface ChannelSelectedCallback {
        public void onChannelSelected(SelectableChannel var1, SelectionKey var2);
    }

    private static final class SetInterestOps {
        private final SelectionKey selectionKey;
        private final int interestOps;

        private SetInterestOps(SelectionKey selectionKey, int interestOps) {
            this.selectionKey = selectionKey;
            this.interestOps = interestOps;
        }
    }

    private class Reactor
    extends Thread {
        private volatile long shutdownRequestTimestamp = -1L;

        private Reactor() {
        }

        @Override
        public void run() {
            try {
                this.reactorLoop();
            }
            finally {
                if (this.shutdownRequestTimestamp > 0L) {
                    long shutDownDelay = System.currentTimeMillis() - this.shutdownRequestTimestamp;
                    LOGGER.info(String.valueOf(this) + " shut down after " + shutDownDelay + "ms");
                } else {
                    boolean contained = SmackReactor.this.reactorThreads.remove(this);
                    assert (contained);
                }
            }
        }

        private void reactorLoop() {
            while (this.shutdownRequestTimestamp < 0L) {
                this.handleScheduledActionsOrPerformSelect();
                this.handlePendingSelectionKeys();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleScheduledActionsOrPerformSelect() {
            ArrayList<SelectionKey> selectedKeys;
            ScheduledAction dueScheduledAction = null;
            boolean permitToHandleScheduledActions = SmackReactor.this.actionsSemaphore.tryAcquire();
            if (permitToHandleScheduledActions) {
                try {
                    dueScheduledAction = (ScheduledAction)SmackReactor.this.scheduledActions.poll();
                }
                finally {
                    SmackReactor.this.actionsSemaphore.release();
                }
            }
            if (dueScheduledAction != null) {
                dueScheduledAction.run();
                return;
            }
            int newSelectedKeysCount = 0;
            Selector selector = SmackReactor.this.selector;
            synchronized (selector) {
                SetInterestOps setInterestOps;
                long selectWait;
                ScheduledAction nextScheduledAction = (ScheduledAction)SmackReactor.this.scheduledActions.peek();
                if (nextScheduledAction == null) {
                    selectWait = 0L;
                } else {
                    selectWait = nextScheduledAction.getTimeToDueMillis();
                    if (selectWait <= 0L) {
                        return;
                    }
                }
                int myHandledPendingSetInterestOps = 0;
                while ((setInterestOps = SmackReactor.this.pendingSetInterestOps.poll()) != null) {
                    this.setInterestOpsCancelledKeySafe(setInterestOps.selectionKey, setInterestOps.interestOps);
                    if (myHandledPendingSetInterestOps++ < 1024) continue;
                    SmackReactor.this.selector.wakeup();
                    break;
                }
                SmackReactor.this.registrationLock.lock();
                SmackReactor.this.registrationLock.unlock();
                try {
                    newSelectedKeysCount = SmackReactor.this.selector.select(selectWait);
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "IOException while using select()", e);
                    return;
                }
                if (newSelectedKeysCount == 0) {
                    return;
                }
                Set<SelectionKey> selectedKeySet = SmackReactor.this.selector.selectedKeys();
                for (SelectionKey selectionKey : selectedKeySet) {
                    SelectionKeyAttachment selectionKeyAttachment = (SelectionKeyAttachment)selectionKey.attachment();
                    selectionKeyAttachment.setRacing();
                }
                for (SelectionKey selectionKey : selectedKeySet) {
                    this.setInterestOpsCancelledKeySafe(selectionKey, 0);
                }
                selectedKeys = new ArrayList<SelectionKey>(selectedKeySet);
                selectedKeySet.clear();
            }
            int selectedKeysCount = selectedKeys.size();
            int currentReactorThreadCount = SmackReactor.this.reactorThreads.size();
            int myKeyCount = selectedKeysCount > currentReactorThreadCount ? selectedKeysCount / currentReactorThreadCount : selectedKeysCount;
            Level reactorSelectStatsLogLevel = Level.FINE;
            if (LOGGER.isLoggable(reactorSelectStatsLogLevel)) {
                LOGGER.log(reactorSelectStatsLogLevel, "New selected key count: " + newSelectedKeysCount + ". Total selected key count " + selectedKeysCount + ". My key count: " + myKeyCount + ". Current reactor thread count: " + currentReactorThreadCount);
            }
            ArrayList<SelectionKey> mySelectedKeys = new ArrayList<SelectionKey>(myKeyCount);
            Iterator it = selectedKeys.iterator();
            for (int i = 0; i < myKeyCount; ++i) {
                SelectionKey selectionKey;
                selectionKey = (SelectionKey)it.next();
                mySelectedKeys.add(selectionKey);
            }
            while (it.hasNext()) {
                SelectionKey selectionKey = (SelectionKey)it.next();
                SmackReactor.this.pendingSelectionKeys.add(selectionKey);
            }
            if (selectedKeysCount - myKeyCount > 0) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(mySelectedKeys);
        }

        private void handlePendingSelectionKeys() {
            SelectionKey selectionKey;
            int pendingSelectionKeysSize = SmackReactor.this.pendingSelectionKeys.size();
            if (pendingSelectionKeysSize == 0) {
                return;
            }
            int currentReactorThreadCount = SmackReactor.this.reactorThreads.size();
            int myKeyCount = pendingSelectionKeysSize / currentReactorThreadCount;
            if (myKeyCount == 0) {
                myKeyCount = 1;
            }
            ArrayList<SelectionKey> selectedKeys = new ArrayList<SelectionKey>(myKeyCount);
            for (int i = 0; i < myKeyCount && (selectionKey = SmackReactor.this.pendingSelectionKeys.poll()) != null; ++i) {
                selectedKeys.add(selectionKey);
            }
            if (!SmackReactor.this.pendingSelectionKeys.isEmpty()) {
                SmackReactor.this.selector.wakeup();
            }
            SmackReactor.handleSelectedKeys(selectedKeys);
        }

        private void setInterestOpsCancelledKeySafe(SelectionKey selectionKey, int interestOps) {
            block2: {
                try {
                    selectionKey.interestOps(interestOps);
                }
                catch (CancelledKeyException e) {
                    Level keyCancelledLogLevel = Level.FINER;
                    if (!LOGGER.isLoggable(keyCancelledLogLevel)) break block2;
                    LOGGER.log(keyCancelledLogLevel, "Key '" + String.valueOf(selectionKey) + "' has been cancelled", e);
                }
            }
        }

        void requestShutdown() {
            this.shutdownRequestTimestamp = System.currentTimeMillis();
        }
    }
}

