/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.fsm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateTransitionResult;

public abstract class StateMachineException
extends SmackException {
    private static final long serialVersionUID = 1L;

    protected StateMachineException(String message) {
        super(message);
    }

    protected StateMachineException() {
    }

    public static final class SmackStateGraphDeadEndException
    extends StateMachineException {
        private final List<State> walkedStateGraphPath;
        private final Map<State, StateTransitionResult> failedStates;
        private final StateDescriptor deadEndState;
        private static final long serialVersionUID = 1L;

        private SmackStateGraphDeadEndException(String message, WalkStateGraphContext walkStateGraphContext, StateDescriptorGraph.GraphVertex<State> stateVertex) {
            super(message);
            this.walkedStateGraphPath = Collections.unmodifiableList(walkStateGraphContext.getWalk());
            this.failedStates = Collections.unmodifiableMap(walkStateGraphContext.getFailedStates());
            this.deadEndState = stateVertex.getElement().getStateDescriptor();
        }

        public List<State> getWalkedStateGraph() {
            return this.walkedStateGraphPath;
        }

        public Map<State, StateTransitionResult> getFailedStates() {
            return this.failedStates;
        }

        public StateDescriptor getDeadEndState() {
            return this.deadEndState;
        }

        public static SmackStateGraphDeadEndException from(WalkStateGraphContext walkStateGraphContext, StateDescriptorGraph.GraphVertex<State> stateVertex) {
            String message = String.valueOf(stateVertex) + " has no successor vertexes";
            return new SmackStateGraphDeadEndException(message, walkStateGraphContext, stateVertex);
        }
    }

    public static class SmackMandatoryStateFailedException
    extends StateMachineException {
        private static final long serialVersionUID = 1L;

        public SmackMandatoryStateFailedException(State state, StateTransitionResult failureReason) {
        }
    }
}

