/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.TestIQ;
import org.jivesoftware.smack.test.util.SmackTestUtil;
import org.jivesoftware.smack.test.util.XmlAssertUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class IqTest {
    @Test
    public void testIqErrorWithChildElement() {
        TestIQ request = new TestIQ();
        StanzaError error = StanzaError.getBuilder().setCondition(StanzaError.Condition.bad_request).build();
        ErrorIQ errorIq = IQ.createErrorResponse((IQ)request, (StanzaError)error);
        String expected = "<iq xmlns='jabber:client' id='42' type='error'><error type='modify'><bad-request xmlns='urn:ietf:params:xml:ns:xmpp-stanzas'/></error><test-iq xmlns='https://igniterealtime.org/projects/smack'/></iq>";
        XmlAssertUtil.assertXmlSimilar((CharSequence)expected, (CharSequence)errorIq.toXML());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testIqWithXmlns(SmackTestUtil.XmlPullParserKind parserKind) throws Exception {
        String iqXml = "<iq xmlns='jabber:client' type='result' to='username@tigase.mydomain.org/1423222896-tigase-59' id='3QLCH-1'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'><jid>foo@tigase.mydomain.org/myresource</jid></bind></iq>";
        String xml = "<stream:stream xmlns='jabber:client' to='tigase.mydomain.org' xmlns:stream='http://etherx.jabber.org/streams' version='1.0' from='username@tigase.mydomain.org' xml:lang='en-US'><iq xmlns='jabber:client' type='result' to='username@tigase.mydomain.org/1423222896-tigase-59' id='3QLCH-1'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'><jid>foo@tigase.mydomain.org/myresource</jid></bind></iq></stream:stream>";
        XmlPullParser parser = SmackTestUtil.getParserFor((String)"<stream:stream xmlns='jabber:client' to='tigase.mydomain.org' xmlns:stream='http://etherx.jabber.org/streams' version='1.0' from='username@tigase.mydomain.org' xml:lang='en-US'><iq xmlns='jabber:client' type='result' to='username@tigase.mydomain.org/1423222896-tigase-59' id='3QLCH-1'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'><jid>foo@tigase.mydomain.org/myresource</jid></bind></iq></stream:stream>", (String)"iq", (SmackTestUtil.XmlPullParserKind)parserKind);
        IQ iq = PacketParserUtils.parseIQ((XmlPullParser)parser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<iq xmlns='jabber:client' type='result' to='username@tigase.mydomain.org/1423222896-tigase-59' id='3QLCH-1'><bind xmlns='urn:ietf:params:xml:ns:xmpp-bind'><jid>foo@tigase.mydomain.org/myresource</jid></bind></iq>", (CharSequence)iq.toXML());
    }

    @ParameterizedTest
    @EnumSource(value=SmackTestUtil.XmlPullParserKind.class)
    public void testUnparsedIq(SmackTestUtil.XmlPullParserKind parserKind) throws Exception {
        String iqXml = "<iq xmlns='jabber:client' type='get' id='test-1'><query xmlns='jabber:iq:version'/></iq>";
        String expected = "<iq xmlns='jabber:client'  id='test-1' type='get'><query xmlns='jabber:iq:version'>&lt;query xmlns=&apos;jabber:iq:version&apos;/&gt;</query></iq>";
        XmlPullParser parser = SmackTestUtil.getParserFor((String)"<iq xmlns='jabber:client' type='get' id='test-1'><query xmlns='jabber:iq:version'/></iq>", (String)"iq", (SmackTestUtil.XmlPullParserKind)parserKind);
        IQ iq = PacketParserUtils.parseIQ((XmlPullParser)parser);
        XmlAssertUtil.assertXmlSimilar((CharSequence)"<iq xmlns='jabber:client'  id='test-1' type='get'><query xmlns='jabber:iq:version'>&lt;query xmlns=&apos;jabber:iq:version&apos;/&gt;</query></iq>", (CharSequence)iq.toXML());
    }
}

