/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl.core;

import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.sasl.core.SCRAMSHA1Mechanism;
import org.jivesoftware.smack.sasl.packet.SaslNonza;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.JidTestUtil;

public class SCRAMSHA1MechanismTest
extends SmackTestSuite {
    public static final String USERNAME = "user";
    public static final String PASSWORD = "pencil";
    public static final String CLIENT_FIRST_MESSAGE = "n,,n=user,r=fyko+d2lbbFgONRv9qkxdawL";
    public static final String SERVER_FIRST_MESSAGE = "r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,s=QSXCR+Q6sek8bf92,i=4096";
    public static final String CLIENT_FINAL_MESSAGE = "c=biws,r=fyko+d2lbbFgONRv9qkxdawL3rfcNHYJY1ZVvWVs7j,p=v0X8v3Bz2T0CJGbJQyF0X+HI4Ts=";
    public static final String SERVER_FINAL_MESSAGE = "v=rmF9pqV8S7suAoZWja4dJRkFsKQ=";

    @Test
    public void testScramSha1Mechanism() throws SmackException.NotConnectedException, SmackException, InterruptedException {
        final DummyConnection con = new DummyConnection();
        SCRAMSHA1Mechanism mech = new SCRAMSHA1Mechanism(){

            public String getRandomAscii() {
                this.connection = con;
                return "fyko+d2lbbFgONRv9qkxdawL";
            }
        };
        mech.authenticate(USERNAME, "unusedFoo", JidTestUtil.DOMAIN_BARE_JID_1, PASSWORD, null, null);
        SaslNonza.AuthMechanism authMechanism = (SaslNonza.AuthMechanism)con.getSentPacket();
        Assert.assertEquals((Object)SCRAMSHA1Mechanism.NAME, (Object)authMechanism.getMechanism());
        Assert.assertEquals((Object)CLIENT_FIRST_MESSAGE, (Object)SCRAMSHA1MechanismTest.saslLayerString(authMechanism.getAuthenticationText()));
        mech.challengeReceived(Base64.encode((String)SERVER_FIRST_MESSAGE), false);
        SaslNonza.Response response = (SaslNonza.Response)con.getSentPacket();
        Assert.assertEquals((Object)CLIENT_FINAL_MESSAGE, (Object)SCRAMSHA1MechanismTest.saslLayerString(response.getAuthenticationText()));
        mech.challengeReceived(Base64.encode((String)SERVER_FINAL_MESSAGE), true);
        mech.checkIfSuccessfulOrThrow();
    }

    private static String saslLayerString(String string) {
        return Base64.decodeToString((String)string);
    }
}

