/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.jivesoftware.smack.SmackInitialization;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ReflectionDebuggerFactory;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.parsing.ExceptionThrowingCallbackWithHint;
import org.jivesoftware.smack.parsing.ParsingExceptionCallback;
import org.jivesoftware.smack.util.Objects;

public final class SmackConfiguration {
    public static final String SMACK_URL_STRING = "https://igniterealtime.org/projects/smack";
    public static final URL SMACK_URL;
    private static int defaultPacketReplyTimeout;
    private static int packetCollectorSize;
    private static List<String> defaultMechs;
    static Set<String> disabledSmackClasses;
    static final List<XMPPInputOutputStream> compressionHandlers;
    static boolean smackInitialized;
    public static boolean DEBUG;
    private static SmackDebuggerFactory DEFAULT_DEBUGGER_FACTORY;
    private static ParsingExceptionCallback defaultCallback;
    private static HostnameVerifier defaultHostnameVerififer;
    private static UnknownIqRequestReplyMode unknownIqRequestReplyMode;
    private static final int defaultConcurrencyLevelLimit;
    private static final Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> KNOWN_MODULES;

    @Deprecated
    public static String getVersion() {
        return SmackInitialization.SMACK_VERSION;
    }

    public static int getDefaultReplyTimeout() {
        if (defaultPacketReplyTimeout <= 0) {
            defaultPacketReplyTimeout = 5000;
        }
        return defaultPacketReplyTimeout;
    }

    public static void setDefaultReplyTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException();
        }
        defaultPacketReplyTimeout = timeout;
    }

    public static void setDefaultSmackDebuggerFactory(SmackDebuggerFactory debuggerFactory) {
        DEFAULT_DEBUGGER_FACTORY = Objects.requireNonNull(debuggerFactory, "Debugger factory must not be null");
    }

    public static SmackDebuggerFactory getDefaultSmackDebuggerFactory() {
        return DEFAULT_DEBUGGER_FACTORY;
    }

    public static int getStanzaCollectorSize() {
        return packetCollectorSize;
    }

    public static void setStanzaCollectorSize(int collectorSize) {
        packetCollectorSize = collectorSize;
    }

    public static void addSaslMech(String mech) {
        if (!defaultMechs.contains(mech)) {
            defaultMechs.add(mech);
        }
    }

    public static void addSaslMechs(Collection<String> mechs) {
        for (String mech : mechs) {
            SmackConfiguration.addSaslMech(mech);
        }
    }

    public static void removeSaslMech(String mech) {
        defaultMechs.remove(mech);
    }

    public static void removeSaslMechs(Collection<String> mechs) {
        defaultMechs.removeAll(mechs);
    }

    public static List<String> getSaslMechs() {
        return Collections.unmodifiableList(defaultMechs);
    }

    public static void setDefaultParsingExceptionCallback(ParsingExceptionCallback callback) {
        defaultCallback = callback;
    }

    public static ParsingExceptionCallback getDefaultParsingExceptionCallback() {
        return defaultCallback;
    }

    public static void addCompressionHandler(XMPPInputOutputStream xmppInputOutputStream) {
        compressionHandlers.add(xmppInputOutputStream);
    }

    public static List<XMPPInputOutputStream> getCompressionHandlers() {
        ArrayList<XMPPInputOutputStream> res = new ArrayList<XMPPInputOutputStream>(compressionHandlers.size());
        for (XMPPInputOutputStream ios : compressionHandlers) {
            if (!ios.isSupported()) continue;
            res.add(ios);
        }
        return res;
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier verifier) {
        defaultHostnameVerififer = verifier;
    }

    public static void addDisabledSmackClass(Class<?> clz) {
        SmackConfiguration.addDisabledSmackClass(clz.getName());
    }

    public static void addDisabledSmackClass(String className) {
        disabledSmackClasses.add(className);
    }

    public static void addDisabledSmackClasses(String ... classNames) {
        for (String className : classNames) {
            SmackConfiguration.addDisabledSmackClass(className);
        }
    }

    public static boolean isDisabledSmackClass(String className) {
        for (String disabledClassOrPackage : disabledSmackClasses) {
            if (disabledClassOrPackage.equals(className)) {
                return true;
            }
            int lastDotIndex = disabledClassOrPackage.lastIndexOf(46);
            if (disabledClassOrPackage.length() <= lastDotIndex || Character.isUpperCase(disabledClassOrPackage.charAt(lastDotIndex + 1)) || !className.startsWith(disabledClassOrPackage)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSmackInitialized() {
        return smackInitialized;
    }

    static HostnameVerifier getDefaultHostnameVerifier() {
        return defaultHostnameVerififer;
    }

    public static UnknownIqRequestReplyMode getUnknownIqRequestReplyMode() {
        return unknownIqRequestReplyMode;
    }

    public static void setUnknownIqRequestReplyMode(UnknownIqRequestReplyMode unknownIqRequestReplyMode) {
        SmackConfiguration.unknownIqRequestReplyMode = Objects.requireNonNull(unknownIqRequestReplyMode, "Must set mode");
    }

    public static int getDefaultConcurrencyLevelLimit() {
        return defaultConcurrencyLevelLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addModule(Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> moduleDescriptor) {
        Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> set = KNOWN_MODULES;
        synchronized (set) {
            return KNOWN_MODULES.add(moduleDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAllKnownModulesTo(ModularXmppClientToServerConnectionConfiguration.Builder builder) {
        Set<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>> set = KNOWN_MODULES;
        synchronized (set) {
            for (Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> moduleDescriptor : KNOWN_MODULES) {
                builder.addModule(moduleDescriptor);
            }
        }
    }

    static {
        try {
            SMACK_URL = URI.create(SMACK_URL_STRING).toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        defaultPacketReplyTimeout = 5000;
        packetCollectorSize = 5000;
        defaultMechs = new ArrayList<String>();
        disabledSmackClasses = new HashSet<String>();
        compressionHandlers = new ArrayList<XMPPInputOutputStream>(2);
        smackInitialized = false;
        DEBUG = false;
        DEFAULT_DEBUGGER_FACTORY = ReflectionDebuggerFactory.INSTANCE;
        defaultCallback = new ExceptionThrowingCallbackWithHint();
        unknownIqRequestReplyMode = UnknownIqRequestReplyMode.reply;
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        defaultConcurrencyLevelLimit = availableProcessors < 8 ? 8 : (int)((double)availableProcessors * 1.1);
        KNOWN_MODULES = new HashSet<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>>();
    }

    public static enum UnknownIqRequestReplyMode {
        doNotReply,
        reply;

    }
}

