/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.test.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public final class TestUtils {
    private TestUtils() {
    }

    public static XmlPullParser getIQParser(String stanza) {
        return TestUtils.getParser(stanza, "iq");
    }

    public static XmlPullParser getMessageParser(String stanza) {
        return TestUtils.getParser(stanza, "message");
    }

    public static XmlPullParser getPresenceParser(String stanza) {
        return TestUtils.getParser(stanza, "presence");
    }

    public static XmlPullParser getParser(String string) {
        return TestUtils.getParser(string, null);
    }

    public static XmlPullParser getParser(String string, String startTag) {
        return TestUtils.getParser(new StringReader(string), startTag);
    }

    private static XmlPullParser getParser(Reader reader, String startTag) {
        XmlPullParser parser;
        try {
            parser = SmackXmlParser.newXmlParser((Reader)reader);
            if (startTag == null) {
                while (parser.getEventType() != XmlPullParser.Event.START_ELEMENT) {
                    parser.next();
                }
                return parser;
            }
            boolean found = false;
            while (!found) {
                if (parser.next() != XmlPullParser.Event.START_ELEMENT || !parser.getName().equals(startTag)) continue;
                found = true;
            }
            if (!found) {
                throw new IllegalArgumentException("Can not find start tag '" + startTag + "'");
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return parser;
    }
}

