/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ListenerHandle;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaFactory;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.Consumer;
import org.jivesoftware.smack.util.XmppElementUtil;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityFullJid;

public interface XMPPConnection {
    public DomainBareJid getXMPPServiceDomain();

    public String getHost();

    public int getPort();

    public EntityFullJid getUser();

    public InetAddress getLocalAddress();

    public String getStreamId();

    public boolean isConnected();

    public boolean isAuthenticated();

    public boolean isAnonymous();

    public boolean isSecureConnection();

    public boolean isUsingCompression();

    public StanzaFactory getStanzaFactory();

    public void sendStanza(Stanza var1) throws SmackException.NotConnectedException, InterruptedException;

    public void sendStanzaNonBlocking(Stanza var1) throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException;

    @Deprecated
    public boolean trySendStanza(Stanza var1) throws SmackException.NotConnectedException;

    @Deprecated
    public boolean trySendStanza(Stanza var1, long var2, TimeUnit var4) throws SmackException.NotConnectedException, InterruptedException;

    public void sendNonza(Nonza var1) throws SmackException.NotConnectedException, InterruptedException;

    public void sendNonzaNonBlocking(Nonza var1) throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException;

    public void addConnectionListener(ConnectionListener var1);

    public void removeConnectionListener(ConnectionListener var1);

    public <I extends IQ> I sendIqRequestAndWaitForResponse(IQ var1) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollectorAndSend(IQ var1) throws SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollectorAndSend(StanzaFilter var1, Stanza var2) throws SmackException.NotConnectedException, InterruptedException;

    public StanzaCollector createStanzaCollector(StanzaFilter var1);

    public StanzaCollector createStanzaCollector(StanzaCollector.Configuration var1);

    public void removeStanzaCollector(StanzaCollector var1);

    public ListenerHandle addStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeStanzaListener(StanzaListener var1);

    public ListenerHandle addSyncStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeSyncStanzaListener(StanzaListener var1);

    public ListenerHandle addAsyncStanzaListener(StanzaListener var1, StanzaFilter var2);

    public boolean removeAsyncStanzaListener(StanzaListener var1);

    public void addStanzaSendingListener(StanzaListener var1, StanzaFilter var2);

    public void removeStanzaSendingListener(StanzaListener var1);

    public void addMessageInterceptor(Consumer<MessageBuilder> var1, Predicate<Message> var2);

    public void removeMessageInterceptor(Consumer<MessageBuilder> var1);

    public void addPresenceInterceptor(Consumer<PresenceBuilder> var1, Predicate<Presence> var2);

    public void removePresenceInterceptor(Consumer<PresenceBuilder> var1);

    public long getReplyTimeout();

    public void setReplyTimeout(long var1);

    public int getConnectionCounter();

    public void setFromMode(FromMode var1);

    public FromMode getFromMode();

    public <F extends XmlElement> F getFeature(QName var1);

    default public <F extends XmlElement> F getFeature(Class<F> featureClass) {
        QName qname = XmppElementUtil.getQNameFor(featureClass);
        return this.getFeature(qname);
    }

    default public boolean hasFeature(String element, String namespace) {
        QName qname = new QName(namespace, element);
        return this.hasFeature(qname);
    }

    public boolean hasFeature(QName var1);

    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ var1);

    public SmackFuture<IQ, Exception> sendIqRequestAsync(IQ var1, long var2);

    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S var1, StanzaFilter var2);

    public <S extends Stanza> SmackFuture<S, Exception> sendAsync(S var1, StanzaFilter var2, long var3);

    public void addOneTimeSyncCallback(StanzaListener var1, StanzaFilter var2);

    public IQRequestHandler registerIQRequestHandler(IQRequestHandler var1);

    public IQRequestHandler unregisterIQRequestHandler(IQRequestHandler var1);

    public IQRequestHandler unregisterIQRequestHandler(String var1, String var2, IQ.Type var3);

    public long getLastStanzaReceived();

    public static enum FromMode {
        UNCHANGED,
        OMITTED,
        USER;

    }
}

