/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jxmpp.jid.Jid;

public abstract class AbstractFromToMatchesFilter
implements StanzaFilter {
    private final Jid address;
    private final MatchMode matchMode;

    protected AbstractFromToMatchesFilter(Jid address, boolean ignoreResourcepart) {
        this((Jid)(ignoreResourcepart && address != null ? address.asBareJid() : address), ignoreResourcepart ? MatchMode.ignoreResourcepart : MatchMode.exact);
    }

    protected AbstractFromToMatchesFilter(Jid address, MatchMode matchMode) {
        if (matchMode == MatchMode.strictChild && address.hasResource()) {
            throw new IllegalArgumentException("Can't create a strict child match with a resource that as a resourcepart, because no address would match");
        }
        this.address = address;
        this.matchMode = matchMode;
    }

    @Override
    public final boolean accept(Stanza stanza) {
        Jid stanzaAddress = this.getAddressToCompare(stanza);
        if (stanzaAddress == null) {
            return this.address == null;
        }
        if (this.address == null) {
            return false;
        }
        switch (this.matchMode.ordinal()) {
            case 0: {
                return stanzaAddress.equals((CharSequence)this.address);
            }
            case 1: {
                return this.address.isParentOf(stanzaAddress);
            }
            case 2: {
                return this.address.isStrictParentOf(stanzaAddress);
            }
            case 3: {
                stanzaAddress = stanzaAddress.asBareJid();
                return this.address.equals((CharSequence)stanzaAddress);
            }
        }
        throw new IllegalStateException("Unknown matchMode: " + String.valueOf((Object)this.matchMode));
    }

    protected abstract Jid getAddressToCompare(Stanza var1);

    public final String toString() {
        return this.getClass().getSimpleName() + " (" + String.valueOf((Object)this.matchMode) + "): " + String.valueOf(this.address);
    }

    static enum MatchMode {
        exact,
        child,
        strictChild,
        ignoreResourcepart;

    }
}

