/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.parsing;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.jivesoftware.smack.packet.StandardExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class StandardExtensionElementProvider
extends ExtensionElementProvider<StandardExtensionElement> {
    public static StandardExtensionElementProvider INSTANCE = new StandardExtensionElementProvider();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public StandardExtensionElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
        int i;
        String name = parser.getName();
        String namespace = parser.getNamespace();
        StandardExtensionElement.Builder builder = StandardExtensionElement.builder(name, namespace);
        int namespaceCount = parser.getNamespaceCount();
        int attributeCount = parser.getAttributeCount();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>(namespaceCount + attributeCount);
        for (i = 0; i < namespaceCount; ++i) {
            String nsprefix = parser.getNamespacePrefix(i);
            if (nsprefix == null) continue;
            assert (StringUtils.isNotEmpty((CharSequence)nsprefix));
            String nsuri = parser.getNamespaceUri(i);
            attributes.put("xmlns:" + nsprefix, nsuri);
        }
        for (i = 0; i < attributeCount; ++i) {
            String attributePrefix = parser.getAttributePrefix(i);
            String attributeName = parser.getAttributeName(i);
            String attributeValue = parser.getAttributeValue(i);
            Object attributeKey = StringUtils.isNullOrEmpty((CharSequence)attributePrefix) ? attributeName : attributePrefix + ":" + attributeName;
            attributes.put((String)attributeKey, attributeValue);
        }
        builder.addAttributes(attributes);
        block7: while (true) {
            XmlPullParser.Event event = parser.next();
            switch (event) {
                case START_ELEMENT: {
                    builder.addElement(this.parse(parser, parser.getDepth(), xmlEnvironment));
                    break;
                }
                case TEXT_CHARACTERS: {
                    builder.setText(parser.getText());
                    break;
                }
                case END_ELEMENT: {
                    if (initialDepth == parser.getDepth()) break block7;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        return builder.build();
    }
}

