/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.UnparsedIQ;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.parsing.StandardExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.xml.SmackXmlParser;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.Jid;
import org.jxmpp.stringprep.XmppStringprepException;

public class PacketParserUtils {
    private static final Logger LOGGER = Logger.getLogger(PacketParserUtils.class.getName());

    public static XmlPullParser getParserFor(String stanza) throws XmlPullParserException, IOException {
        return PacketParserUtils.getParserFor(new StringReader(stanza));
    }

    public static XmlPullParser getParserFor(InputStream inputStream) throws XmlPullParserException, IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        return PacketParserUtils.getParserFor(inputStreamReader);
    }

    public static XmlPullParser getParserFor(Reader reader) throws XmlPullParserException, IOException {
        XmlPullParser parser = SmackXmlParser.newXmlParser((Reader)reader);
        ParserUtils.forwardToStartElement(parser);
        return parser;
    }

    public static <S extends Stanza> S parseStanza(String stanza) throws XmlPullParserException, SmackParsingException, IOException {
        return (S)PacketParserUtils.parseStanza(PacketParserUtils.getParserFor(stanza), XmlEnvironment.EMPTY);
    }

    public static Stanza parseStanza(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, SmackParsingException, IOException {
        String name;
        ParserUtils.assertAtStartTag(parser);
        switch (name = parser.getName()) {
            case "message": {
                return PacketParserUtils.parseMessage(parser, outerXmlEnvironment);
            }
            case "iq": {
                return PacketParserUtils.parseIQ(parser, outerXmlEnvironment);
            }
            case "presence": {
                return PacketParserUtils.parsePresence(parser, outerXmlEnvironment);
            }
        }
        throw new IllegalArgumentException("Can only parse message, iq or presence, not " + name);
    }

    private static <SB extends StanzaBuilder<?>> SB parseCommonStanzaAttributes(StanzaBuilderSupplier<SB> stanzaBuilderSupplier, XmlPullParser parser, XmlEnvironment xmlEnvironment) throws XmppStringprepException {
        String id = parser.getAttributeValue("id");
        SB stanzaBuilder = stanzaBuilderSupplier.get(id);
        Jid to = ParserUtils.getJidAttribute(parser, "to");
        ((StanzaBuilder)stanzaBuilder).to(to);
        Jid from = ParserUtils.getJidAttribute(parser, "from");
        ((StanzaBuilder)stanzaBuilder).from(from);
        String language = ParserUtils.getXmlLang(parser, xmlEnvironment);
        ((StanzaBuilder)stanzaBuilder).setLanguage(language);
        return stanzaBuilder;
    }

    public static Message parseMessage(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseMessage(parser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Message parseMessage(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        assert (parser.getName().equals("message"));
        XmlEnvironment messageXmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        int initialDepth = parser.getDepth();
        MessageBuilder message = PacketParserUtils.parseCommonStanzaAttributes(id -> StanzaBuilder.buildMessage(id), parser, outerXmlEnvironment);
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null) {
            message.ofType(Message.Type.fromString(typeString));
        }
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (elementName) {
                        case "error": {
                            message.setError(PacketParserUtils.parseError(parser, messageXmlEnvironment));
                            break block0;
                        }
                    }
                    XmlElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser, messageXmlEnvironment);
                    message.addExtension(extensionElement);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return message.build();
                }
            }
        }
    }

    public static String parseElementText(XmlPullParser parser) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        XmlPullParser.Event event = parser.next();
        if (event != XmlPullParser.Event.TEXT_CHARACTERS) {
            if (event == XmlPullParser.Event.END_ELEMENT) {
                return "";
            }
            throw new XmlPullParserException("Non-empty element tag not followed by text, while Mixed Content (XML 3.2.2) is disallowed");
        }
        String res = parser.getText();
        event = parser.next();
        if (event != XmlPullParser.Event.END_ELEMENT) {
            throw new XmlPullParserException("Non-empty element tag contains child-elements, while Mixed Content (XML 3.2.2) is disallowed");
        }
        return res;
    }

    public static CharSequence parseElement(XmlPullParser parser) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseElement(parser, false);
    }

    public static CharSequence parseElement(XmlPullParser parser, boolean fullNamespaces) throws XmlPullParserException, IOException {
        assert (parser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        return PacketParserUtils.parseContentDepth(parser, parser.getDepth(), fullNamespaces);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser, int depth) throws XmlPullParserException, IOException {
        return PacketParserUtils.parseContentDepth(parser, depth, false);
    }

    public static CharSequence parseContentDepth(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        if (parser.supportsRoundtrip()) {
            return PacketParserUtils.parseContentDepthWithRoundtrip(parser, depth);
        }
        return PacketParserUtils.parseContentDepthWithoutRoundtrip(parser, depth, fullNamespaces);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static CharSequence parseContentDepthWithoutRoundtrip(XmlPullParser parser, int depth, boolean fullNamespaces) throws XmlPullParserException, IOException {
        XmlStringBuilder xml = new XmlStringBuilder();
        XmlPullParser.Event event = parser.getEventType();
        String namespaceElement = null;
        boolean startElementJustSeen = false;
        while (true) {
            switch (event) {
                case START_ELEMENT: {
                    String namespace;
                    if (startElementJustSeen) {
                        xml.rightAngleBracket();
                    } else {
                        startElementJustSeen = true;
                    }
                    xml.halfOpenElement(parser.getName());
                    if ((namespaceElement == null || fullNamespaces) && StringUtils.isNotEmpty((CharSequence)(namespace = parser.getNamespace()))) {
                        xml.attribute("xmlns", namespace);
                        namespaceElement = parser.getName();
                    }
                    for (int i = 0; i < parser.getAttributeCount(); ++i) {
                        xml.attribute(parser.getAttributeName(i), parser.getAttributeValue(i));
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (startElementJustSeen) {
                        xml.closeEmptyElement();
                        startElementJustSeen = false;
                    } else {
                        xml.closeElement(parser.getName());
                    }
                    if (namespaceElement != null && namespaceElement.equals(parser.getName())) {
                        namespaceElement = null;
                    }
                    if (parser.getDepth() > depth) break;
                    return xml;
                }
                case TEXT_CHARACTERS: {
                    if (startElementJustSeen) {
                        startElementJustSeen = false;
                        xml.rightAngleBracket();
                    }
                    xml.escape(parser.getText());
                }
            }
            event = parser.next();
        }
    }

    private static XmlStringBuilder parseContentDepthWithRoundtrip(XmlPullParser parser, int depth) throws XmlPullParserException, IOException {
        XmlStringBuilder sb = new XmlStringBuilder();
        XmlPullParser.Event event = parser.getEventType();
        boolean startElementJustSeen = false;
        block4: while (true) {
            switch (event) {
                case START_ELEMENT: {
                    startElementJustSeen = true;
                    String openElementTag = parser.getText();
                    sb.append(openElementTag);
                    break;
                }
                case END_ELEMENT: {
                    CharSequence text;
                    boolean isEmptyElement = false;
                    if (startElementJustSeen) {
                        isEmptyElement = true;
                        startElementJustSeen = false;
                    }
                    if (!isEmptyElement) {
                        text = parser.getText();
                        sb.append(text);
                    }
                    if (parser.getDepth() > depth) break;
                    break block4;
                }
                default: {
                    startElementJustSeen = false;
                    CharSequence text = parser.getText();
                    if (event == XmlPullParser.Event.TEXT_CHARACTERS) {
                        text = StringUtils.escapeForXml(text);
                    }
                    sb.append(text);
                }
            }
            event = parser.next();
        }
        return sb;
    }

    public static Presence parsePresence(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parsePresence(parser, XmlEnvironment.EMPTY);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Presence parsePresence(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        XmlEnvironment presenceXmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        PresenceBuilder presence = PacketParserUtils.parseCommonStanzaAttributes(stanzaId -> StanzaBuilder.buildPresence(stanzaId), parser, outerXmlEnvironment);
        Presence.Type type = Presence.Type.available;
        String typeString = parser.getAttributeValue("", "type");
        if (typeString != null && !typeString.equals("")) {
            type = Presence.Type.fromString(typeString);
        }
        presence.ofType(type);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            block1 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (elementName) {
                        case "status": {
                            presence.setStatus(parser.nextText());
                            break block1;
                        }
                        case "priority": {
                            Byte priority = ParserUtils.getByteAttributeFromNextText(parser);
                            presence.setPriority(priority);
                            break block1;
                        }
                        case "show": {
                            String modeText = parser.nextText();
                            if (StringUtils.isNotEmpty((CharSequence)modeText)) {
                                presence.setMode(Presence.Mode.fromString(modeText));
                                break block1;
                            }
                            LOGGER.warning("Empty or null mode text in presence show element form " + String.valueOf(presence) + "' which is invalid according to RFC6121 4.7.2.1");
                            break block1;
                        }
                        case "error": {
                            presence.setError(PacketParserUtils.parseError(parser, presenceXmlEnvironment));
                            break block1;
                        }
                    }
                    try {
                        XmlElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser, presenceXmlEnvironment);
                        presence.addExtension(extensionElement);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to parse extension element in Presence stanza: " + String.valueOf(presence), e);
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return presence.build();
                }
            }
        }
    }

    public static IQ parseIQ(XmlPullParser parser) throws Exception {
        return PacketParserUtils.parseIQ(parser, null);
    }

    public static IqData parseIqData(XmlPullParser parser) throws XmppStringprepException {
        String id = parser.getAttributeValue("", "id");
        IqData iqData = StanzaBuilder.buildIqData(id);
        Jid to = ParserUtils.getJidAttribute(parser, "to");
        iqData.to(to);
        Jid from = ParserUtils.getJidAttribute(parser, "from");
        iqData.from(from);
        String typeString = parser.getAttributeValue("", "type");
        IQ.Type type = IQ.Type.fromString(typeString);
        iqData.ofType(type);
        return iqData;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static IQ parseIQ(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, XmppStringprepException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        XmlEnvironment iqXmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        Stanza iqPacket = null;
        StanzaError error = null;
        IqData iqData = PacketParserUtils.parseIqData(parser);
        block14: while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String elementName = parser.getName();
                    String namespace = parser.getNamespace();
                    switch (elementName) {
                        case "error": {
                            error = PacketParserUtils.parseError(parser, iqXmlEnvironment);
                            break block0;
                        }
                    }
                    IqProvider<IQ> provider = ProviderManager.getIQProvider(elementName, namespace);
                    if (provider != null) {
                        iqPacket = provider.parse(parser, iqData, outerXmlEnvironment);
                        break;
                    }
                    iqPacket = new UnparsedIQ(elementName, namespace, PacketParserUtils.parseElement(parser));
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block14;
                }
            }
        }
        if (iqPacket == null) {
            switch (iqData.getType()) {
                case error: {
                    return ErrorIQ.builder(error, iqData).build();
                }
                case result: {
                    iqPacket = new EmptyResultIQ();
                    break;
                }
            }
        }
        iqPacket.setStanzaId(iqData.getStanzaId());
        iqPacket.setTo(iqData.getTo());
        iqPacket.setFrom(iqData.getFrom());
        ((IQ)iqPacket).setType(iqData.getType());
        iqPacket.setError(error);
        return iqPacket;
    }

    public static Collection<String> parseMechanisms(XmlPullParser parser) throws XmlPullParserException, IOException {
        ArrayList<String> mechanisms = new ArrayList<String>();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                String elementName = parser.getName();
                if (!elementName.equals("mechanism")) continue;
                mechanisms.add(parser.nextText());
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("mechanisms")) continue;
            done = true;
        }
        return mechanisms;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Compress.Feature parseCompressionFeature(XmlPullParser parser) throws IOException, XmlPullParserException {
        assert (parser.getEventType() == XmlPullParser.Event.START_ELEMENT);
        int initialDepth = parser.getDepth();
        ArrayList<String> methods = new ArrayList<String>();
        block16: while (true) {
            XmlPullParser.Event eventType = parser.next();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "method": {
                            methods.add(parser.nextText());
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "compression": {
                            if (parser.getDepth() == initialDepth) break block16;
                        }
                        default: {
                            break block0;
                        }
                    }
                }
            }
        }
        assert (parser.getEventType() == XmlPullParser.Event.END_ELEMENT);
        assert (parser.getDepth() == initialDepth);
        return new Compress.Feature(methods);
    }

    public static Map<String, String> parseDescriptiveTexts(XmlPullParser parser, Map<String, String> descriptiveTexts) throws XmlPullParserException, IOException {
        String xmllang;
        if (descriptiveTexts == null) {
            descriptiveTexts = new HashMap<String, String>();
        }
        if ((xmllang = ParserUtils.getXmlLang(parser)) == null) {
            xmllang = "";
        }
        String text = parser.nextText();
        String previousValue = descriptiveTexts.put(xmllang, text);
        assert (previousValue == null);
        return descriptiveTexts;
    }

    public static StreamError parseStreamError(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseStreamError(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StreamError parseStreamError(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        ArrayList<XmlElement> extensions = new ArrayList<XmlElement>();
        Map<String, String> descriptiveTexts = null;
        StreamError.Condition condition = null;
        String conditionText = null;
        XmlEnvironment streamErrorXmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String namespace;
                    String name = parser.getName();
                    block7 : switch (namespace = parser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-streams": {
                            switch (name) {
                                case "text": {
                                    descriptiveTexts = PacketParserUtils.parseDescriptiveTexts(parser, descriptiveTexts);
                                    break block7;
                                }
                            }
                            condition = StreamError.Condition.fromString(name);
                            conditionText = parser.nextText();
                            if (!conditionText.isEmpty()) break;
                            conditionText = null;
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(extensions, parser, name, namespace, streamErrorXmlEnvironment);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new StreamError(condition, conditionText, descriptiveTexts, extensions);
                }
            }
        }
    }

    public static StanzaError parseError(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        return PacketParserUtils.parseError(parser, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StanzaError parseError(XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        int initialDepth = parser.getDepth();
        Map<String, String> descriptiveTexts = null;
        XmlEnvironment stanzaErrorXmlEnvironment = XmlEnvironment.from(parser, outerXmlEnvironment);
        ArrayList<XmlElement> extensions = new ArrayList<XmlElement>();
        StanzaError.Builder builder = StanzaError.getBuilder();
        builder.setType(StanzaError.Type.fromString(parser.getAttributeValue("", "type")));
        builder.setErrorGenerator(parser.getAttributeValue("", "by"));
        block16: while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    String namespace;
                    String name = parser.getName();
                    block7 : switch (namespace = parser.getNamespace()) {
                        case "urn:ietf:params:xml:ns:xmpp-stanzas": {
                            switch (name) {
                                case "text": {
                                    descriptiveTexts = PacketParserUtils.parseDescriptiveTexts(parser, descriptiveTexts);
                                    break block7;
                                }
                            }
                            builder.setCondition(StanzaError.Condition.fromString(name));
                            String conditionText = parser.nextText();
                            if (conditionText.isEmpty()) break;
                            builder.setConditionText(conditionText);
                            break;
                        }
                        default: {
                            PacketParserUtils.addExtensionElement(extensions, parser, name, namespace, stanzaErrorXmlEnvironment);
                            break;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block16;
                }
            }
        }
        ((StanzaError.Builder)builder.setExtensions(extensions)).setDescriptiveTexts(descriptiveTexts);
        return builder.build();
    }

    public static XmlElement parseExtensionElement(String elementName, String namespace, XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        ExtensionElementProvider<ExtensionElement> provider = ProviderManager.getExtensionProvider(elementName, namespace);
        if (provider != null) {
            return (XmlElement)provider.parse(parser, outerXmlEnvironment);
        }
        return (XmlElement)StandardExtensionElementProvider.INSTANCE.parse(parser, outerXmlEnvironment);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StartTls parseStartTlsFeature(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        assert (parser.getNamespace().equals("urn:ietf:params:xml:ns:xmpp-tls"));
        int initialDepth = parser.getDepth();
        boolean required = false;
        block10: while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "required": {
                            required = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() == initialDepth) break block10;
                }
            }
        }
        ParserUtils.assertAtEndTag(parser);
        return new StartTls(required);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Session.Feature parseSessionFeature(XmlPullParser parser) throws XmlPullParserException, IOException {
        ParserUtils.assertAtStartTag(parser);
        int initialDepth = parser.getDepth();
        boolean optional = false;
        while (true) {
            XmlPullParser.Event event = parser.next();
            block0 : switch (event) {
                case START_ELEMENT: {
                    String name;
                    switch (name = parser.getName()) {
                        case "optional": {
                            optional = true;
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new Session.Feature(optional);
                }
            }
        }
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        PacketParserUtils.addExtensionElement(stanzaBuilder, parser, parser.getName(), parser.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(StanzaBuilder<?> stanzaBuilder, XmlPullParser parser, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        XmlElement extensionElement = PacketParserUtils.parseExtensionElement(elementName, namespace, parser, outerXmlEnvironment);
        stanzaBuilder.addExtension(extensionElement);
    }

    public static void addExtensionElement(Stanza packet, XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        ParserUtils.assertAtStartTag(parser);
        PacketParserUtils.addExtensionElement(packet, parser, parser.getName(), parser.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(Stanza packet, XmlPullParser parser, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        XmlElement packetExtension = PacketParserUtils.parseExtensionElement(elementName, namespace, parser, outerXmlEnvironment);
        packet.addExtension(packetExtension);
    }

    public static void addExtensionElement(Collection<XmlElement> collection, XmlPullParser parser, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        PacketParserUtils.addExtensionElement(collection, parser, parser.getName(), parser.getNamespace(), outerXmlEnvironment);
    }

    public static void addExtensionElement(Collection<XmlElement> collection, XmlPullParser parser, String elementName, String namespace, XmlEnvironment outerXmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        XmlElement packetExtension = PacketParserUtils.parseExtensionElement(elementName, namespace, parser, outerXmlEnvironment);
        collection.add(packetExtension);
    }

    private static interface StanzaBuilderSupplier<SB extends StanzaBuilder<?>> {
        public SB get(String var1);
    }
}

