/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jivesoftware.smack.util.CollectionUtil;

public class MultiMap<K, V> {
    public static final int DEFAULT_MAP_SIZE = 6;
    private static final int ENTRY_LIST_SIZE = 3;
    private final Map<K, List<V>> map;

    public MultiMap() {
        this(6);
    }

    public MultiMap(int size) {
        this(new LinkedHashMap(size));
    }

    private MultiMap(Map<K, List<V>> map) {
        this.map = map;
    }

    public int size() {
        int size = 0;
        for (List<V> list : this.map.values()) {
            size += list.size();
        }
        return size;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(V value) {
        for (List<V> list : this.map.values()) {
            if (!list.contains(value)) continue;
            return true;
        }
        return false;
    }

    public V getFirst(K key) {
        List<V> res = this.getAll(key);
        if (res.isEmpty()) {
            return null;
        }
        return res.iterator().next();
    }

    public List<V> getAll(K key) {
        List<Object> res = this.map.get(key);
        if (res == null) {
            res = Collections.emptyList();
        }
        return res;
    }

    public boolean put(K key, V value) {
        return this.putInternal(key, list -> list.add(value));
    }

    public boolean putFirst(K key, V value) {
        return this.putInternal(key, list -> list.add(0, value));
    }

    private boolean putInternal(K key, Consumer<List<V>> valueListConsumer) {
        boolean keyExisted;
        List<V> list = this.map.get(key);
        if (list == null) {
            list = new ArrayList<V>(3);
            this.map.put(key, list);
            keyExisted = false;
        } else {
            keyExisted = true;
        }
        valueListConsumer.accept(list);
        return keyExisted;
    }

    public V remove(K key) {
        List<V> res = this.map.remove(key);
        if (res == null) {
            return null;
        }
        assert (!res.isEmpty());
        return res.iterator().next();
    }

    public boolean removeOne(K key, V value) {
        List<V> list = this.map.get(key);
        if (list == null) {
            return false;
        }
        boolean res = list.remove(value);
        if (list.isEmpty()) {
            this.map.remove(key);
        }
        return res;
    }

    public List<V> remove(K key, int num) {
        List<V> values = this.map.get(key);
        if (values == null) {
            return Collections.emptyList();
        }
        int resultSize = values.size() > num ? num : values.size();
        ArrayList<V> result = new ArrayList<V>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            result.add(values.get(0));
        }
        if (values.isEmpty()) {
            this.map.remove(key);
        }
        return result;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.map.clear();
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public List<V> values() {
        ArrayList<V> values = new ArrayList<V>(this.size());
        for (List<V> list : this.map.values()) {
            values.addAll(list);
        }
        return values;
    }

    public Set<Map.Entry<K, V>> entrySet() {
        LinkedHashSet<Map.Entry<K, V>> entrySet = new LinkedHashSet<Map.Entry<K, V>>(this.size());
        for (Map.Entry<K, List<V>> entries : this.map.entrySet()) {
            K key = entries.getKey();
            for (V value : entries.getValue()) {
                entrySet.add(new SimpleMapEntry<K, V>(key, value));
            }
        }
        return entrySet;
    }

    public MultiMap<K, V> asUnmodifiableMultiMap() {
        LinkedHashMap<K, List<V>> mapCopy = new LinkedHashMap<K, List<V>>(this.map.size());
        for (Map.Entry<K, List<V>> entry : this.map.entrySet()) {
            K key = entry.getKey();
            List<V> values = entry.getValue();
            mapCopy.put(key, Collections.unmodifiableList(values));
        }
        return new MultiMap(Collections.unmodifiableMap(mapCopy));
    }

    public MultiMap<K, V> clone() {
        LinkedHashMap clonedMap = new LinkedHashMap(this.map.size());
        this.map.forEach((k, v) -> {
            ArrayList clonedList = CollectionUtil.newListWith(v);
            clonedMap.put(k, clonedList);
        });
        return new MultiMap(clonedMap);
    }

    private static final class SimpleMapEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private SimpleMapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V tmp = this.value;
            this.value = value;
            return tmp;
        }
    }
}

