/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.id.StandardStanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSource;
import org.jivesoftware.smack.packet.id.StanzaIdSourceFactory;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.DNSUtil;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.SslContextFactory;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.util.dns.SmackDaneProvider;
import org.jivesoftware.smack.util.dns.SmackDaneVerifier;
import org.jxmpp.JxmppContext;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;
import org.minidns.dnsname.DnsName;
import org.minidns.dnsname.InvalidDnsNameException;
import org.minidns.util.InetAddressUtil;

public abstract class ConnectionConfiguration {
    private static final Logger LOGGER;
    protected final DomainBareJid xmppServiceDomain;
    protected final DnsName xmppServiceDomainDnsName;
    protected final InetAddress hostAddress;
    protected final DnsName host;
    protected final UInt16 port;
    private final CallbackHandler callbackHandler;
    private final SmackDebuggerFactory debuggerFactory;
    private final SocketFactory socketFactory;
    private final CharSequence username;
    private final String password;
    private final Resourcepart resource;
    private final Locale language;
    private final EntityBareJid authzid;
    private final boolean sendPresence;
    private final SecurityMode securityMode;
    final SmackTlsContext smackTlsContext;
    private final DnssecMode dnssecMode;
    private final String[] enabledSSLProtocols;
    private final String[] enabledSSLCiphers;
    private final HostnameVerifier hostnameVerifier;
    protected final ProxyInfo proxy;
    protected final boolean allowNullOrEmptyUsername;
    private final Set<String> enabledSaslMechanisms;
    private final boolean compressionEnabled;
    private final StanzaIdSourceFactory stanzaIdSourceFactory;
    private final JxmppContext jxmppContext;

    protected ConnectionConfiguration(Builder<?, ?> builder) {
        DnsName xmppServiceDomainDnsName;
        try {
            this.smackTlsContext = ConnectionConfiguration.getSmackTlsContext(builder.dnssecMode, builder.sslContextFactory, builder.customX509TrustManager, builder.keyManagers, builder.sslContextSecureRandom, builder.keystoreType, builder.keystorePath, builder.callbackHandler, builder.pkcs11Library);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | UnrecoverableKeyException | CertificateException | UnsupportedCallbackException e) {
            throw new IllegalArgumentException(e);
        }
        this.authzid = builder.authzid;
        this.username = builder.username;
        this.password = builder.password;
        this.callbackHandler = builder.callbackHandler;
        this.resource = builder.resource;
        this.language = builder.language;
        this.xmppServiceDomain = builder.xmppServiceDomain;
        if (this.xmppServiceDomain == null) {
            throw new IllegalArgumentException("Must define the XMPP domain");
        }
        try {
            xmppServiceDomainDnsName = DnsName.from((CharSequence)this.xmppServiceDomain);
        }
        catch (InvalidDnsNameException e) {
            LOGGER.log(Level.INFO, "Could not transform XMPP service domain '" + String.valueOf(this.xmppServiceDomain) + "' to a DNS name. TLS X.509 certificate validiation may not be possible.", e);
            xmppServiceDomainDnsName = null;
        }
        this.xmppServiceDomainDnsName = xmppServiceDomainDnsName;
        this.hostAddress = builder.hostAddress;
        this.host = builder.host;
        this.port = builder.port;
        this.proxy = builder.proxy;
        this.socketFactory = builder.socketFactory;
        this.dnssecMode = builder.dnssecMode;
        this.securityMode = builder.securityMode;
        this.enabledSSLProtocols = builder.enabledSSLProtocols;
        this.enabledSSLCiphers = builder.enabledSSLCiphers;
        this.hostnameVerifier = builder.hostnameVerifier;
        this.sendPresence = builder.sendPresence;
        this.debuggerFactory = builder.debuggerFactory;
        this.allowNullOrEmptyUsername = builder.allowEmptyOrNullUsername;
        this.enabledSaslMechanisms = builder.enabledSaslMechanisms;
        this.compressionEnabled = builder.compressionEnabled;
        this.stanzaIdSourceFactory = builder.stanzaIdSourceFactory;
        this.jxmppContext = builder.jxmppContext;
        assert (this.enabledSaslMechanisms == null || !this.enabledSaslMechanisms.isEmpty());
    }

    private static SmackTlsContext getSmackTlsContext(DnssecMode dnssecMode, SslContextFactory sslContextFactory, X509TrustManager trustManager, KeyManager[] keyManagers, SecureRandom secureRandom, String keystoreType, String keystorePath, CallbackHandler callbackHandler, String pkcs11Library) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException, NoSuchProviderException, UnrecoverableKeyException, KeyManagementException, UnsupportedCallbackException, NoSuchMethodException, SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        SSLContext context = sslContextFactory != null ? sslContextFactory.createSslContext() : SSLContext.getInstance("TLS");
        if (keyManagers == null) {
            keyManagers = Builder.getKeyManagersFrom(keystoreType, keystorePath, callbackHandler, pkcs11Library);
        }
        SmackDaneVerifier daneVerifier = null;
        if (dnssecMode == DnssecMode.needsDnssecAndDane) {
            SmackDaneProvider daneProvider = DNSUtil.getDaneProvider();
            if (daneProvider == null) {
                throw new UnsupportedOperationException("DANE enabled but no SmackDaneProvider configured");
            }
            daneVerifier = daneProvider.newInstance();
            if (daneVerifier == null) {
                throw new IllegalStateException("DANE requested but DANE provider did not return a DANE verifier");
            }
            daneVerifier.init(context, keyManagers, trustManager, secureRandom);
        } else {
            TrustManager[] trustManagers = trustManager != null ? new TrustManager[]{trustManager} : null;
            context.init(keyManagers, trustManagers, secureRandom);
        }
        return new SmackTlsContext(context, daneVerifier, trustManager);
    }

    protected static JxmppContext getDefaultJxmppContext() {
        return SmackConfiguration.getDefaultJxmppContext();
    }

    public String getHostString() {
        if (this.hostAddress != null) {
            return this.hostAddress.toString();
        }
        if (this.host != null) {
            return this.host.toString();
        }
        return this.xmppServiceDomain.toString();
    }

    public DnsName getHost() {
        return this.host;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public UInt16 getPort() {
        return this.port;
    }

    @Deprecated
    public DomainBareJid getServiceName() {
        return this.xmppServiceDomain;
    }

    public DomainBareJid getXMPPServiceDomain() {
        return this.xmppServiceDomain;
    }

    public DnsName getXmppServiceDomainAsDnsNameIfPossible() {
        return this.xmppServiceDomainDnsName;
    }

    public JxmppContext getJxmppContext() {
        return this.jxmppContext;
    }

    public SecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public DnssecMode getDnssecMode() {
        return this.dnssecMode;
    }

    public String[] getEnabledSSLProtocols() {
        return this.enabledSSLProtocols;
    }

    public String[] getEnabledSSLCiphers() {
        return this.enabledSSLCiphers;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.smackTlsContext.sslContext.getSocketFactory();
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.hostnameVerifier != null) {
            return this.hostnameVerifier;
        }
        return SmackConfiguration.getDefaultHostnameVerifier();
    }

    public SmackDebuggerFactory getDebuggerFactory() {
        return this.debuggerFactory;
    }

    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public ProxyInfo getProxyInfo() {
        return this.proxy;
    }

    public CharSequence getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Resourcepart getResource() {
        return this.resource;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public String getXmlLang() {
        if (this.language == null) {
            return null;
        }
        String languageTag = this.language.toLanguageTag();
        if (languageTag.equals("und")) {
            return null;
        }
        return languageTag;
    }

    public EntityBareJid getAuthzid() {
        return this.authzid;
    }

    public boolean isSendPresence() {
        return this.sendPresence;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public boolean isEnabledSaslMechanism(String saslMechanism) {
        if (this.enabledSaslMechanisms == null) {
            return !SASLAuthentication.getBlacklistedSASLMechanisms().contains(saslMechanism);
        }
        return this.enabledSaslMechanisms.contains(saslMechanism);
    }

    public Set<String> getEnabledSaslMechanisms() {
        if (this.enabledSaslMechanisms == null) {
            return null;
        }
        return Collections.unmodifiableSet(this.enabledSaslMechanisms);
    }

    StanzaIdSource constructStanzaIdSource() {
        return this.stanzaIdSourceFactory.constructStanzaIdSource();
    }

    static {
        Smack.ensureInitialized();
        LOGGER = Logger.getLogger(ConnectionConfiguration.class.getName());
    }

    public static abstract class Builder<B extends Builder<B, C>, C extends ConnectionConfiguration> {
        private final JxmppContext jxmppContext;
        private SecurityMode securityMode = SecurityMode.required;
        private DnssecMode dnssecMode = DnssecMode.disabled;
        private KeyManager[] keyManagers;
        private SecureRandom sslContextSecureRandom;
        private String keystorePath;
        private String keystoreType;
        private String pkcs11Library = "pkcs11.config";
        private SslContextFactory sslContextFactory;
        private String[] enabledSSLProtocols;
        private String[] enabledSSLCiphers;
        private HostnameVerifier hostnameVerifier;
        private EntityBareJid authzid;
        private CharSequence username;
        private String password;
        private Resourcepart resource;
        private Locale language = Locale.getDefault();
        private boolean sendPresence = true;
        private ProxyInfo proxy;
        private CallbackHandler callbackHandler;
        private SmackDebuggerFactory debuggerFactory;
        private SocketFactory socketFactory;
        private DomainBareJid xmppServiceDomain;
        private InetAddress hostAddress;
        private DnsName host;
        private UInt16 port = UInt16.from(5222);
        private boolean allowEmptyOrNullUsername = false;
        private boolean saslMechanismsSealed;
        private Set<String> enabledSaslMechanisms;
        private X509TrustManager customX509TrustManager;
        private boolean compressionEnabled = false;
        private StanzaIdSourceFactory stanzaIdSourceFactory = new StandardStanzaIdSource.Factory();

        protected Builder(JxmppContext jxmppContext) {
            this.jxmppContext = jxmppContext;
            if (SmackConfiguration.DEBUG) {
                this.enableDefaultDebugger();
            }
        }

        public B setXmppAddressAndPassword(CharSequence jid, String password) throws XmppStringprepException {
            return this.setXmppAddressAndPassword(JidCreate.entityBareFrom((String)jid.toString(), (JxmppContext)this.jxmppContext), password);
        }

        public B setXmppAddressAndPassword(EntityBareJid jid, String password) {
            this.setUsernameAndPassword((CharSequence)jid.getLocalpart(), password);
            return this.setXmppDomain(jid.asDomainBareJid());
        }

        public B setUsernameAndPassword(CharSequence username, String password) {
            this.username = username;
            this.password = password;
            return this.getThis();
        }

        @Deprecated
        public B setServiceName(DomainBareJid serviceName) {
            return this.setXmppDomain(serviceName);
        }

        public B setXmppDomain(DomainBareJid xmppDomain) {
            this.xmppServiceDomain = xmppDomain;
            return this.getThis();
        }

        public B setXmppDomain(String xmppServiceDomain) throws XmppStringprepException {
            this.xmppServiceDomain = JidCreate.domainBareFrom((String)xmppServiceDomain, (JxmppContext)this.jxmppContext);
            return this.getThis();
        }

        public B setResource(Resourcepart resource) {
            this.resource = resource;
            return this.getThis();
        }

        public B setLanguage(Locale language) {
            this.language = language;
            return this.getThis();
        }

        public B setResource(CharSequence resource) throws XmppStringprepException {
            Objects.requireNonNull(resource, "resource must not be null");
            return this.setResource(Resourcepart.from((String)resource.toString()));
        }

        public B setHostAddress(InetAddress address) {
            this.hostAddress = address;
            return this.getThis();
        }

        public B setHost(CharSequence host) {
            String fqdnOrIpString = host.toString();
            if (InetAddressUtil.isIpAddress((CharSequence)fqdnOrIpString)) {
                InetAddress hostInetAddress;
                try {
                    hostInetAddress = InetAddress.getByName(fqdnOrIpString);
                }
                catch (UnknownHostException e) {
                    throw new AssertionError((Object)e);
                }
                this.setHostAddress(hostInetAddress);
            } else {
                DnsName dnsName = DnsName.from((String)fqdnOrIpString);
                this.setHost(dnsName);
            }
            return this.getThis();
        }

        public B setHost(DnsName host) {
            this.host = host;
            return this.getThis();
        }

        public B setPort(int port) {
            if (port < 0 || port > 65535) {
                throw new IllegalArgumentException("Port must be a 16-bit unsigned integer (i.e. between 0-65535. Port was: " + port);
            }
            UInt16 portUint16 = UInt16.from(port);
            return this.setPort(portUint16);
        }

        public B setPort(UInt16 port) {
            this.port = Objects.requireNonNull(port);
            return this.getThis();
        }

        @Deprecated
        public B setCallbackHandler(CallbackHandler callbackHandler) {
            this.callbackHandler = callbackHandler;
            return this.getThis();
        }

        public B setDnssecMode(DnssecMode dnssecMode) {
            this.dnssecMode = Objects.requireNonNull(dnssecMode, "DNSSEC mode must not be null");
            return this.getThis();
        }

        public B setCustomX509TrustManager(X509TrustManager x509TrustManager) {
            this.customX509TrustManager = x509TrustManager;
            return this.getThis();
        }

        public B setSecurityMode(SecurityMode securityMode) {
            this.securityMode = securityMode;
            return this.getThis();
        }

        public B setKeyManagers(KeyManager[] keyManagers) {
            this.keyManagers = keyManagers;
            return this.getThis();
        }

        public B setKeyManager(KeyManager keyManager) {
            KeyManager[] keyManagers = new KeyManager[]{keyManager};
            return this.setKeyManagers(keyManagers);
        }

        public B setSslContextSecureRandom(SecureRandom secureRandom) {
            this.sslContextSecureRandom = secureRandom;
            return this.getThis();
        }

        @Deprecated
        public B setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
            return this.getThis();
        }

        @Deprecated
        public B setKeystoreType(String keystoreType) {
            this.keystoreType = keystoreType;
            return this.getThis();
        }

        @Deprecated
        public B setPKCS11Library(String pkcs11Library) {
            this.pkcs11Library = pkcs11Library;
            return this.getThis();
        }

        public B setSslContextFactory(SslContextFactory sslContextFactory) {
            this.sslContextFactory = Objects.requireNonNull(sslContextFactory, "The provided SslContextFactory must not be null");
            return this.getThis();
        }

        public B setEnabledSSLProtocols(String[] enabledSSLProtocols) {
            this.enabledSSLProtocols = enabledSSLProtocols;
            return this.getThis();
        }

        public B setEnabledSSLCiphers(String[] enabledSSLCiphers) {
            this.enabledSSLCiphers = enabledSSLCiphers;
            return this.getThis();
        }

        public B setHostnameVerifier(HostnameVerifier verifier) {
            this.hostnameVerifier = verifier;
            return this.getThis();
        }

        public B setSendPresence(boolean sendPresence) {
            this.sendPresence = sendPresence;
            return this.getThis();
        }

        public B enableDefaultDebugger() {
            this.debuggerFactory = SmackConfiguration.getDefaultSmackDebuggerFactory();
            assert (this.debuggerFactory != null);
            return this.getThis();
        }

        public B setDebuggerFactory(SmackDebuggerFactory debuggerFactory) {
            this.debuggerFactory = debuggerFactory;
            return this.getThis();
        }

        public B setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this.getThis();
        }

        public B setProxyInfo(ProxyInfo proxyInfo) {
            this.proxy = proxyInfo;
            return this.getThis();
        }

        public B allowEmptyOrNullUsernames() {
            this.allowEmptyOrNullUsername = true;
            return this.getThis();
        }

        public B performSaslAnonymousAuthentication() {
            if (!SASLAuthentication.isSaslMechanismRegistered("ANONYMOUS")) {
                throw new IllegalArgumentException("SASL ANONYMOUS is not registered");
            }
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.addEnabledSaslMechanism("ANONYMOUS");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        public B performSaslExternalAuthentication(SSLContext sslContext) {
            if (!SASLAuthentication.isSaslMechanismRegistered("EXTERNAL")) {
                throw new IllegalArgumentException("SASL EXTERNAL is not registered");
            }
            this.setSslContextFactory(() -> sslContext);
            this.throwIfEnabledSaslMechanismsSet();
            this.allowEmptyOrNullUsernames();
            this.setSecurityMode(SecurityMode.required);
            this.addEnabledSaslMechanism("EXTERNAL");
            this.saslMechanismsSealed = true;
            return this.getThis();
        }

        private void throwIfEnabledSaslMechanismsSet() {
            if (this.enabledSaslMechanisms != null) {
                throw new IllegalStateException("Enabled SASL mechanisms found");
            }
        }

        public B addEnabledSaslMechanism(String saslMechanism) {
            return this.addEnabledSaslMechanism(Arrays.asList(StringUtils.requireNotNullNorEmpty(saslMechanism, "saslMechanism must not be null nor empty")));
        }

        public B addEnabledSaslMechanism(Collection<String> saslMechanisms) {
            if (this.saslMechanismsSealed) {
                throw new IllegalStateException("The enabled SASL mechanisms are sealed, you can not add new ones");
            }
            CollectionUtil.requireNotEmpty(saslMechanisms, "saslMechanisms");
            Set<String> blacklistedMechanisms = SASLAuthentication.getBlacklistedSASLMechanisms();
            for (String mechanism : saslMechanisms) {
                if (!SASLAuthentication.isSaslMechanismRegistered(mechanism)) {
                    throw new IllegalArgumentException("SASL " + mechanism + " is not available. Consider registering it with Smack");
                }
                if (!blacklistedMechanisms.contains(mechanism)) continue;
                throw new IllegalArgumentException("SALS " + mechanism + " is blacklisted.");
            }
            if (this.enabledSaslMechanisms == null) {
                this.enabledSaslMechanisms = new HashSet<String>(saslMechanisms.size());
            }
            this.enabledSaslMechanisms.addAll(saslMechanisms);
            return this.getThis();
        }

        public B setAuthzid(EntityBareJid authzid) {
            this.authzid = authzid;
            return this.getThis();
        }

        public B setCompressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this.getThis();
        }

        public B setStanzaIdSourceFactory(StanzaIdSourceFactory stanzaIdSourceFactory) {
            this.stanzaIdSourceFactory = Objects.requireNonNull(stanzaIdSourceFactory);
            return this.getThis();
        }

        public abstract C build();

        protected abstract B getThis();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static KeyManager[] getKeyManagersFrom(String keystoreType, String keystorePath, CallbackHandler callbackHandler, String pkcs11Library) throws NoSuchMethodException, SecurityException, ClassNotFoundException, KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, UnsupportedCallbackException, UnrecoverableKeyException {
            String keyManagerFactoryAlgorithm;
            KeyManagerFactory kmf;
            KeyManager[] keyManagers = null;
            KeyStore ks = null;
            PasswordCallback pcb = null;
            if ("PKCS11".equals(keystoreType)) {
                Constructor<?> c = Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(InputStream.class);
                String pkcs11Config = "name = SmartCard\nlibrary = " + pkcs11Library;
                ByteArrayInputStream config = new ByteArrayInputStream(pkcs11Config.getBytes(StandardCharsets.UTF_8));
                Provider p = (Provider)c.newInstance(config);
                Security.addProvider(p);
                ks = KeyStore.getInstance("PKCS11", p);
                pcb = new PasswordCallback("PKCS11 Password: ", false);
                callbackHandler.handle(new Callback[]{pcb});
                ks.load(null, pcb.getPassword());
            } else if ("Apple".equals(keystoreType)) {
                ks = KeyStore.getInstance("KeychainStore", "Apple");
                ks.load(null, null);
            } else if (keystoreType != null) {
                ks = KeyStore.getInstance(keystoreType);
                if (callbackHandler != null && StringUtils.isNotEmpty((CharSequence)keystorePath)) {
                    pcb = new PasswordCallback("Keystore Password: ", false);
                    callbackHandler.handle(new Callback[]{pcb});
                    ks.load(new FileInputStream(keystorePath), pcb.getPassword());
                } else {
                    FileInputStream stream = TLSUtils.getDefaultTruststoreStreamIfPossible();
                    try {
                        char[] password = "changeit".toCharArray();
                        try {
                            ks.load(stream, password);
                        }
                        finally {
                            CloseableUtil.maybeClose(stream);
                        }
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, "KeyStore load() threw, attempting 'jks' fallback", e);
                        ks = KeyStore.getInstance("jks");
                        stream = TLSUtils.getDefaultTruststoreStreamIfPossible();
                        try {
                            ks.load(stream, null);
                        }
                        finally {
                            CloseableUtil.maybeClose(stream);
                        }
                    }
                }
            }
            if (ks != null && (kmf = KeyManagerFactory.getInstance(keyManagerFactoryAlgorithm = KeyManagerFactory.getDefaultAlgorithm())) != null) {
                if (pcb == null) {
                    kmf.init(ks, null);
                } else {
                    kmf.init(ks, pcb.getPassword());
                    pcb.clearPassword();
                }
                keyManagers = kmf.getKeyManagers();
            }
            return keyManagers;
        }
    }

    public static enum DnssecMode {
        disabled,
        needsDnssec,
        needsDnssecAndDane;

    }

    public static enum SecurityMode {
        required,
        ifpossible,
        disabled;

    }
}

