/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;

public final class StanzaCollector
implements AutoCloseable {
    private final StanzaFilter packetFilter;
    private final ArrayDeque<Stanza> resultQueue;
    private final int maxQueueSize;
    private final StanzaCollector collectorToReset;
    private final XMPPConnection connection;
    private final Stanza request;
    private volatile boolean cancelled;
    private Exception connectionException;
    private volatile long waitStart;
    private List<Stanza> collectedCache;
    private String stringCache;

    StanzaCollector(XMPPConnection connection, Configuration configuration) {
        this.connection = connection;
        this.packetFilter = configuration.packetFilter;
        this.resultQueue = new ArrayDeque(configuration.size);
        this.maxQueueSize = configuration.size;
        this.collectorToReset = configuration.collectorToReset;
        this.request = configuration.request;
    }

    public synchronized void cancel() {
        if (this.cancelled) {
            return;
        }
        this.cancelled = true;
        this.connection.removeStanzaCollector(this);
        this.notifyAll();
        if (this.collectorToReset != null) {
            this.collectorToReset.cancel();
        }
    }

    public StanzaFilter getStanzaFilter() {
        return this.packetFilter;
    }

    public synchronized <P extends Stanza> P pollResult() {
        return (P)this.resultQueue.poll();
    }

    public <P extends Stanza> P pollResultOrThrow() throws XMPPException.XMPPErrorException {
        P result = this.pollResult();
        if (result != null) {
            XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        }
        return result;
    }

    public synchronized <P extends Stanza> P nextResultBlockForever() throws InterruptedException {
        this.throwIfCancelled();
        Stanza res;
        while ((res = this.resultQueue.poll()) == null) {
            if (this.cancelled) {
                return null;
            }
            this.wait();
        }
        return (P)res;
    }

    public <P extends Stanza> P nextResult() throws InterruptedException {
        return this.nextResult(this.connection.getReplyTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Stanza> P nextResult(long timeout) throws InterruptedException {
        this.throwIfCancelled();
        Stanza res = null;
        long remainingWait = timeout;
        this.waitStart = System.currentTimeMillis();
        while (remainingWait > 0L && this.connectionException == null && !this.cancelled) {
            StanzaCollector stanzaCollector = this;
            synchronized (stanzaCollector) {
                res = this.resultQueue.poll();
                if (res != null) {
                    return (P)res;
                }
                this.wait(remainingWait);
            }
            remainingWait = timeout - (System.currentTimeMillis() - this.waitStart);
        }
        return (P)res;
    }

    public <P extends Stanza> P nextResultOrThrow() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        return this.nextResultOrThrow(this.connection.getReplyTimeout());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends Stanza> P nextResultOrThrow(long timeout) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, InterruptedException, SmackException.NotConnectedException {
        P result;
        try {
            result = this.nextResult(timeout);
        }
        finally {
            this.cancel();
        }
        if (result == null) {
            if (this.connectionException != null) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter, this.connectionException);
            }
            if (!this.connection.isConnected()) {
                throw new SmackException.NotConnectedException(this.connection, this.packetFilter);
            }
            throw SmackException.NoResponseException.newWith(timeout, this, this.cancelled);
        }
        XMPPException.XMPPErrorException.ifHasErrorThenThrow(result);
        return result;
    }

    public List<Stanza> getCollectedStanzasAfterCancelled() {
        if (!this.cancelled) {
            throw new IllegalStateException("Stanza collector was not yet cancelled");
        }
        if (this.collectedCache == null) {
            this.collectedCache = new ArrayList<Stanza>(this.getCollectedCount());
            this.collectedCache.addAll(this.resultQueue);
        }
        return this.collectedCache;
    }

    public synchronized int getCollectedCount() {
        return this.resultQueue.size();
    }

    public String toString() {
        if (this.stringCache == null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Stanza Collector filter='").append(this.packetFilter).append('\'');
            if (this.request != null) {
                sb.append(" request='").append(this.request).append('\'');
            }
            this.stringCache = sb.toString();
        }
        return this.stringCache;
    }

    synchronized void notifyConnectionError(Exception exception) {
        this.connectionException = exception;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processStanza(Stanza packet) {
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            StanzaCollector stanzaCollector = this;
            synchronized (stanzaCollector) {
                if (this.resultQueue.size() == this.maxQueueSize) {
                    Stanza rolledOverStanza = this.resultQueue.poll();
                    assert (rolledOverStanza != null);
                }
                this.resultQueue.add(packet);
                this.notifyAll();
            }
            if (this.collectorToReset != null) {
                this.collectorToReset.waitStart = System.currentTimeMillis();
            }
        }
    }

    private void throwIfCancelled() {
        if (this.cancelled) {
            throw new IllegalStateException("Stanza collector already cancelled");
        }
    }

    public static Configuration newConfiguration() {
        return new Configuration();
    }

    @Override
    public void close() {
        this.cancel();
    }

    public static final class Configuration {
        private StanzaFilter packetFilter;
        private int size = SmackConfiguration.getStanzaCollectorSize();
        private StanzaCollector collectorToReset;
        private Stanza request;

        private Configuration() {
        }

        public Configuration setStanzaFilter(StanzaFilter stanzaFilter) {
            this.packetFilter = stanzaFilter;
            return this;
        }

        public Configuration setSize(int size) {
            this.size = size;
            return this;
        }

        public Configuration setCollectorToReset(StanzaCollector collector) {
            this.collectorToReset = collector;
            return this;
        }

        public Configuration setRequest(Stanza request) {
            this.request = request;
            return this;
        }
    }
}

