/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter.jidtype;

import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.Objects;
import org.jxmpp.jid.Jid;

public abstract class AbstractJidTypeFilter
implements StanzaFilter {
    private final JidType jidType;

    protected AbstractJidTypeFilter(JidType jidType) {
        this.jidType = Objects.requireNonNull(jidType, "jidType must not be null");
    }

    @Override
    public boolean accept(Stanza stanza) {
        Jid toMatch = this.getJidToMatchFrom(stanza);
        if (toMatch == null) {
            return false;
        }
        return this.jidType.isTypeOf(toMatch);
    }

    protected abstract Jid getJidToMatchFrom(Stanza var1);

    public final String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf((Object)this.jidType);
    }

    public static enum JidType {
        BareJid,
        DomainBareJid,
        DomainFullJid,
        DomainJid,
        EntityBareJid,
        EntityFullJid,
        EntityJid,
        FullJid;


        public boolean isTypeOf(Jid jid) {
            if (jid == null) {
                return false;
            }
            switch (this.ordinal()) {
                case 0: {
                    return jid.hasNoResource();
                }
                case 1: {
                    return jid.isDomainBareJid();
                }
                case 2: {
                    return jid.isDomainFullJid();
                }
                case 4: {
                    return jid.isEntityBareJid();
                }
                case 5: {
                    return jid.isEntityFullJid();
                }
                case 6: {
                    return jid.isEntityJid();
                }
                case 7: {
                    return jid.hasResource();
                }
            }
            throw new IllegalStateException();
        }
    }
}

