/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smack.util.SHA1;

public class StringUtils {
    public static final String MD5 = "MD5";
    public static final String SHA1 = "SHA-1";
    public static final String QUOTE_ENCODE = "&quot;";
    public static final String APOS_ENCODE = "&apos;";
    public static final String AMP_ENCODE = "&amp;";
    public static final String LT_ENCODE = "&lt;";
    public static final String GT_ENCODE = "&gt;";
    public static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();
    public static final String UNAMBIGUOUS_NUMBERS_AND_LETTERS_STRING = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ";
    private static final char[] UNAMBIGUOUS_NUMBERS_AND_LETTERS = "123456789ABCDEFGHIJKLMNPQRSTUVWXYZ".toCharArray();
    private static final int RANDOM_STRING_CHUNK_SIZE = 4;
    private static final Pattern XML_WHITESPACE = Pattern.compile("[\t\n\r ]");
    public static final String PORTABLE_NEWLINE_REGEX = "\\r?\\n";

    public static CharSequence escapeForXml(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.safe);
    }

    public static CharSequence escapeForXmlAttribute(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forAttribute);
    }

    public static CharSequence escapeForXmlAttributeApos(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forAttributeApos);
    }

    public static CharSequence escapeForXmlText(CharSequence input) {
        return StringUtils.escapeForXml(input, XmlEscapeMode.forText);
    }

    private static CharSequence escapeForXml(CharSequence input, XmlEscapeMode xmlEscapeMode) {
        if (input == null) {
            return null;
        }
        int len = input.length();
        StringBuilder out = new StringBuilder((int)((double)len * 1.3));
        int last = 0;
        int i = 0;
        while (i < len) {
            String toAppend = null;
            char ch = input.charAt(i);
            block0 : switch (xmlEscapeMode.ordinal()) {
                case 0: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '>': {
                            toAppend = GT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            toAppend = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\"': {
                            toAppend = QUOTE_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                        case '\'': {
                            toAppend = APOS_ENCODE;
                            break block0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (ch) {
                        case '<': {
                            toAppend = LT_ENCODE;
                            break block0;
                        }
                        case '&': {
                            toAppend = AMP_ENCODE;
                            break block0;
                        }
                    }
                }
            }
            if (toAppend != null) {
                if (i > last) {
                    out.append(input, last, i);
                }
                out.append((CharSequence)toAppend);
                last = ++i;
                continue;
            }
            ++i;
        }
        if (last == 0) {
            return input;
        }
        if (i > last) {
            out.append(input, last, i);
        }
        return out;
    }

    @Deprecated
    public static synchronized String hash(String data) {
        return org.jivesoftware.smack.util.SHA1.hex(data);
    }

    public static String encodeHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_CHARS[v >>> 4];
            hexChars[j * 2 + 1] = HEX_CHARS[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] toUtf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String insecureRandomString(int length) {
        return StringUtils.randomString(length, RandomUtil.RANDOM.get());
    }

    public static String secureOnlineAttackSafeRandomString() {
        int REQUIRED_LENGTH = 10;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 10);
    }

    public static String secureUniqueRandomString() {
        int REQUIRED_LENGTH = 13;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 13);
    }

    public static String secureOfflineAttackSafeRandomString() {
        int REQUIRED_LENGTH = 24;
        return StringUtils.randomString(RandomUtil.SECURE_RANDOM.get(), UNAMBIGUOUS_NUMBERS_AND_LETTERS, 24);
    }

    private static String randomString(Random random, char[] alphabet, int numRandomChars) {
        int bufferSize = numRandomChars + (numRandomChars - 1) / 4;
        CharBuffer charBuffer = CharBuffer.allocate(bufferSize);
        try {
            StringUtils.randomString(charBuffer, random, alphabet, numRandomChars);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        ((Buffer)charBuffer).flip();
        return charBuffer.toString();
    }

    private static void randomString(Appendable appendable, Random random, char[] alphabet, int numRandomChars) throws IOException {
        for (int randomCharNum = 1; randomCharNum <= numRandomChars; ++randomCharNum) {
            int randomIndex = random.nextInt(alphabet.length);
            char randomChar = alphabet[randomIndex];
            appendable.append(randomChar);
            if (randomCharNum % 4 != 0 || randomCharNum >= numRandomChars) continue;
            appendable.append('-');
        }
    }

    public static String randomString(int length) {
        return StringUtils.randomString(length, RandomUtil.SECURE_RANDOM.get());
    }

    public static String randomString(int length, Random random) {
        if (length == 0) {
            return "";
        }
        char[] randomChars = new char[length];
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(UNAMBIGUOUS_NUMBERS_AND_LETTERS.length);
            randomChars[i] = UNAMBIGUOUS_NUMBERS_AND_LETTERS[index];
        }
        return new String(randomChars);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isNullOrEmpty(cs);
    }

    public static boolean isNullOrEmpty(CharSequence cs) {
        return cs == null || StringUtils.isEmpty(cs);
    }

    public static boolean isNotEmpty(CharSequence ... css) {
        for (CharSequence cs : css) {
            if (!StringUtils.isNullOrEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrEmpty(CharSequence ... css) {
        for (CharSequence cs : css) {
            if (!StringUtils.isNotEmpty(cs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrNotEmpty(CharSequence cs) {
        if (cs == null) {
            return true;
        }
        return !cs.toString().isEmpty();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs.length() == 0;
    }

    public static String collectionToString(Collection<? extends Object> collection) {
        return StringUtils.toStringBuilder(collection, " ").toString();
    }

    public static StringBuilder toStringBuilder(Collection<? extends Object> collection, String delimiter) {
        StringBuilder sb = new StringBuilder(collection.size() * 20);
        StringUtils.appendTo(collection, delimiter, sb);
        return sb;
    }

    public static void appendTo(Collection<? extends Object> collection, StringBuilder sb) {
        StringUtils.appendTo(collection, ", ", sb);
    }

    public static <O> void appendTo(Collection<O> collection, StringBuilder sb, Consumer<O> appendFunction) {
        StringUtils.appendTo(collection, ", ", sb, appendFunction);
    }

    public static void appendTo(Collection<? extends Object> collection, String delimiter, StringBuilder sb) {
        StringUtils.appendTo(collection, delimiter, sb, o -> sb.append(o));
    }

    public static <O> void appendTo(Collection<O> collection, String delimiter, StringBuilder sb, Consumer<O> appendFunction) {
        Iterator<O> it = collection.iterator();
        while (it.hasNext()) {
            O cs = it.next();
            appendFunction.accept(cs);
            if (!it.hasNext()) continue;
            sb.append(delimiter);
        }
    }

    public static String returnIfNotEmptyTrimmed(String string) {
        if (string == null) {
            return null;
        }
        String trimmedString = string.trim();
        if (trimmedString.length() > 0) {
            return trimmedString;
        }
        return null;
    }

    public static boolean nullSafeCharSequenceEquals(CharSequence csOne, CharSequence csTwo) {
        return StringUtils.nullSafeCharSequenceComparator(csOne, csTwo) == 0;
    }

    public static int nullSafeCharSequenceComparator(CharSequence csOne, CharSequence csTwo) {
        if (csOne == null ^ csTwo == null) {
            return csOne == null ? -1 : 1;
        }
        if (csOne == null && csTwo == null) {
            return 0;
        }
        return csOne.toString().compareTo(csTwo.toString());
    }

    @Deprecated
    public static <CS extends CharSequence> CS requireNotNullOrEmpty(CS cs, String message) {
        return StringUtils.requireNotNullNorEmpty(cs, message);
    }

    public static <CS extends CharSequence> CS requireNotNullNorEmpty(CS cs, String message) {
        if (StringUtils.isNullOrEmpty(cs)) {
            throw new IllegalArgumentException(message);
        }
        return cs;
    }

    public static <CS extends CharSequence> CS requireNullOrNotEmpty(CS cs, String message) {
        if (cs == null) {
            return null;
        }
        if (StringUtils.isEmpty(cs)) {
            throw new IllegalArgumentException(message);
        }
        return cs;
    }

    public static String maybeToString(CharSequence cs) {
        if (cs == null) {
            return null;
        }
        return cs.toString();
    }

    public static String deleteXmlWhitespace(String string) {
        return XML_WHITESPACE.matcher(string).replaceAll("");
    }

    public static Appendable appendHeading(Appendable appendable, String heading) throws IOException {
        return StringUtils.appendHeading(appendable, heading, '-');
    }

    public static Appendable appendHeading(Appendable appendable, String heading, char underlineChar) throws IOException {
        appendable.append(heading).append('\n');
        for (int i = 0; i < heading.length(); ++i) {
            appendable.append(underlineChar);
        }
        return appendable.append('\n');
    }

    public static List<String> splitLinesPortable(String input) {
        String[] lines = input.split(PORTABLE_NEWLINE_REGEX);
        return Arrays.asList(lines);
    }

    public static List<String> toStrings(Collection<? extends CharSequence> charSequences) {
        ArrayList<String> res = new ArrayList<String>(charSequences.size());
        for (CharSequence charSequence : charSequences) {
            String string = charSequence.toString();
            res.add(string);
        }
        return res;
    }

    private static enum XmlEscapeMode {
        safe,
        forAttribute,
        forAttributeApos,
        forText;

    }
}

