/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.c2s;

import java.io.IOException;
import java.net.InetAddress;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.StreamOpenAndCloseFactory;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.fsm.ConnectionStateEvent;
import org.jivesoftware.smack.fsm.ConnectionStateMachineListener;
import org.jivesoftware.smack.fsm.LoginContext;
import org.jivesoftware.smack.fsm.NoOpState;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateDescriptorGraph;
import org.jivesoftware.smack.fsm.StateMachineException;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.internal.AbstractStats;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.AbstractStreamClose;
import org.jivesoftware.smack.packet.AbstractStreamOpen;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.sasl.SASLErrorException;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.ArrayBlockingQueueWithShutdown;
import org.jivesoftware.smack.util.ExtendedAppendable;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.XmppStringUtils;

public final class ModularXmppClientToServerConnection
extends AbstractXMPPConnection {
    private static final Logger LOGGER = Logger.getLogger(ModularXmppClientToServerConnectionConfiguration.class.getName());
    private final ArrayBlockingQueueWithShutdown<TopLevelStreamElement> outgoingElementsQueue = new ArrayBlockingQueueWithShutdown(100, true);
    private XmppClientToServerTransport activeTransport;
    private final List<ConnectionStateMachineListener> connectionStateMachineListeners = new CopyOnWriteArrayList<ConnectionStateMachineListener>();
    private boolean featuresReceived;
    private boolean streamResumed;
    private StateDescriptorGraph.GraphVertex<State> currentStateVertex;
    private List<State> walkFromDisconnectToAuthenticated;
    private final ModularXmppClientToServerConnectionConfiguration configuration;
    private final ModularXmppClientToServerConnectionInternal connectionInternal;
    private final Map<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, ModularXmppClientToServerConnectionModule<? extends ModularXmppClientToServerConnectionModuleDescriptor>> connectionModules = new HashMap<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, ModularXmppClientToServerConnectionModule<? extends ModularXmppClientToServerConnectionModuleDescriptor>>();
    private final Map<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport> transports = new HashMap<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport>();
    private final List<XmppInputOutputFilter> inputOutputFilters = new CopyOnWriteArrayList<XmppInputOutputFilter>();
    private List<XmppInputOutputFilter> previousInputOutputFilters;
    private boolean compressionEnabled;

    public ModularXmppClientToServerConnection(ModularXmppClientToServerConnectionConfiguration configuration) {
        super(configuration);
        this.configuration = configuration;
        this.connectionInternal = new ModularXmppClientToServerConnectionInternal(this, this.getReactor(), this.debugger, this.outgoingElementsQueue){

            @Override
            public void parseAndProcessElement(String wrappedCompleteElement) {
                ModularXmppClientToServerConnection.this.parseAndProcessElement(wrappedCompleteElement);
            }

            @Override
            public void notifyConnectionError(Exception e) {
                ModularXmppClientToServerConnection.this.notifyConnectionError(e);
            }

            @Override
            public String onStreamOpen(XmlPullParser parser) {
                return ModularXmppClientToServerConnection.this.onStreamOpen(parser);
            }

            @Override
            public void onStreamClosed() {
                ModularXmppClientToServerConnection.this.closingStreamReceived = true;
                this.notifyWaitingThreads();
            }

            @Override
            public void fireFirstLevelElementSendListeners(TopLevelStreamElement element) {
                ModularXmppClientToServerConnection.this.firePacketSendingListeners(element);
            }

            @Override
            public void invokeConnectionStateMachineListener(ConnectionStateEvent connectionStateEvent) {
                ModularXmppClientToServerConnection.this.invokeConnectionStateMachineListener(connectionStateEvent);
            }

            @Override
            public XmlEnvironment getOutgoingStreamXmlEnvironment() {
                return ModularXmppClientToServerConnection.this.outgoingStreamXmlEnvironment;
            }

            @Override
            public void addXmppInputOutputFilter(XmppInputOutputFilter xmppInputOutputFilter) {
                ModularXmppClientToServerConnection.this.inputOutputFilters.add(0, xmppInputOutputFilter);
            }

            @Override
            public ListIterator<XmppInputOutputFilter> getXmppInputOutputFilterBeginIterator() {
                return ModularXmppClientToServerConnection.this.inputOutputFilters.listIterator();
            }

            @Override
            public ListIterator<XmppInputOutputFilter> getXmppInputOutputFilterEndIterator() {
                return ModularXmppClientToServerConnection.this.inputOutputFilters.listIterator(ModularXmppClientToServerConnection.this.inputOutputFilters.size());
            }

            @Override
            public void waitForFeaturesReceived(String waitFor) throws InterruptedException, SmackException, XMPPException {
                ModularXmppClientToServerConnection.this.waitForFeaturesReceived(waitFor);
            }

            @Override
            public void newStreamOpenWaitForFeaturesSequence(String waitFor) throws InterruptedException, SmackException, XMPPException {
                ModularXmppClientToServerConnection.this.newStreamOpenWaitForFeaturesSequence(waitFor);
            }

            @Override
            public SmackTlsContext getSmackTlsContext() {
                return ModularXmppClientToServerConnection.this.getSmackTlsContext();
            }

            @Override
            public <SN extends Nonza, FN extends Nonza> SN sendAndWaitForResponse(Nonza nonza, Class<SN> successNonzaClass, Class<FN> failedNonzaClass) throws SmackException.NoResponseException, SmackException.NotConnectedException, XMPPException.FailedNonzaException, InterruptedException {
                return (SN)ModularXmppClientToServerConnection.this.sendAndWaitForResponse(nonza, successNonzaClass, failedNonzaClass);
            }

            @Override
            public void asyncGo(Runnable runnable) {
                ModularXmppClientToServerConnection.asyncGo(runnable);
            }

            @Override
            public void waitForConditionOrThrowConnectionException(Supplier<Boolean> condition, String waitFor) throws InterruptedException, SmackException.SmackWrappedException, SmackException.NoResponseException {
                ModularXmppClientToServerConnection.this.waitForConditionOrThrowConnectionException(condition, waitFor);
            }

            @Override
            public void notifyWaitingThreads() {
                ModularXmppClientToServerConnection.this.notifyWaitingThreads();
            }

            @Override
            public void setCompressionEnabled(boolean compressionEnabled) {
                ModularXmppClientToServerConnection.this.compressionEnabled = compressionEnabled;
            }

            @Override
            public void setTransport(XmppClientToServerTransport xmppTransport) {
                ModularXmppClientToServerConnection.this.activeTransport = xmppTransport;
                ModularXmppClientToServerConnection.this.connected = true;
            }
        };
        for (ModularXmppClientToServerConnectionModuleDescriptor moduleDescriptor : configuration.moduleDescriptors) {
            Class<?> moduleDescriptorClass = moduleDescriptor.getClass();
            ModularXmppClientToServerConnectionModule<? extends ModularXmppClientToServerConnectionModuleDescriptor> connectionModule = moduleDescriptor.constructXmppConnectionModule(this.connectionInternal);
            this.connectionModules.put(moduleDescriptorClass, connectionModule);
            XmppClientToServerTransport transport = connectionModule.getTransport();
            if (transport == null) continue;
            this.transports.put(moduleDescriptorClass, transport);
        }
        StateDescriptorGraph.GraphVertex<StateDescriptor> initialStateDescriptorVertex = configuration.initialStateDescriptorVertex;
        this.currentStateVertex = StateDescriptorGraph.convertToStateGraph(initialStateDescriptorVertex, this.connectionInternal);
    }

    public <CM extends ModularXmppClientToServerConnectionModule<? extends ModularXmppClientToServerConnectionModuleDescriptor>> CM getConnectionModuleFor(Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> descriptorClass) {
        return (CM)this.connectionModules.get(descriptorClass);
    }

    @Override
    protected void loginInternal(String username, String password, Resourcepart resource) throws XMPPException, SmackException, IOException, InterruptedException {
        WalkStateGraphContext walkStateGraphContext = this.buildNewWalkTo(AuthenticatedAndResourceBoundStateDescriptor.class).withLoginContext(username, password, resource).build();
        this.walkStateGraph(walkStateGraphContext);
    }

    private WalkStateGraphContext.Builder buildNewWalkTo(Class<? extends StateDescriptor> finalStateClass) {
        return WalkStateGraphContext.builder(this.currentStateVertex.getElement().getStateDescriptor().getClass(), finalStateClass);
    }

    private void unwindState(State revertedState) {
        this.invokeConnectionStateMachineListener(new ConnectionStateEvent.StateRevertBackwardsWalk(revertedState));
        revertedState.resetState();
    }

    private void walkStateGraph(WalkStateGraphContext walkStateGraphContext) throws XMPPException, IOException, SmackException, InterruptedException {
        StateDescriptorGraph.GraphVertex<State> previousStateVertex = this.currentStateVertex;
        try {
            this.walkStateGraphInternal(walkStateGraphContext);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            this.currentStateVertex = previousStateVertex;
            State revertedState = this.currentStateVertex.getElement();
            this.unwindState(revertedState);
            throw e;
        }
    }

    private void walkStateGraphInternal(WalkStateGraphContext walkStateGraphContext) throws IOException, SmackException, InterruptedException, XMPPException {
        StateDescriptorGraph.GraphVertex<State> initialStateVertex = this.currentStateVertex;
        State initialState = initialStateVertex.getElement();
        StateDescriptor initialStateDescriptor = initialState.getStateDescriptor();
        walkStateGraphContext.recordWalkTo(initialState);
        if (walkStateGraphContext.isWalksFinalState(initialStateDescriptor)) {
            assert (initialStateDescriptor.isFinalState());
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.FinalStateReached(initialState));
            return;
        }
        List<StateDescriptorGraph.GraphVertex<State>> outgoingStateEdges = initialStateVertex.getOutgoingEdges();
        StateDescriptorGraph.GraphVertex<State> mandatoryIntermediateStateVertex = walkStateGraphContext.maybeReturnMandatoryImmediateState(outgoingStateEdges);
        if (mandatoryIntermediateStateVertex != null) {
            StateTransitionResult reason = this.attemptEnterState(mandatoryIntermediateStateVertex, walkStateGraphContext);
            if (reason instanceof StateTransitionResult.Success) {
                this.walkStateGraph(walkStateGraphContext);
                return;
            }
            throw new StateMachineException.SmackMandatoryStateFailedException(mandatoryIntermediateStateVertex.getElement(), reason);
        }
        Iterator<StateDescriptorGraph.GraphVertex<State>> it = outgoingStateEdges.iterator();
        while (it.hasNext()) {
            StateDescriptorGraph.GraphVertex<State> successorStateVertex = it.next();
            State successorState = successorStateVertex.getElement();
            if (walkStateGraphContext.wouldCauseCycle(successorStateVertex)) {
                this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionIgnoredDueCycle(initialStateVertex, successorStateVertex));
            } else {
                StateTransitionResult result = this.attemptEnterState(successorStateVertex, walkStateGraphContext);
                if (result instanceof StateTransitionResult.Success) break;
                if (result != null) {
                    walkStateGraphContext.recordFailedState(successorState, result);
                }
            }
            if (it.hasNext()) continue;
            throw StateMachineException.SmackStateGraphDeadEndException.from(walkStateGraphContext, initialStateVertex);
        }
        this.walkStateGraph(walkStateGraphContext);
    }

    private StateTransitionResult attemptEnterState(StateDescriptorGraph.GraphVertex<State> successorStateVertex, WalkStateGraphContext walkStateGraphContext) throws SmackException, XMPPException, IOException, InterruptedException {
        StateTransitionResult.AttemptResult transitionAttemptResult;
        StateDescriptorGraph.GraphVertex<State> initialStateVertex = this.currentStateVertex;
        State initialState = initialStateVertex.getElement();
        State successorState = successorStateVertex.getElement();
        StateDescriptor successorStateDescriptor = successorState.getStateDescriptor();
        if (!successorStateDescriptor.isMultiVisitState() && walkStateGraphContext.stateAlreadyVisited(successorState)) {
            return null;
        }
        if (successorStateDescriptor.isNotImplemented()) {
            StateTransitionResult.TransitionImpossibleBecauseNotImplemented transtionImpossibleBecauseNotImplemented = new StateTransitionResult.TransitionImpossibleBecauseNotImplemented(successorStateDescriptor);
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionNotPossible(initialState, successorState, transtionImpossibleBecauseNotImplemented));
            return transtionImpossibleBecauseNotImplemented;
        }
        try {
            StateTransitionResult.TransitionImpossible transitionImpossible = successorState.isTransitionToPossible(walkStateGraphContext);
            if (transitionImpossible != null) {
                this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionNotPossible(initialState, successorState, transitionImpossible));
                return transitionImpossible;
            }
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.AboutToTransitionInto(initialState, successorState));
            transitionAttemptResult = successorState.transitionInto(walkStateGraphContext);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            this.unwindState(successorState);
            throw e;
        }
        if (transitionAttemptResult instanceof StateTransitionResult.Failure) {
            StateTransitionResult.Failure transitionFailureResult = (StateTransitionResult.Failure)transitionAttemptResult;
            this.invokeConnectionStateMachineListener(new ConnectionStateEvent.TransitionFailed(initialState, successorState, transitionFailureResult));
            return transitionAttemptResult;
        }
        StateTransitionResult.Success transitionSuccessResult = (StateTransitionResult.Success)transitionAttemptResult;
        this.currentStateVertex = successorStateVertex;
        this.invokeConnectionStateMachineListener(new ConnectionStateEvent.SuccessfullyTransitionedInto(successorState, transitionSuccessResult));
        return transitionSuccessResult;
    }

    @Override
    protected void sendInternal(TopLevelStreamElement element) throws SmackException.NotConnectedException, InterruptedException {
        XmppClientToServerTransport transport = this.activeTransport;
        if (transport == null) {
            throw new SmackException.NotConnectedException();
        }
        this.outgoingElementsQueue.put(element);
        transport.notifyAboutNewOutgoingElements();
    }

    @Override
    protected void sendNonBlockingInternal(TopLevelStreamElement element) throws SmackException.NotConnectedException, SmackException.OutgoingQueueFullException {
        XmppClientToServerTransport transport = this.activeTransport;
        if (transport == null) {
            throw new SmackException.NotConnectedException();
        }
        boolean enqueued = this.outgoingElementsQueue.offer(element);
        if (!enqueued) {
            throw new SmackException.OutgoingQueueFullException();
        }
        transport.notifyAboutNewOutgoingElements();
    }

    @Override
    protected void shutdown() {
        this.shutdown(false);
    }

    @Override
    public synchronized void instantShutdown() {
        this.shutdown(true);
    }

    @Override
    public ModularXmppClientToServerConnectionConfiguration getConfiguration() {
        return this.configuration;
    }

    private void shutdown(boolean instant) {
        Class mandatoryIntermediateState = instant ? InstantShutdownStateDescriptor.class : ShutdownStateDescriptor.class;
        WalkStateGraphContext context = this.buildNewWalkTo(DisconnectedStateDescriptor.class).withMandatoryIntermediateState(mandatoryIntermediateState).build();
        try {
            this.walkStateGraph(context);
        }
        catch (IOException | InterruptedException | SmackException | XMPPException e) {
            throw new IllegalStateException("A walk to disconnected state should never throw", e);
        }
    }

    private SSLSession getSSLSession() {
        XmppClientToServerTransport transport = this.activeTransport;
        if (transport == null) {
            return null;
        }
        return transport.getSslSession();
    }

    @Override
    protected void afterFeaturesReceived() {
        this.featuresReceived = true;
        this.notifyWaitingThreads();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseAndProcessElement(String element) {
        try {
            XmlPullParser parser = PacketParserUtils.getParserFor(element);
            parser.next();
            XmlPullParser.Event event = parser.getEventType();
            while (true) {
                block1 : switch (event) {
                    case START_ELEMENT: {
                        String name;
                        switch (name = parser.getName()) {
                            case "message": 
                            case "iq": 
                            case "presence": {
                                this.parseAndProcessStanza(parser);
                                break block1;
                            }
                            case "error": {
                                StreamError streamError = PacketParserUtils.parseStreamError(parser, null, this.getJxmppContext());
                                XMPPException.StreamErrorException streamErrorException = new XMPPException.StreamErrorException(streamError);
                                this.setCurrentConnectionExceptionAndNotify(streamErrorException);
                                throw streamErrorException;
                            }
                            case "features": {
                                this.parseFeatures(parser);
                                this.afterFeaturesReceived();
                                break block1;
                            }
                        }
                        this.parseAndProcessNonza(parser);
                        break;
                    }
                    case END_DOCUMENT: {
                        return;
                    }
                }
                event = parser.next();
            }
        }
        catch (IOException | InterruptedException | XMPPException.StreamErrorException | SmackParsingException | XmlPullParserException e) {
            this.notifyConnectionError((Exception)e);
        }
    }

    private synchronized void prepareToWaitForFeaturesReceived() {
        this.featuresReceived = false;
    }

    private void waitForFeaturesReceived(String waitFor) throws InterruptedException, SmackException, XMPPException {
        this.waitForConditionOrThrowConnectionException(() -> this.featuresReceived, waitFor);
    }

    @Override
    protected AbstractStreamOpen getStreamOpen(DomainBareJid to, CharSequence from, String id, String lang) {
        StreamOpenAndCloseFactory streamOpenAndCloseFactory = this.activeTransport.getStreamOpenAndCloseFactory();
        return streamOpenAndCloseFactory.createStreamOpen(to, from, id, lang);
    }

    private void newStreamOpenWaitForFeaturesSequence(String waitFor) throws InterruptedException, SmackException, XMPPException {
        this.prepareToWaitForFeaturesReceived();
        StreamOpenAndCloseFactory streamOpenAndCloseFactory = this.activeTransport.getStreamOpenAndCloseFactory();
        String from = null;
        CharSequence localpart = this.connectionInternal.connection.getConfiguration().getUsername();
        DomainBareJid xmppServiceDomain = this.getXMPPServiceDomain();
        if (localpart != null) {
            from = XmppStringUtils.completeJidFrom((CharSequence)localpart, (CharSequence)xmppServiceDomain);
        }
        AbstractStreamOpen streamOpen = streamOpenAndCloseFactory.createStreamOpen(xmppServiceDomain, from, this.getStreamId(), this.getConfiguration().getXmlLang());
        this.sendStreamOpen(streamOpen);
        this.waitForFeaturesReceived(waitFor);
    }

    private void sendStreamOpen(AbstractStreamOpen streamOpen) throws SmackException.NotConnectedException, InterruptedException {
        this.sendNonza(streamOpen);
        this.updateOutgoingStreamXmlEnvironmentOnStreamOpen(streamOpen);
    }

    @Override
    public boolean isUsingCompression() {
        return this.compressionEnabled;
    }

    public void addConnectionStateMachineListener(ConnectionStateMachineListener connectionStateMachineListener) {
        this.connectionStateMachineListeners.add(connectionStateMachineListener);
    }

    public boolean removeConnectionStateMachineListener(ConnectionStateMachineListener connectionStateMachineListener) {
        return this.connectionStateMachineListeners.remove(connectionStateMachineListener);
    }

    private void invokeConnectionStateMachineListener(ConnectionStateEvent connectionStateEvent) {
        if (this.connectionStateMachineListeners.isEmpty()) {
            return;
        }
        ASYNC_BUT_ORDERED.performAsyncButOrdered(this, () -> {
            for (ConnectionStateMachineListener connectionStateMachineListener : this.connectionStateMachineListeners) {
                connectionStateMachineListener.onConnectionStateEvent(connectionStateEvent, this);
            }
        });
    }

    @Override
    public boolean isSecureConnection() {
        XmppClientToServerTransport transport = this.activeTransport;
        if (transport == null) {
            return false;
        }
        return transport.isTransportSecured();
    }

    @Override
    protected void connectInternal() throws SmackException, IOException, XMPPException, InterruptedException {
        WalkStateGraphContext walkStateGraphContext = this.buildNewWalkTo(ConnectedButUnauthenticatedStateDescriptor.class).build();
        this.walkStateGraph(walkStateGraphContext);
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getFilterStats() {
        List<XmppInputOutputFilter> filters;
        ModularXmppClientToServerConnection modularXmppClientToServerConnection = this;
        synchronized (modularXmppClientToServerConnection) {
            filters = this.inputOutputFilters.isEmpty() && this.previousInputOutputFilters != null ? this.previousInputOutputFilters : this.inputOutputFilters;
        }
        HashMap<String, Object> filterStats = new HashMap<String, Object>(filters.size());
        for (XmppInputOutputFilter xmppInputOutputFilter : filters) {
            Object stats = xmppInputOutputFilter.getStats();
            String filterName = xmppInputOutputFilter.getFilterName();
            filterStats.put(filterName, stats);
        }
        return filterStats;
    }

    public Stats getStats() {
        HashMap<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport.Stats> transportsStats = new HashMap<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport.Stats>(this.transports.size());
        for (Map.Entry<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport> entry : this.transports.entrySet()) {
            XmppClientToServerTransport.Stats transportStats = entry.getValue().getStats();
            transportsStats.put(entry.getKey(), transportStats);
        }
        Map<String, Object> filterStats = this.getFilterStats();
        return new Stats(transportsStats, filterStats);
    }

    public static final class AuthenticatedAndResourceBoundStateDescriptor
    extends StateDescriptor {
        private AuthenticatedAndResourceBoundStateDescriptor() {
            super(AuthenticatedAndResourceBoundState.class, StateDescriptor.Property.finalState);
            this.addSuccessor(InstantShutdownStateDescriptor.class);
            this.addSuccessor(ShutdownStateDescriptor.class);
        }
    }

    static final class InstantShutdownStateDescriptor
    extends StateDescriptor {
        private InstantShutdownStateDescriptor() {
            super(InstantShutdownState.class);
            this.addSuccessor(CloseConnectionStateDescriptor.class);
        }
    }

    static final class ShutdownStateDescriptor
    extends StateDescriptor {
        private ShutdownStateDescriptor() {
            super(ShutdownState.class);
            this.addSuccessor(CloseConnectionStateDescriptor.class);
        }
    }

    public static class DisconnectedStateDescriptor
    extends StateDescriptor {
        protected DisconnectedStateDescriptor() {
            super(DisconnectedState.class, StateDescriptor.Property.finalState);
            this.addSuccessor(LookupRemoteConnectionEndpointsStateDescriptor.class);
        }
    }

    public static final class ConnectedButUnauthenticatedStateDescriptor
    extends StateDescriptor {
        private ConnectedButUnauthenticatedStateDescriptor() {
            super(ConnectedButUnauthenticatedState.class, StateDescriptor.Property.finalState);
            this.addSuccessor(SaslAuthenticationStateDescriptor.class);
            this.addSuccessor(InstantShutdownStateDescriptor.class);
            this.addSuccessor(ShutdownStateDescriptor.class);
        }
    }

    public static final class Stats
    extends AbstractStats {
        public final Map<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport.Stats> transportsStats;
        public final Map<String, Object> filtersStats;

        private Stats(Map<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport.Stats> transportsStats, Map<String, Object> filtersStats) {
            this.transportsStats = Collections.unmodifiableMap(transportsStats);
            this.filtersStats = Collections.unmodifiableMap(filtersStats);
        }

        @Override
        public void appendStatsTo(ExtendedAppendable appendable) throws IOException {
            StringUtils.appendHeading(appendable, "Connection stats", '#').append('\n');
            for (Map.Entry<Class<? extends ModularXmppClientToServerConnectionModuleDescriptor>, XmppClientToServerTransport.Stats> entry : this.transportsStats.entrySet()) {
                Class<? extends ModularXmppClientToServerConnectionModuleDescriptor> transportClass = entry.getKey();
                XmppClientToServerTransport.Stats stats = entry.getValue();
                StringUtils.appendHeading(appendable, transportClass.getName());
                if (stats != null) {
                    appendable.append(stats.toString());
                } else {
                    appendable.append("No stats available.");
                }
                appendable.append('\n');
            }
            for (Map.Entry<Object, Object> entry : this.filtersStats.entrySet()) {
                String filterName = (String)entry.getKey();
                Object filterStats = entry.getValue();
                StringUtils.appendHeading(appendable, filterName);
                appendable.append(filterStats.toString()).append('\n');
            }
        }
    }

    private final class CloseConnectionState
    extends State {
        private CloseConnectionState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            ModularXmppClientToServerConnection.this.activeTransport.disconnect();
            ModularXmppClientToServerConnection.this.activeTransport = null;
            ModularXmppClientToServerConnection.this.authenticated = (ModularXmppClientToServerConnection.this.connected = false);
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }
    }

    private static final class CloseConnectionStateDescriptor
    extends StateDescriptor {
        private CloseConnectionStateDescriptor() {
            super(CloseConnectionState.class);
            this.addSuccessor(DisconnectedStateDescriptor.class);
        }
    }

    private static final class InstantShutdownState
    extends NoOpState {
        private InstantShutdownState(ModularXmppClientToServerConnection connection, StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(connection, stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            this.ensureNotOnOurWayToAuthenticatedAndResourceBound(walkStateGraphContext);
            return null;
        }
    }

    private final class ShutdownState
    extends State {
        private ShutdownState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            this.ensureNotOnOurWayToAuthenticatedAndResourceBound(walkStateGraphContext);
            return null;
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            ModularXmppClientToServerConnection.this.closingStreamReceived = false;
            StreamOpenAndCloseFactory openAndCloseFactory = ModularXmppClientToServerConnection.this.activeTransport.getStreamOpenAndCloseFactory();
            AbstractStreamClose closeStreamElement = openAndCloseFactory.createStreamClose();
            boolean streamCloseIssued = ModularXmppClientToServerConnection.this.outgoingElementsQueue.offerAndShutdown(closeStreamElement);
            if (streamCloseIssued) {
                ModularXmppClientToServerConnection.this.activeTransport.notifyAboutNewOutgoingElements();
                boolean successfullyReceivedStreamClose = ModularXmppClientToServerConnection.this.waitForClosingStreamTagFromServer();
                if (successfullyReceivedStreamClose) {
                    XmppInputOutputFilter filter;
                    ListIterator<XmppInputOutputFilter> it = this.connectionInternal.getXmppInputOutputFilterBeginIterator();
                    while (it.hasNext()) {
                        filter = (XmppInputOutputFilter)it.next();
                        filter.closeInputOutput();
                    }
                    ModularXmppClientToServerConnection.this.activeTransport.afterFiltersClosed();
                    it = this.connectionInternal.getXmppInputOutputFilterBeginIterator();
                    while (it.hasNext()) {
                        filter = (XmppInputOutputFilter)it.next();
                        try {
                            filter.waitUntilInputOutputClosed();
                        }
                        catch (IOException | InterruptedException | CertificateException | SmackException | XMPPException e) {
                            LOGGER.log(Level.WARNING, "waitUntilInputOutputClosed() threw", e);
                        }
                    }
                    ModularXmppClientToServerConnection.this.authenticated = false;
                }
            }
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }
    }

    private final class AuthenticatedAndResourceBoundState
    extends State {
        private AuthenticatedAndResourceBoundState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws SmackException.NotConnectedException, InterruptedException {
            if (ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated != null) {
                assert (walkStateGraphContext.getWalk().get(0).getStateDescriptor().getClass() != DisconnectedStateDescriptor.class);
                walkStateGraphContext.appendWalkTo(ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated);
            } else {
                ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated = new ArrayList<State>(walkStateGraphContext.getWalkLength() + 1);
                walkStateGraphContext.appendWalkTo(ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated);
            }
            ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated.add(this);
            ModularXmppClientToServerConnection.this.afterSuccessfulLogin(ModularXmppClientToServerConnection.this.streamResumed);
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }

        @Override
        public void resetState() {
            ModularXmppClientToServerConnection.this.authenticated = false;
        }
    }

    public static final class ResourceBoundResult
    extends StateTransitionResult.Success {
        private final Resourcepart resource;

        private ResourceBoundResult(Resourcepart boundResource, Resourcepart requestedResource) {
            super("Resource '" + String.valueOf(boundResource) + "' bound (requested: '" + String.valueOf(requestedResource) + "')");
            this.resource = boundResource;
        }

        public Resourcepart getResource() {
            return this.resource;
        }
    }

    private final class ResourceBindingState
    extends State {
        private ResourceBindingState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws IOException, SmackException, InterruptedException, XMPPException {
            ModularXmppClientToServerConnection.this.lastFeaturesReceived = true;
            ModularXmppClientToServerConnection.this.notifyWaitingThreads();
            LoginContext loginContext = walkStateGraphContext.getLoginContext();
            Resourcepart resource = ModularXmppClientToServerConnection.this.bindResourceAndEstablishSession(loginContext.resource);
            ModularXmppClientToServerConnection.this.streamResumed = false;
            return new ResourceBoundResult(resource, loginContext.resource);
        }
    }

    public static final class ResourceBindingStateDescriptor
    extends StateDescriptor {
        private ResourceBindingStateDescriptor() {
            super(ResourceBindingState.class, "RFC 6120 \u00a7 7");
            this.addSuccessor(AuthenticatedAndResourceBoundStateDescriptor.class);
        }
    }

    public static final class AuthenticatedButUnboundStateDescriptor
    extends StateDescriptor {
        private AuthenticatedButUnboundStateDescriptor() {
            super(StateDescriptor.Property.multiVisitState);
            this.addSuccessor(ResourceBindingStateDescriptor.class);
        }
    }

    public static final class SaslAuthenticationSuccessResult
    extends StateTransitionResult.Success {
        private final String saslMechanismName;

        private SaslAuthenticationSuccessResult(SASLMechanism usedSaslMechanism) {
            super("SASL authentication successfull using " + usedSaslMechanism.getName());
            this.saslMechanismName = usedSaslMechanism.getName();
        }

        public String getSaslMechanismName() {
            return this.saslMechanismName;
        }
    }

    private final class SaslAuthenticationState
    extends State {
        private SaslAuthenticationState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws IOException, SmackException, InterruptedException, XMPPException {
            ModularXmppClientToServerConnection.this.prepareToWaitForFeaturesReceived();
            LoginContext loginContext = walkStateGraphContext.getLoginContext();
            SASLMechanism usedSaslMechanism = ModularXmppClientToServerConnection.this.authenticate(loginContext.username, loginContext.password, ModularXmppClientToServerConnection.this.config.getAuthzid(), ModularXmppClientToServerConnection.this.getSSLSession());
            ModularXmppClientToServerConnection.this.waitForFeaturesReceived("server stream features after SASL authentication");
            return new SaslAuthenticationSuccessResult(usedSaslMechanism);
        }
    }

    public static final class SaslAuthenticationStateDescriptor
    extends StateDescriptor {
        private SaslAuthenticationStateDescriptor() {
            super(SaslAuthenticationState.class, "RFC 6120 \u00a7 6");
            this.addSuccessor(AuthenticatedButUnboundStateDescriptor.class);
        }
    }

    private final class ConnectedButUnauthenticatedState
    extends State {
        private ConnectedButUnauthenticatedState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            assert (ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated == null);
            if (walkStateGraphContext.isWalksFinalState(this.getStateDescriptor())) {
                ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated = walkStateGraphContext.getWalk();
            }
            ModularXmppClientToServerConnection.this.connected = true;
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }

        @Override
        public void resetState() {
            ModularXmppClientToServerConnection.this.connected = false;
        }
    }

    private final class LookupRemoteConnectionEndpointsState
    extends State {
        boolean outgoingElementsQueueWasShutdown;

        private LookupRemoteConnectionEndpointsState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws XMPPException.XMPPErrorException, SASLErrorException, IOException, SmackException, InterruptedException, XMPPException.FailedNonzaException {
            HashMap<XmppClientToServerTransport, List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>> lookupFutures = new HashMap<XmppClientToServerTransport, List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>>(ModularXmppClientToServerConnection.this.transports.size());
            ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> allFutures = new ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>();
            for (XmppClientToServerTransport transport : ModularXmppClientToServerConnection.this.transports.values()) {
                transport.resetDiscoveredConnectionEndpoints();
                List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> transportFutures = transport.lookupConnectionEndpoints();
                lookupFutures.put(transport, transportFutures);
                allFutures.addAll(transportFutures);
            }
            int numberOfFutures = allFutures.size();
            SmackFuture.await(allFutures, ModularXmppClientToServerConnection.this.getReplyTimeout(), TimeUnit.MILLISECONDS);
            ArrayList<XmppClientToServerTransport.LookupConnectionEndpointsFailed> lookupFailures = new ArrayList<XmppClientToServerTransport.LookupConnectionEndpointsFailed>(numberOfFutures);
            boolean atLeastOneConnectionEndpointDiscovered = false;
            for (Map.Entry entry : lookupFutures.entrySet()) {
                XmppClientToServerTransport transport = (XmppClientToServerTransport)entry.getKey();
                for (SmackFuture future : (List)entry.getValue()) {
                    XmppClientToServerTransport.LookupConnectionEndpointsResult result = (XmppClientToServerTransport.LookupConnectionEndpointsResult)future.getIfAvailable();
                    if (result == null) continue;
                    if (result instanceof XmppClientToServerTransport.LookupConnectionEndpointsFailed) {
                        XmppClientToServerTransport.LookupConnectionEndpointsFailed lookupFailure = (XmppClientToServerTransport.LookupConnectionEndpointsFailed)result;
                        lookupFailures.add(lookupFailure);
                        continue;
                    }
                    XmppClientToServerTransport.LookupConnectionEndpointsSuccess successResult = (XmppClientToServerTransport.LookupConnectionEndpointsSuccess)result;
                    transport.loadConnectionEndpoints(successResult);
                    atLeastOneConnectionEndpointDiscovered = true;
                }
            }
            if (!atLeastOneConnectionEndpointDiscovered) {
                throw SmackException.NoEndpointsDiscoveredException.from(lookupFailures);
            }
            if (!lookupFailures.isEmpty()) {
                // empty if block
            }
            this.outgoingElementsQueueWasShutdown = ModularXmppClientToServerConnection.this.outgoingElementsQueue.start();
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }

        @Override
        public void resetState() {
            for (XmppClientToServerTransport transport : ModularXmppClientToServerConnection.this.transports.values()) {
                transport.resetDiscoveredConnectionEndpoints();
            }
            if (this.outgoingElementsQueueWasShutdown) {
                ModularXmppClientToServerConnection.this.outgoingElementsQueue.shutdown();
            }
        }
    }

    public static final class LookupRemoteConnectionEndpointsStateDescriptor
    extends StateDescriptor {
        private LookupRemoteConnectionEndpointsStateDescriptor() {
            super(LookupRemoteConnectionEndpointsState.class);
        }
    }

    private final class DisconnectedState
    extends State {
        private DisconnectedState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            ModularXmppClientToServerConnection modularXmppClientToServerConnection = ModularXmppClientToServerConnection.this;
            synchronized (modularXmppClientToServerConnection) {
                if (ModularXmppClientToServerConnection.this.inputOutputFilters.isEmpty()) {
                    ModularXmppClientToServerConnection.this.previousInputOutputFilters = null;
                } else {
                    ModularXmppClientToServerConnection.this.previousInputOutputFilters = new ArrayList<XmppInputOutputFilter>(ModularXmppClientToServerConnection.this.inputOutputFilters.size());
                    ModularXmppClientToServerConnection.this.previousInputOutputFilters.addAll(ModularXmppClientToServerConnection.this.inputOutputFilters);
                    ModularXmppClientToServerConnection.this.inputOutputFilters.clear();
                }
            }
            ListIterator<State> it = ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated.listIterator(ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated.size());
            while (it.hasPrevious()) {
                State stateToReset = it.previous();
                stateToReset.resetState();
            }
            ModularXmppClientToServerConnection.this.walkFromDisconnectToAuthenticated = null;
            return StateTransitionResult.Success.EMPTY_INSTANCE;
        }
    }
}

