/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger.slf4j;

import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.debugger.slf4j.Validate;
import org.slf4j.Logger;

class SLF4JLoggingConnectionListener
implements ConnectionListener {
    private final XMPPConnection connection;
    private final Logger logger;

    public SLF4JLoggingConnectionListener(XMPPConnection connection, Logger logger) {
        this.connection = Validate.notNull(connection);
        this.logger = Validate.notNull(logger);
    }

    public void connected(XMPPConnection connection) {
        this.logger.debug("({}) Connection connected", (Object)connection.hashCode());
    }

    public void authenticated(XMPPConnection connection, boolean resumed) {
        this.logger.debug("({}) Connection authenticated as {}", (Object)connection.hashCode(), (Object)connection.getUser());
    }

    public void connectionClosed() {
        this.logger.debug("({}) Connection closed", (Object)this.connection.hashCode());
    }

    public void connectionClosedOnError(Exception e) {
        this.logger.debug("({}) Connection closed due to an exception: {}", (Object)this.connection.hashCode(), (Object)e);
    }

    public void reconnectionFailed(Exception e) {
        this.logger.debug("({}) Reconnection failed due to an exception: {}", (Object)this.connection.hashCode(), (Object)e);
    }

    public void reconnectionSuccessful() {
        this.logger.debug("({}) Connection reconnected", (Object)this.connection.hashCode());
    }

    public void reconnectingIn(int seconds) {
        this.logger.debug("({}) Connection will reconnect in {}", (Object)this.connection.hashCode(), (Object)seconds);
    }
}

