/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger.slf4j;

import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JSmackDebugger;
import org.jivesoftware.smackx.debugger.slf4j.Validate;
import org.slf4j.Logger;

class SLF4JLoggingPacketListener
implements StanzaListener {
    private final Logger logger;
    private final String prefix;

    public SLF4JLoggingPacketListener(Logger logger, String prefix) {
        this.logger = Validate.notNull(logger);
        this.prefix = Validate.notNull(prefix);
    }

    public void processPacket(Stanza packet) {
        if (SLF4JSmackDebugger.printInterpreted.get() && this.logger.isDebugEnabled()) {
            this.logger.debug("{}: PKT [{}] '{}'", new Object[]{this.prefix, packet.getClass().getName(), packet.toXML()});
        }
    }
}

