/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger.slf4j;

import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JDebuggerFactory;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JLoggingConnectionListener;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JLoggingPacketListener;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JRawXmlListener;
import org.jivesoftware.smackx.debugger.slf4j.Validate;
import org.jxmpp.jid.FullJid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JSmackDebugger
implements SmackDebugger {
    public static final String LOGGER_NAME = "SMACK";
    private static final Logger logger = LoggerFactory.getLogger((String)"SMACK");
    public static final AtomicBoolean printInterpreted = new AtomicBoolean(true);
    public static final String SENT_TAG = "SENT";
    public static final String RECEIVED_TAG = "RECV";
    private final XMPPConnection connection;
    private final StanzaListener receivedListener = new SLF4JLoggingPacketListener(logger, "RECV");
    private final StanzaListener sentListener = new SLF4JLoggingPacketListener(logger, "SENT");
    private final SLF4JRawXmlListener slf4JRawXmlListener = new SLF4JRawXmlListener(logger);
    private ObservableWriter writer;
    private ObservableReader reader;

    public static void enable() {
        SmackConfiguration.setDebuggerFactory((SmackDebuggerFactory)new SLF4JDebuggerFactory());
    }

    public SLF4JSmackDebugger(XMPPConnection connection, Writer writer, Reader reader) {
        this.connection = connection;
        this.writer = new ObservableWriter(writer);
        this.writer.addWriterListener((WriterListener)this.slf4JRawXmlListener);
        this.reader = new ObservableReader(Validate.notNull(reader));
        this.reader.addReaderListener((ReaderListener)this.slf4JRawXmlListener);
        this.connection.addConnectionListener((ConnectionListener)new SLF4JLoggingConnectionListener(connection, logger));
    }

    public Reader newConnectionReader(Reader newReader) {
        this.reader.removeReaderListener((ReaderListener)this.slf4JRawXmlListener);
        this.reader = new ObservableReader(newReader);
        this.reader.addReaderListener((ReaderListener)this.slf4JRawXmlListener);
        return this.reader;
    }

    public Writer newConnectionWriter(Writer newWriter) {
        this.writer.removeWriterListener((WriterListener)this.slf4JRawXmlListener);
        this.writer = new ObservableWriter(newWriter);
        this.writer.addWriterListener((WriterListener)this.slf4JRawXmlListener);
        return this.writer;
    }

    public void userHasLogged(FullJid user) {
        if (logger.isDebugEnabled()) {
            logger.debug("({}) User logged in {}", (Object)this.connection.hashCode(), (Object)user.toString());
        }
    }

    public Reader getReader() {
        return this.reader;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public StanzaListener getReaderListener() {
        return this.receivedListener;
    }

    public StanzaListener getWriterListener() {
        return this.sentListener;
    }
}

