/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger.slf4j;

import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.WriterListener;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JDebuggerFactory;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JLoggingConnectionListener;
import org.jivesoftware.smackx.debugger.slf4j.SLF4JRawXmlListener;
import org.jivesoftware.smackx.debugger.slf4j.Validate;
import org.jxmpp.jid.EntityFullJid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JSmackDebugger
extends SmackDebugger {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SLF4JSmackDebugger.class.getName());
    public static final String LOGGER_NAME = "SMACK";
    private static final Logger logger = LoggerFactory.getLogger((String)"SMACK");
    public static final AtomicBoolean printInterpreted = new AtomicBoolean(true);
    public static final String SENT_TAG = "SENT";
    public static final String RECEIVED_TAG = "RECV";
    private final SLF4JRawXmlListener slf4JRawXmlListener = new SLF4JRawXmlListener(logger);
    private ObservableWriter writer = new ObservableWriter((Writer)this.writer);
    private ObservableReader reader;

    public static void enable() {
        SmackConfiguration.DEBUG = true;
        SmackConfiguration.setDefaultSmackDebuggerFactory((SmackDebuggerFactory)SLF4JDebuggerFactory.INSTANCE);
    }

    SLF4JSmackDebugger(XMPPConnection connection) {
        super(connection);
        this.writer.addWriterListener((WriterListener)this.slf4JRawXmlListener);
        this.reader = new ObservableReader((Reader)Validate.notNull(this.reader));
        this.reader.addReaderListener((ReaderListener)this.slf4JRawXmlListener);
        SLF4JLoggingConnectionListener loggingConnectionListener = new SLF4JLoggingConnectionListener(connection, logger);
        this.connection.addConnectionListener((ConnectionListener)loggingConnectionListener);
        if (connection instanceof AbstractXMPPConnection) {
            AbstractXMPPConnection abstractXmppConnection = (AbstractXMPPConnection)connection;
            ReconnectionManager.getInstanceFor((AbstractXMPPConnection)abstractXmppConnection).addReconnectionListener((ReconnectionListener)loggingConnectionListener);
        } else {
            LOGGER.info("The connection instance " + connection + " is not an instance of AbstractXMPPConnection, thus we can not install the ReconnectionListener");
        }
    }

    public Reader newConnectionReader(Reader newReader) {
        this.reader.removeReaderListener((ReaderListener)this.slf4JRawXmlListener);
        this.reader = new ObservableReader(newReader);
        this.reader.addReaderListener((ReaderListener)this.slf4JRawXmlListener);
        return this.reader;
    }

    public Writer newConnectionWriter(Writer newWriter) {
        this.writer.removeWriterListener((WriterListener)this.slf4JRawXmlListener);
        this.writer = new ObservableWriter(newWriter);
        this.writer.addWriterListener((WriterListener)this.slf4JRawXmlListener);
        return this.writer;
    }

    public void userHasLogged(EntityFullJid user) {
        if (logger.isDebugEnabled()) {
            logger.debug("({}) User logged in {}", (Object)this.connection.hashCode(), (Object)user.toString());
        }
    }

    public void onIncomingStreamElement(TopLevelStreamElement streamElement) {
        if (printInterpreted.get() && logger.isDebugEnabled()) {
            logger.debug("IN {}: {}", (Object)streamElement.getClass().getName(), (Object)streamElement.toXML(null));
        }
    }

    public void onOutgoingStreamElement(TopLevelStreamElement streamElement) {
        if (printInterpreted.get() && logger.isDebugEnabled()) {
            logger.debug("OUT {}: {}", (Object)streamElement.getClass().getName(), (Object)streamElement.toXML(null));
        }
    }
}

