/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.debugger.EnhancedDebugger;

public final class EnhancedDebuggerWindow {
    private static EnhancedDebuggerWindow instance;
    private static ImageIcon connectionCreatedIcon;
    private static ImageIcon connectionActiveIcon;
    private static ImageIcon connectionClosedIcon;
    private static ImageIcon connectionClosedOnErrorIcon;
    public static boolean PERSISTED_DEBUGGER;
    public static int MAX_TABLE_ROWS;
    private JFrame frame;
    private JTabbedPane tabbedPane;
    private List<EnhancedDebugger> debuggers;

    private EnhancedDebuggerWindow() {
        URL url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_off.png");
        if (url != null) {
            connectionCreatedIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_green.png")) != null) {
            connectionActiveIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/trafficlight_red.png")) != null) {
            connectionClosedIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/warning.png")) != null) {
            connectionClosedOnErrorIcon = new ImageIcon(url);
        }
        this.frame = null;
        this.tabbedPane = null;
        this.debuggers = new ArrayList<EnhancedDebugger>();
    }

    public static synchronized EnhancedDebuggerWindow getInstance() {
        if (instance == null) {
            instance = new EnhancedDebuggerWindow();
        }
        return instance;
    }

    static synchronized void addDebugger(EnhancedDebugger debugger) {
        EnhancedDebuggerWindow.getInstance().showNewDebugger(debugger);
    }

    private void showNewDebugger(EnhancedDebugger debugger) {
        if (this.frame == null) {
            this.createDebug();
        }
        debugger.tabbedPane.setName("XMPPConnection_" + this.tabbedPane.getComponentCount());
        this.tabbedPane.add((Component)debugger.tabbedPane, this.tabbedPane.getComponentCount() - 1);
        this.tabbedPane.setIconAt(this.tabbedPane.indexOfComponent(debugger.tabbedPane), connectionCreatedIcon);
        this.tabbedPane.setSelectedIndex(this.tabbedPane.indexOfComponent(debugger.tabbedPane));
        this.frame.setTitle("Smack Debug Window -- Total connections: " + (this.tabbedPane.getComponentCount() - 1));
        this.debuggers.add(debugger);
    }

    static synchronized void userHasLogged(EnhancedDebugger debugger, String user) {
        int index = EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setTitleAt(index, user);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(index, connectionActiveIcon);
    }

    static synchronized void connectionClosed(EnhancedDebugger debugger) {
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane), connectionClosedIcon);
    }

    static synchronized void connectionClosedOnError(EnhancedDebugger debugger, Exception e) {
        int index = EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane);
        EnhancedDebuggerWindow.getInstance().tabbedPane.setToolTipTextAt(index, "XMPPConnection closed due to the exception: " + e.getMessage());
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(index, connectionClosedOnErrorIcon);
    }

    static synchronized void connectionEstablished(EnhancedDebugger debugger) {
        EnhancedDebuggerWindow.getInstance().tabbedPane.setIconAt(EnhancedDebuggerWindow.getInstance().tabbedPane.indexOfComponent(debugger.tabbedPane), connectionActiveIcon);
    }

    private void createDebug() {
        this.frame = new JFrame("Smack Debug Window");
        if (!PERSISTED_DEBUGGER) {
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    EnhancedDebuggerWindow.this.rootWindowClosing(evt);
                }
            });
        }
        this.tabbedPane = new JTabbedPane();
        JPanel informationPanel = new JPanel();
        informationPanel.setLayout(new BoxLayout(informationPanel, 1));
        JPanel versionPanel = new JPanel();
        versionPanel.setLayout(new BoxLayout(versionPanel, 0));
        versionPanel.setMaximumSize(new Dimension(2000, 31));
        versionPanel.add(new JLabel(" Smack version: "));
        JFormattedTextField field = new JFormattedTextField((Object)SmackConfiguration.getVersion());
        field.setEditable(false);
        field.setBorder(null);
        versionPanel.add(field);
        informationPanel.add(versionPanel);
        JPanel iqProvidersPanel = new JPanel();
        iqProvidersPanel.setLayout(new GridLayout(1, 1));
        iqProvidersPanel.setBorder(BorderFactory.createTitledBorder("Installed IQ Providers"));
        Vector<String> providers = new Vector<String>();
        for (Object provider : ProviderManager.getIQProviders()) {
            if (provider.getClass() == Class.class) {
                providers.add(((Class)provider).getName());
                continue;
            }
            providers.add(provider.getClass().getName());
        }
        Collections.sort(providers);
        JList list = new JList(providers);
        iqProvidersPanel.add(new JScrollPane(list));
        informationPanel.add(iqProvidersPanel);
        JPanel extensionProvidersPanel = new JPanel();
        extensionProvidersPanel.setLayout(new GridLayout(1, 1));
        extensionProvidersPanel.setBorder(BorderFactory.createTitledBorder("Installed Extension Providers"));
        providers = new Vector();
        for (Object provider : ProviderManager.getExtensionProviders()) {
            if (provider.getClass() == Class.class) {
                providers.add(((Class)provider).getName());
                continue;
            }
            providers.add(provider.getClass().getName());
        }
        Collections.sort(providers);
        list = new JList(providers);
        extensionProvidersPanel.add(new JScrollPane(list));
        informationPanel.add(extensionProvidersPanel);
        this.tabbedPane.add("Smack Info", informationPanel);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Close");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (EnhancedDebuggerWindow.this.tabbedPane.getSelectedIndex() < EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1) {
                    int index = EnhancedDebuggerWindow.this.tabbedPane.getSelectedIndex();
                    EnhancedDebugger debugger = (EnhancedDebugger)((Object)EnhancedDebuggerWindow.this.debuggers.get(index));
                    debugger.cancel();
                    EnhancedDebuggerWindow.this.tabbedPane.remove(debugger.tabbedPane);
                    EnhancedDebuggerWindow.this.debuggers.remove((Object)debugger);
                    EnhancedDebuggerWindow.this.frame.setTitle("Smack Debug Window -- Total connections: " + (EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1));
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Close All Not Active");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<EnhancedDebugger> debuggersToRemove = new ArrayList<EnhancedDebugger>();
                for (int index = 0; index < EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1; ++index) {
                    EnhancedDebugger debugger = (EnhancedDebugger)((Object)EnhancedDebuggerWindow.this.debuggers.get(index));
                    if (debugger.isConnectionActive()) continue;
                    debugger.cancel();
                    debuggersToRemove.add(debugger);
                }
                for (EnhancedDebugger debugger : debuggersToRemove) {
                    EnhancedDebuggerWindow.this.tabbedPane.remove(debugger.tabbedPane);
                    EnhancedDebuggerWindow.this.debuggers.remove((Object)debugger);
                }
                EnhancedDebuggerWindow.this.frame.setTitle("Smack Debug Window -- Total connections: " + (EnhancedDebuggerWindow.this.tabbedPane.getComponentCount() - 1));
            }
        });
        menu.add(menuItem);
        this.tabbedPane.addMouseListener(new PopupListener(menu));
        this.frame.getContentPane().add(this.tabbedPane);
        this.frame.setSize(650, 400);
        if (!PERSISTED_DEBUGGER) {
            this.frame.setVisible(true);
        }
    }

    private synchronized void rootWindowClosing(WindowEvent evt) {
        for (EnhancedDebugger debugger : this.debuggers) {
            debugger.cancel();
        }
        this.debuggers.clear();
        instance = null;
        this.frame = null;
        this.notifyAll();
    }

    public void setVisible(boolean visible) {
        if (this.frame != null) {
            this.frame.setVisible(visible);
        }
    }

    public boolean isVisible() {
        return this.frame != null && this.frame.isVisible();
    }

    public synchronized void waitUntilClosed() throws InterruptedException {
        if (this.frame == null) {
            return;
        }
        while (this.frame != null) {
            this.wait();
        }
    }

    static {
        PERSISTED_DEBUGGER = false;
        MAX_TABLE_ROWS = 150;
    }

    private static class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

