/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.debugger;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.BadLocationException;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.ReconnectionListener;
import org.jivesoftware.smack.ReconnectionManager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.debugger.SmackDebuggerFactory;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.ObservableReader;
import org.jivesoftware.smack.util.ObservableWriter;
import org.jivesoftware.smack.util.ReaderListener;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.WriterListener;
import org.jivesoftware.smack.util.XmlUtil;
import org.jivesoftware.smackx.debugger.EnhancedDebuggerWindow;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

public class EnhancedDebugger
extends SmackDebugger {
    private static final Logger LOGGER = Logger.getLogger(EnhancedDebugger.class.getName());
    private static final String NEWLINE = "\n";
    private static ImageIcon packetReceivedIcon;
    private static ImageIcon packetSentIcon;
    private static ImageIcon presencePacketIcon;
    private static ImageIcon iqPacketIcon;
    private static ImageIcon messagePacketIcon;
    private static ImageIcon unknownPacketTypeIcon;
    private DefaultTableModel messagesTable;
    private JTextArea messageTextArea;
    private JFormattedTextField userField;
    private JFormattedTextField statusField;
    private ConnectionListener connListener;
    private final ReconnectionListener reconnectionListener;
    private Writer writer;
    private Reader reader;
    private ReaderListener readerListener;
    private WriterListener writerListener;
    private Date creationTime;
    private DefaultTableModel statisticsTable;
    private int sentPackets;
    private int receivedPackets;
    private int sentIQPackets;
    private int receivedIQPackets;
    private int sentMessagePackets;
    private int receivedMessagePackets;
    private int sentPresencePackets;
    private int receivedPresencePackets;
    private int sentOtherPackets;
    private int receivedOtherPackets;
    JTabbedPane tabbedPane;

    public EnhancedDebugger(XMPPConnection connection) {
        super(connection);
        URL url = Thread.currentThread().getContextClassLoader().getResource("images/nav_left_blue.png");
        if (url != null) {
            packetReceivedIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/nav_right_red.png")) != null) {
            packetSentIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/photo_portrait.png")) != null) {
            presencePacketIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/question_and_answer.png")) != null) {
            iqPacketIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/message.png")) != null) {
            messagePacketIcon = new ImageIcon(url);
        }
        if ((url = Thread.currentThread().getContextClassLoader().getResource("images/unknown.png")) != null) {
            unknownPacketTypeIcon = new ImageIcon(url);
        }
        this.messagesTable = null;
        this.messageTextArea = null;
        this.userField = null;
        this.statusField = null;
        this.connListener = null;
        this.creationTime = new Date();
        this.statisticsTable = null;
        this.sentPackets = 0;
        this.receivedPackets = 0;
        this.sentIQPackets = 0;
        this.receivedIQPackets = 0;
        this.sentMessagePackets = 0;
        this.receivedMessagePackets = 0;
        this.sentPresencePackets = 0;
        this.receivedPresencePackets = 0;
        this.sentOtherPackets = 0;
        this.receivedOtherPackets = 0;
        this.reconnectionListener = new ReconnectionListener(){

            public void reconnectingIn(final int seconds) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedDebugger.this.statusField.setValue("Attempt to reconnect in " + seconds + " seconds");
                    }
                });
            }

            public void reconnectionFailed(Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedDebugger.this.statusField.setValue("Reconnection failed");
                    }
                });
            }
        };
        if (connection instanceof AbstractXMPPConnection) {
            AbstractXMPPConnection abstractXmppConnection = (AbstractXMPPConnection)connection;
            ReconnectionManager.getInstanceFor((AbstractXMPPConnection)abstractXmppConnection).addReconnectionListener(this.reconnectionListener);
        } else {
            LOGGER.info("The connection instance " + connection + " is not an instance of AbstractXMPPConnection, thus we can not install the ReconnectionListener");
        }
        this.tabbedPane = new JTabbedPane();
        this.addBasicPanels();
        this.addAdhocPacketPanel();
        this.addInformationPanel();
        this.connListener = new ConnectionListener(){

            public void connectionClosed() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedDebugger.this.statusField.setValue("Closed");
                        EnhancedDebuggerWindow.connectionClosed(EnhancedDebugger.this);
                    }
                });
            }

            public void connectionClosedOnError(final Exception e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnhancedDebugger.this.statusField.setValue("Closed due to an exception");
                        EnhancedDebuggerWindow.connectionClosedOnError(EnhancedDebugger.this, e);
                    }
                });
            }
        };
        EnhancedDebuggerWindow.addDebugger(this);
    }

    private void addBasicPanels() {
        JSplitPane allPane = new JSplitPane(0);
        allPane.setOneTouchExpandable(true);
        this.messagesTable = new DefaultTableModel(new Object[]{"Hide", "Timestamp", "", "", "Message", "Id", "Type", "To", "From"}, 0){
            private static final long serialVersionUID = 8136121224474217264L;

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 2 || columnIndex == 3) {
                    return Icon.class;
                }
                return super.getColumnClass(columnIndex);
            }
        };
        JTable table = new JTable(this.messagesTable);
        table.setSelectionMode(0);
        table.getColumnModel().getColumn(0).setMaxWidth(0);
        table.getColumnModel().getColumn(0).setMinWidth(0);
        table.getTableHeader().getColumnModel().getColumn(0).setMaxWidth(0);
        table.getTableHeader().getColumnModel().getColumn(0).setMinWidth(0);
        table.getColumnModel().getColumn(1).setMaxWidth(300);
        table.getColumnModel().getColumn(1).setPreferredWidth(90);
        table.getColumnModel().getColumn(2).setMaxWidth(50);
        table.getColumnModel().getColumn(2).setPreferredWidth(30);
        table.getColumnModel().getColumn(3).setMaxWidth(50);
        table.getColumnModel().getColumn(3).setPreferredWidth(30);
        table.getColumnModel().getColumn(5).setMaxWidth(100);
        table.getColumnModel().getColumn(5).setPreferredWidth(55);
        table.getColumnModel().getColumn(6).setMaxWidth(200);
        table.getColumnModel().getColumn(6).setPreferredWidth(50);
        table.getColumnModel().getColumn(7).setMaxWidth(300);
        table.getColumnModel().getColumn(7).setPreferredWidth(90);
        table.getColumnModel().getColumn(8).setMaxWidth(300);
        table.getColumnModel().getColumn(8).setPreferredWidth(90);
        SelectionListener selectionListener = new SelectionListener(table);
        table.getSelectionModel().addListSelectionListener(selectionListener);
        table.getColumnModel().getSelectionModel().addListSelectionListener(selectionListener);
        allPane.setTopComponent(new JScrollPane(table));
        this.messageTextArea = new JTextArea();
        this.messageTextArea.setEditable(false);
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem1 = new JMenuItem("Copy");
        menuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(EnhancedDebugger.this.messageTextArea.getText()), null);
            }
        });
        menu.add(menuItem1);
        this.messageTextArea.addMouseListener(new PopupListener(menu));
        JPanel sublayout = new JPanel(new BorderLayout());
        sublayout.add((Component)new JScrollPane(this.messageTextArea), "Center");
        JButton clearb = new JButton("Clear All Packets");
        clearb.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -8576045822764763613L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EnhancedDebugger.this.messagesTable.setRowCount(0);
            }
        });
        sublayout.add((Component)clearb, "North");
        allPane.setBottomComponent(sublayout);
        allPane.setDividerLocation(150);
        this.tabbedPane.add("All Packets", allPane);
        this.tabbedPane.setToolTipTextAt(0, "Sent and received packets processed by Smack");
        final JTextArea sentText = new JTextArea();
        sentText.setWrapStyleWord(true);
        sentText.setLineWrap(true);
        sentText.setEditable(false);
        sentText.setForeground(new Color(112, 3, 3));
        this.tabbedPane.add("Raw Sent Packets", new JScrollPane(sentText));
        this.tabbedPane.setToolTipTextAt(1, "Raw text of the sent packets");
        menu = new JPopupMenu();
        menuItem1 = new JMenuItem("Copy");
        menuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(sentText.getText()), null);
            }
        });
        JMenuItem menuItem2 = new JMenuItem("Clear");
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sentText.setText("");
            }
        });
        sentText.addMouseListener(new PopupListener(menu));
        menu.add(menuItem1);
        menu.add(menuItem2);
        final JTextArea receivedText = new JTextArea();
        receivedText.setWrapStyleWord(true);
        receivedText.setLineWrap(true);
        receivedText.setEditable(false);
        receivedText.setForeground(new Color(6, 76, 133));
        this.tabbedPane.add("Raw Received Packets", new JScrollPane(receivedText));
        this.tabbedPane.setToolTipTextAt(2, "Raw text of the received packets before Smack process them");
        menu = new JPopupMenu();
        menuItem1 = new JMenuItem("Copy");
        menuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(receivedText.getText()), null);
            }
        });
        menuItem2 = new JMenuItem("Clear");
        menuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                receivedText.setText("");
            }
        });
        receivedText.addMouseListener(new PopupListener(menu));
        menu.add(menuItem1);
        menu.add(menuItem2);
        ObservableReader debugReader = new ObservableReader(this.reader);
        this.readerListener = new ReaderListener(){
            private final PriorityBlockingQueue<String> buffer = new PriorityBlockingQueue();

            public void read(String string) {
                EnhancedDebugger.addBatched(string, this.buffer, receivedText);
            }
        };
        debugReader.addReaderListener(this.readerListener);
        ObservableWriter debugWriter = new ObservableWriter(this.writer);
        this.writerListener = new WriterListener(){
            private final PriorityBlockingQueue<String> buffer = new PriorityBlockingQueue();

            public void write(String string) {
                EnhancedDebugger.addBatched(string, this.buffer, sentText);
            }
        };
        debugWriter.addWriterListener(this.writerListener);
        this.reader = debugReader;
        this.writer = debugWriter;
    }

    private static void addBatched(String string, PriorityBlockingQueue<String> buffer, JTextArea jTextArea) {
        buffer.add(string);
        SwingUtilities.invokeLater(() -> {
            ArrayList<String> linesToAdd = new ArrayList<String>();
            Instant start = Instant.now();
            try {
                String data;
                while (linesToAdd.size() < 50 && Duration.between(start, Instant.now()).compareTo(Duration.ofMillis(100L)) < 0 && (data = (String)buffer.poll(10L, TimeUnit.MILLISECONDS)) != null) {
                    linesToAdd.add(data);
                }
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINER, "Interrupted wait-for-poll in addBatched(). Process all data now.", e);
            }
            if (linesToAdd.isEmpty()) {
                return;
            }
            if (EnhancedDebuggerWindow.PERSISTED_DEBUGGER && !EnhancedDebuggerWindow.getInstance().isVisible()) {
                return;
            }
            int linesToDelete = jTextArea.getLineCount() + linesToAdd.size() - EnhancedDebuggerWindow.MAX_TABLE_ROWS;
            if (linesToDelete > 0) {
                try {
                    jTextArea.replaceRange("", 0, jTextArea.getLineEndOffset(linesToDelete - 1));
                }
                catch (BadLocationException e) {
                    LOGGER.log(Level.SEVERE, "Error with line offset, MAX_TABLE_ROWS is set too low: " + EnhancedDebuggerWindow.MAX_TABLE_ROWS, e);
                }
            }
            jTextArea.append(String.join((CharSequence)NEWLINE, linesToAdd));
        });
    }

    private void addAdhocPacketPanel() {
        final JTextArea adhocMessages = new JTextArea();
        adhocMessages.setEditable(true);
        adhocMessages.setForeground(new Color(1, 94, 35));
        this.tabbedPane.add("Ad-hoc message", new JScrollPane(adhocMessages));
        this.tabbedPane.setToolTipTextAt(3, "Panel that allows you to send adhoc packets");
        JPopupMenu menu = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Message");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adhocMessages.setText("<message to=\"\" id=\"" + StringUtils.randomString((int)5) + "-X\"><body></body></message>");
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("IQ Get");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adhocMessages.setText("<iq type=\"get\" to=\"\" id=\"" + StringUtils.randomString((int)5) + "-X\"><query xmlns=\"\"></query></iq>");
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("IQ Set");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adhocMessages.setText("<iq type=\"set\" to=\"\" id=\"" + StringUtils.randomString((int)5) + "-X\"><query xmlns=\"\"></query></iq>");
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Presence");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adhocMessages.setText("<presence to=\"\" id=\"" + StringUtils.randomString((int)5) + "-X\"/>");
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem("Send");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!"".equals(adhocMessages.getText())) {
                    AdHocPacket packetToSend = new AdHocPacket(adhocMessages.getText());
                    try {
                        EnhancedDebugger.this.connection.sendStanza((Stanza)packetToSend);
                    }
                    catch (InterruptedException | SmackException.NotConnectedException e1) {
                        LOGGER.log(Level.WARNING, "exception", e);
                    }
                }
            }
        });
        menu.add(menuItem);
        menuItem = new JMenuItem("Clear");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                adhocMessages.setText(null);
            }
        });
        menu.add(menuItem);
        adhocMessages.addMouseListener(new PopupListener(menu));
    }

    private void addInformationPanel() {
        JPanel informationPanel = new JPanel();
        informationPanel.setLayout(new BorderLayout());
        JPanel connPanel = new JPanel();
        connPanel.setLayout(new GridBagLayout());
        connPanel.setBorder(BorderFactory.createTitledBorder("XMPPConnection information"));
        JLabel label = new JLabel("Host: ");
        label.setMinimumSize(new Dimension(150, 14));
        label.setMaximumSize(new Dimension(150, 14));
        connPanel.add((Component)label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        JFormattedTextField field = new JFormattedTextField(this.connection.getXMPPServiceDomain());
        field.setMinimumSize(new Dimension(150, 20));
        field.setMaximumSize(new Dimension(150, 20));
        field.setEditable(false);
        field.setBorder(null);
        connPanel.add((Component)field, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Port: ");
        label.setMinimumSize(new Dimension(150, 14));
        label.setMaximumSize(new Dimension(150, 14));
        connPanel.add((Component)label, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        field = new JFormattedTextField((Object)this.connection.getPort());
        field.setMinimumSize(new Dimension(150, 20));
        field.setMaximumSize(new Dimension(150, 20));
        field.setEditable(false);
        field.setBorder(null);
        connPanel.add((Component)field, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("User: ");
        label.setMinimumSize(new Dimension(150, 14));
        label.setMaximumSize(new Dimension(150, 14));
        connPanel.add((Component)label, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.userField = new JFormattedTextField();
        this.userField.setMinimumSize(new Dimension(150, 20));
        this.userField.setMaximumSize(new Dimension(150, 20));
        this.userField.setEditable(false);
        this.userField.setBorder(null);
        connPanel.add((Component)this.userField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Creation time: ");
        label.setMinimumSize(new Dimension(150, 14));
        label.setMaximumSize(new Dimension(150, 14));
        connPanel.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        field = new JFormattedTextField(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss:SS"));
        field.setMinimumSize(new Dimension(150, 20));
        field.setMaximumSize(new Dimension(150, 20));
        field.setValue(this.creationTime);
        field.setEditable(false);
        field.setBorder(null);
        connPanel.add((Component)field, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        label = new JLabel("Status: ");
        label.setMinimumSize(new Dimension(150, 14));
        label.setMaximumSize(new Dimension(150, 14));
        connPanel.add((Component)label, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.statusField = new JFormattedTextField();
        this.statusField.setMinimumSize(new Dimension(150, 20));
        this.statusField.setMaximumSize(new Dimension(150, 20));
        this.statusField.setValue("Active");
        this.statusField.setEditable(false);
        this.statusField.setBorder(null);
        connPanel.add((Component)this.statusField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        informationPanel.add((Component)connPanel, "North");
        JPanel packetsPanel = new JPanel();
        packetsPanel.setLayout(new GridLayout(1, 1));
        packetsPanel.setBorder(BorderFactory.createTitledBorder("Transmitted Packets"));
        this.statisticsTable = new DefaultTableModel(new Object[][]{{"IQ", 0, 0}, {"Message", 0, 0}, {"Presence", 0, 0}, {"Other", 0, 0}, {"Total", 0, 0}}, new Object[]{"Type", "Received", "Sent"}){
            private static final long serialVersionUID = -6793886085109589269L;

            @Override
            public boolean isCellEditable(int rowIndex, int mColIndex) {
                return false;
            }
        };
        JTable table = new JTable(this.statisticsTable);
        table.setSelectionMode(0);
        packetsPanel.add(new JScrollPane(table));
        informationPanel.add((Component)packetsPanel, "Center");
        this.tabbedPane.add("Information", new JScrollPane(informationPanel));
        this.tabbedPane.setToolTipTextAt(4, "Information and statistics about the debugged connection");
    }

    public final void outgoingStreamSink(CharSequence outgoingCharSequence) {
        this.writerListener.write(outgoingCharSequence.toString());
    }

    public final void incomingStreamSink(CharSequence incomingCharSequence) {
        this.readerListener.read(incomingCharSequence.toString());
    }

    public void userHasLogged(final EntityFullJid user) {
        final EnhancedDebugger debugger = this;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EnhancedDebugger.this.userField.setText(user.toString());
                EnhancedDebuggerWindow.userHasLogged(debugger, user.toString());
                EnhancedDebugger.this.connection.addConnectionListener(EnhancedDebugger.this.connListener);
            }
        });
    }

    private void updateStatistics() {
        this.statisticsTable.setValueAt(this.receivedIQPackets, 0, 1);
        this.statisticsTable.setValueAt(this.sentIQPackets, 0, 2);
        this.statisticsTable.setValueAt(this.receivedMessagePackets, 1, 1);
        this.statisticsTable.setValueAt(this.sentMessagePackets, 1, 2);
        this.statisticsTable.setValueAt(this.receivedPresencePackets, 2, 1);
        this.statisticsTable.setValueAt(this.sentPresencePackets, 2, 2);
        this.statisticsTable.setValueAt(this.receivedOtherPackets, 3, 1);
        this.statisticsTable.setValueAt(this.sentOtherPackets, 3, 2);
        this.statisticsTable.setValueAt(this.receivedPackets, 4, 1);
        this.statisticsTable.setValueAt(this.sentPackets, 4, 2);
    }

    private void addReadPacketToTable(final SimpleDateFormat dateFormatter, final TopLevelStreamElement packet) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String messageType;
                ImageIcon packetTypeIcon;
                String stanzaId;
                Jid from;
                if (packet instanceof Stanza) {
                    Stanza stanza = (Stanza)packet;
                    from = stanza.getFrom();
                    stanzaId = stanza.getStanzaId();
                } else {
                    from = null;
                    stanzaId = "(Nonza)";
                }
                String type = "";
                EnhancedDebugger.this.receivedPackets++;
                if (packet instanceof IQ) {
                    packetTypeIcon = iqPacketIcon;
                    messageType = "IQ Received (class=" + packet.getClass().getName() + ")";
                    type = ((IQ)packet).getType().toString();
                    EnhancedDebugger.this.receivedIQPackets++;
                } else if (packet instanceof Message) {
                    packetTypeIcon = messagePacketIcon;
                    messageType = "Message Received";
                    type = ((Message)packet).getType().toString();
                    EnhancedDebugger.this.receivedMessagePackets++;
                } else if (packet instanceof Presence) {
                    packetTypeIcon = presencePacketIcon;
                    messageType = "Presence Received";
                    type = ((Presence)packet).getType().toString();
                    EnhancedDebugger.this.receivedPresencePackets++;
                } else {
                    packetTypeIcon = unknownPacketTypeIcon;
                    messageType = packet.getClass().getName() + " Received";
                    EnhancedDebugger.this.receivedOtherPackets++;
                }
                if (EnhancedDebuggerWindow.MAX_TABLE_ROWS > 0 && EnhancedDebugger.this.messagesTable.getRowCount() >= EnhancedDebuggerWindow.MAX_TABLE_ROWS) {
                    EnhancedDebugger.this.messagesTable.removeRow(0);
                }
                EnhancedDebugger.this.messagesTable.addRow(new Object[]{XmlUtil.prettyFormatXml((CharSequence)packet.toXML().toString()), dateFormatter.format(new Date()), packetReceivedIcon, packetTypeIcon, messageType, stanzaId, type, "", from});
                EnhancedDebugger.this.updateStatistics();
            }
        });
    }

    private void addSentPacketToTable(final SimpleDateFormat dateFormatter, final TopLevelStreamElement packet) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String messageType;
                ImageIcon packetTypeIcon;
                String stanzaId;
                Jid to;
                if (packet instanceof Stanza) {
                    Stanza stanza = (Stanza)packet;
                    to = stanza.getTo();
                    stanzaId = stanza.getStanzaId();
                } else {
                    to = null;
                    stanzaId = "(Nonza)";
                }
                String type = "";
                EnhancedDebugger.this.sentPackets++;
                if (packet instanceof IQ) {
                    packetTypeIcon = iqPacketIcon;
                    messageType = "IQ Sent (class=" + packet.getClass().getName() + ")";
                    type = ((IQ)packet).getType().toString();
                    EnhancedDebugger.this.sentIQPackets++;
                } else if (packet instanceof Message) {
                    packetTypeIcon = messagePacketIcon;
                    messageType = "Message Sent";
                    type = ((Message)packet).getType().toString();
                    EnhancedDebugger.this.sentMessagePackets++;
                } else if (packet instanceof Presence) {
                    packetTypeIcon = presencePacketIcon;
                    messageType = "Presence Sent";
                    type = ((Presence)packet).getType().toString();
                    EnhancedDebugger.this.sentPresencePackets++;
                } else {
                    packetTypeIcon = unknownPacketTypeIcon;
                    messageType = packet.getClass().getName() + " Sent";
                    EnhancedDebugger.this.sentOtherPackets++;
                }
                if (EnhancedDebuggerWindow.MAX_TABLE_ROWS > 0 && EnhancedDebugger.this.messagesTable.getRowCount() >= EnhancedDebuggerWindow.MAX_TABLE_ROWS) {
                    EnhancedDebugger.this.messagesTable.removeRow(0);
                }
                EnhancedDebugger.this.messagesTable.addRow(new Object[]{XmlUtil.prettyFormatXml((CharSequence)packet.toXML().toString()), dateFormatter.format(new Date()), packetSentIcon, packetTypeIcon, messageType, stanzaId, type, to, ""});
                EnhancedDebugger.this.updateStatistics();
            }
        });
    }

    boolean isConnectionActive() {
        return this.connection.isConnected();
    }

    void cancel() {
        this.connection.removeConnectionListener(this.connListener);
        ((ObservableReader)this.reader).removeReaderListener(this.readerListener);
        ((ObservableWriter)this.writer).removeWriterListener(this.writerListener);
        this.messagesTable = null;
    }

    public void onIncomingStreamElement(final TopLevelStreamElement streamElement) {
        final SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss:SS");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EnhancedDebugger.this.addReadPacketToTable(dateFormatter, streamElement);
            }
        });
    }

    public void onOutgoingStreamElement(final TopLevelStreamElement streamElement) {
        final SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss:SS");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EnhancedDebugger.this.addSentPacketToTable(dateFormatter, streamElement);
            }
        });
    }

    public static final class Factory
    implements SmackDebuggerFactory {
        public static final SmackDebuggerFactory INSTANCE = new Factory();

        private Factory() {
        }

        public SmackDebugger create(XMPPConnection connection) throws IllegalArgumentException {
            return new EnhancedDebugger(connection);
        }
    }

    private class SelectionListener
    implements ListSelectionListener {
        JTable table;

        SelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.table.getSelectedRow() == -1) {
                EnhancedDebugger.this.messageTextArea.setText(null);
            } else {
                EnhancedDebugger.this.messageTextArea.setText((String)this.table.getModel().getValueAt(this.table.getSelectedRow(), 0));
                EnhancedDebugger.this.messageTextArea.setCaretPosition(0);
            }
        }
    }

    private static class PopupListener
    extends MouseAdapter {
        JPopupMenu popup;

        PopupListener(JPopupMenu popupMenu) {
            this.popup = popupMenu;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private static final class AdHocPacket
    extends Stanza {
        private final String text;

        private AdHocPacket(String text) {
            this.text = text;
        }

        public String toXML(XmlEnvironment enclosingNamespace) {
            return this.text;
        }

        public String toString() {
            return this.toXML(null);
        }

        public String getElementName() {
            return null;
        }
    }
}

