/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.examples;

import java.util.function.Supplier;
import org.jivesoftware.smack.util.XmlStringBuilder;

public class XmlStringBuilderTest {
    static int COUNT_OUTER = 500;
    static int COUNT_INNER = 50;

    public static void main(String[] args) throws Exception {
        XmlStringBuilderTest.test1();
        XmlStringBuilderTest.test2();
        XmlStringBuilderTest.test3();
    }

    public static void test1() throws Exception {
        System.out.println("Test 1");
        XmlStringBuilder parent = new XmlStringBuilder();
        XmlStringBuilder child = new XmlStringBuilder();
        XmlStringBuilder child2 = new XmlStringBuilder();
        for (int i = 1; i < COUNT_OUTER; ++i) {
            XmlStringBuilder cs = new XmlStringBuilder();
            for (int j = 0; j < COUNT_INNER; ++j) {
                cs.append((CharSequence)"abc");
            }
            child2.append((CharSequence)cs);
        }
        child.append((CharSequence)child2);
        parent.append((CharSequence)child);
        XmlStringBuilderTest.time("test1: parent", () -> "len=" + parent.toString().length());
        XmlStringBuilderTest.time("test1: child", () -> "len=" + child.toString().length());
        XmlStringBuilderTest.time("test1: child2", () -> "len=" + child2.toString().length());
    }

    public static void test2() throws Exception {
        System.out.println("Test 2: evaluate children first");
        XmlStringBuilder parent = new XmlStringBuilder();
        XmlStringBuilder child = new XmlStringBuilder();
        XmlStringBuilder child2 = new XmlStringBuilder();
        for (int i = 1; i < COUNT_OUTER; ++i) {
            XmlStringBuilder cs = new XmlStringBuilder();
            for (int j = 0; j < COUNT_INNER; ++j) {
                cs.append((CharSequence)"abc");
            }
            child2.append((CharSequence)cs);
        }
        child.append((CharSequence)child2);
        parent.append((CharSequence)child);
        XmlStringBuilderTest.time("test2: child2", () -> "len=" + child2.toString().length());
        XmlStringBuilderTest.time("test2: child", () -> "len=" + child.toString().length());
        XmlStringBuilderTest.time("test2: parent", () -> "len=" + parent.toString().length());
    }

    public static void test3() throws Exception {
        System.out.println("Test 3: use append(XmlStringBuilder)");
        XmlStringBuilder parent = new XmlStringBuilder();
        XmlStringBuilder child = new XmlStringBuilder();
        XmlStringBuilder child2 = new XmlStringBuilder();
        for (int i = 1; i < COUNT_OUTER; ++i) {
            XmlStringBuilder cs = new XmlStringBuilder();
            for (int j = 0; j < COUNT_INNER; ++j) {
                cs.append((CharSequence)"abc");
            }
            child2.append(cs);
        }
        child.append(child2);
        parent.append(child);
        XmlStringBuilderTest.time("test3: parent", () -> "len=" + parent.toString().length());
        XmlStringBuilderTest.time("test3: child", () -> "len=" + child.toString().length());
        XmlStringBuilderTest.time("test3: child2", () -> "len=" + child2.toString().length());
    }

    static void time(String name, Supplier<String> block) {
        long start = System.currentTimeMillis();
        String result = block.get();
        long end = System.currentTimeMillis();
        System.out.println(name + " took " + (end - start) + "ms: " + result);
    }
}

