/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.examples;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PubSubManager;
import org.jxmpp.stringprep.XmppStringprepException;

public class XmppConnectionTool {
    public final ModularXmppClientToServerConnection connection;

    public XmppConnectionTool(ModularXmppClientToServerConnection connection) {
        this.connection = connection;
    }

    public boolean purgeOmemoInformation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PepManager pepManager = PepManager.getInstanceFor((XMPPConnection)this.connection);
        PubSubManager pepPubSubManager = pepManager.getPepPubSubManager();
        return pepPubSubManager.deleteNode("eu.siacs.conversations.axolotl.devicelist");
    }

    public static XmppConnectionTool of(String jid, String password, boolean debug) throws XMPPException, SmackException, IOException, InterruptedException {
        ModularXmppClientToServerConnection connection = XmppConnectionTool.createConnectionFor(jid, password, debug);
        connection.connect().login();
        return new XmppConnectionTool(connection);
    }

    public static ModularXmppClientToServerConnection createConnectionFor(String jid, String password, boolean debug) throws XmppStringprepException {
        Object smackDebuggerFactory = debug ? ConsoleDebugger.Factory.INSTANCE : null;
        ModularXmppClientToServerConnectionConfiguration.Builder configurationBuilder = (ModularXmppClientToServerConnectionConfiguration.Builder)((ModularXmppClientToServerConnectionConfiguration.Builder)ModularXmppClientToServerConnectionConfiguration.builder().setXmppAddressAndPassword((CharSequence)jid, password)).setDebuggerFactory(smackDebuggerFactory);
        ModularXmppClientToServerConnectionConfiguration configuration = configurationBuilder.build();
        ModularXmppClientToServerConnection connection = new ModularXmppClientToServerConnection(configuration);
        return connection;
    }
}

