/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.examples;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.jivesoftware.smack.tcp.XMPPTCPConnectionConfiguration;
import org.jivesoftware.smackx.carbons.packet.CarbonExtension;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoMessage;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CannotEstablishOmemoSessionException;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.exceptions.UndecidedOmemoIdentityException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.listener.OmemoMessageListener;
import org.jivesoftware.smackx.omemo.listener.OmemoMucMessageListener;
import org.jivesoftware.smackx.omemo.signal.SignalCachingOmemoStore;
import org.jivesoftware.smackx.omemo.signal.SignalFileBasedOmemoStore;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoService;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.trust.OmemoTrustCallback;
import org.jivesoftware.smackx.omemo.trust.TrustState;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class OmemoClient {
    public static final Logger LOGGER = Logger.getLogger(OmemoClient.class.getName());
    private static final Scanner scanner = new Scanner(System.in, "UTF-8");
    private final XMPPTCPConnection connection;
    private final OmemoManager omemoManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws XMPPException, SmackException, IOException, InterruptedException, CorruptedOmemoKeyException {
        SmackConfiguration.DEBUG = true;
        if (args.length != 2) {
            OmemoClient.print("Missing arguments: <jid> <password>");
            return;
        }
        SignalOmemoService.acknowledgeLicense();
        SignalOmemoService.setup();
        SignalOmemoService omemoService = (SignalOmemoService)SignalOmemoService.getInstance();
        Path omemoStoreDirectory = Files.createTempDirectory("omemo-store", new FileAttribute[0]);
        omemoService.setOmemoStoreBackend((OmemoStore)new SignalCachingOmemoStore((OmemoStore)new SignalFileBasedOmemoStore(omemoStoreDirectory.toFile())));
        EntityBareJid jid = JidCreate.entityBareFromOrThrowUnchecked((CharSequence)args[0]);
        String password = args[1];
        OmemoClient client = new OmemoClient(jid, password);
        try {
            String input;
            client.start();
            while (!(input = scanner.nextLine()).startsWith("/quit")) {
                if (input.isEmpty()) continue;
                client.handleInput(input);
            }
        }
        finally {
            client.stop();
        }
    }

    public OmemoClient(EntityBareJid jid, String password) {
        this.connection = new XMPPTCPConnection(((XMPPTCPConnectionConfiguration.Builder)XMPPTCPConnectionConfiguration.builder().setXmppAddressAndPassword(jid, password)).build());
        this.connection.setReplyTimeout(10000L);
        this.omemoManager = OmemoManager.getInstanceFor((XMPPConnection)this.connection);
        this.omemoManager.setTrustCallback(new OmemoTrustCallback(){
            private final Map<OmemoFingerprint, TrustState> trustStateMap = new HashMap<OmemoFingerprint, TrustState>();

            public TrustState getTrust(OmemoDevice device, OmemoFingerprint fingerprint) {
                return this.trustStateMap.get(fingerprint) != null ? this.trustStateMap.get(fingerprint) : TrustState.undecided;
            }

            public void setTrust(OmemoDevice device, OmemoFingerprint fingerprint, TrustState state) {
                this.trustStateMap.put(fingerprint, state);
            }
        });
        this.omemoManager.addOmemoMessageListener(new OmemoMessageListener(){

            public void onOmemoMessageReceived(Stanza s, OmemoMessage.Received m) {
                OmemoClient.print(m.getSenderDevice() + ": " + (m.getBody() != null ? m.getBody() : "<keyTransportMessage>"));
            }

            public void onOmemoCarbonCopyReceived(CarbonExtension.Direction d, Message cc, Message wm, OmemoMessage.Received m) {
                this.onOmemoMessageReceived((Stanza)cc, m);
            }
        });
        this.omemoManager.addOmemoMucMessageListener(new OmemoMucMessageListener(){

            public void onOmemoMucMessageReceived(MultiUserChat muc, Stanza s, OmemoMessage.Received m) {
                OmemoClient.print(s.getFrom() + ":" + m.getSenderDevice().getDeviceId() + ": " + (m.getBody() != null ? m.getBody() : "<keyTransportMessage>"));
            }
        });
    }

    public void start() throws XMPPException, SmackException, IOException, InterruptedException, CorruptedOmemoKeyException {
        this.connection.connect().login();
        this.omemoManager.initialize();
        OmemoClient.print("Logged in!");
    }

    public void stop() {
        this.connection.disconnect();
    }

    public void handleInput(String input) throws SmackException.NotConnectedException, SmackException.NotLoggedInException, InterruptedException, IOException {
        String[] com = input.split(" ", 3);
        switch (com[0]) {
            case "/omemo": {
                if (com.length < 3) {
                    OmemoClient.print("Usage: /omemo <contact-jid> <message>");
                    return;
                }
                BareJid recipient = JidCreate.bareFrom((String)com[1]);
                String body = com[2];
                MessageBuilder messageBuilder = this.connection.getStanzaFactory().buildMessageStanza();
                try {
                    Message omemoMessage = this.omemoManager.encrypt(recipient, body).buildMessage(messageBuilder, (Jid)recipient);
                    this.connection.sendStanza((Stanza)omemoMessage);
                }
                catch (UndecidedOmemoIdentityException e) {
                    OmemoClient.print("Undecided Identities!\n" + Arrays.toString(e.getUndecidedDevices().toArray()));
                }
                catch (SmackException.NoResponseException | CryptoFailedException e) {
                    LOGGER.log(Level.SEVERE, "Unexpected Exception", e);
                }
                break;
            }
            case "/trust": {
                Map devices;
                OmemoClient.print("Trust");
                if (com.length != 2) {
                    OmemoClient.print("Usage: /trust <contact-jid>");
                }
                BareJid contact = JidCreate.bareFrom((String)com[1]);
                try {
                    devices = this.omemoManager.getActiveFingerprints(contact);
                }
                catch (SmackException.NoResponseException | CannotEstablishOmemoSessionException | CorruptedOmemoKeyException e) {
                    LOGGER.log(Level.SEVERE, "Unexpected Exception", e);
                    return;
                }
                for (OmemoDevice d : devices.keySet()) {
                    OmemoClient.print("Trust (1) or distrust (2)?\n" + ((OmemoFingerprint)devices.get(d)).blocksOf8Chars());
                    if (Integer.parseInt(scanner.nextLine()) == 1) {
                        this.omemoManager.trustOmemoIdentity(d, (OmemoFingerprint)devices.get(d));
                        continue;
                    }
                    this.omemoManager.distrustOmemoIdentity(d, (OmemoFingerprint)devices.get(d));
                }
                OmemoClient.print("Done.");
                break;
            }
            case "/purge": {
                try {
                    this.omemoManager.purgeDeviceList();
                    OmemoClient.print("Purged.");
                    break;
                }
                catch (SmackException.NoResponseException | XMPPException.XMPPErrorException | PubSubException.NotALeafNodeException e) {
                    LOGGER.log(Level.SEVERE, "Unexpected Exception", e);
                }
            }
        }
    }

    private static void print(String msg) {
        System.out.println(msg);
    }
}

