/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.examples;

import java.io.IOException;
import java.net.URISyntaxException;
import org.igniterealtime.smack.examples.XmppTools;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.util.TLSUtils;
import org.jivesoftware.smack.websocket.XmppWebSocketTransportModuleDescriptor;

public class WebSocketConnection {
    public static void main(String[] args) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        String messageTo = null;
        if (args.length < 3 || args.length > 4) {
            throw new IllegalArgumentException();
        }
        String jid = args[0];
        String password = args[1];
        String websocketEndpoint = args[2];
        if (args.length >= 4) {
            messageTo = args[3];
        }
        TLSUtils.setDefaultTrustStoreTypeToJksIfRequired();
        WebSocketConnection.testWebSocketConnection(jid, password, websocketEndpoint, messageTo);
    }

    public static void testWebSocketConnection(String jid, String password, String websocketEndpoint) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        WebSocketConnection.testWebSocketConnection(jid, password, websocketEndpoint, null);
    }

    public static void testWebSocketConnection(String jid, String password, String websocketEndpoint, String messageTo) throws URISyntaxException, SmackException, IOException, XMPPException, InterruptedException {
        ModularXmppClientToServerConnectionConfiguration.Builder builder = ModularXmppClientToServerConnectionConfiguration.builder();
        builder.removeAllModules().setXmppAddressAndPassword((CharSequence)jid, password);
        XmppWebSocketTransportModuleDescriptor.Builder websocketBuilder = XmppWebSocketTransportModuleDescriptor.getBuilder((ModularXmppClientToServerConnectionConfiguration.Builder)builder);
        websocketBuilder.explicitlySetWebSocketEndpointAndDiscovery((CharSequence)websocketEndpoint, false);
        builder.addModule(websocketBuilder.build());
        ModularXmppClientToServerConnectionConfiguration config = builder.build();
        ModularXmppClientToServerConnection connection = new ModularXmppClientToServerConnection(config);
        connection.setReplyTimeout(300000L);
        XmppTools.modularConnectionTest(connection, messageTo);
    }
}

