/*
 * Decompiled with CFR 0.152.
 */
package org.igniterealtime.smack.examples;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.igniterealtime.smack.examples.XmppTools;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.compression.XMPPInputOutputStream;
import org.jivesoftware.smack.debugger.ConsoleDebugger;
import org.jivesoftware.smack.sm.StreamManagementModuleDescriptor;
import org.jivesoftware.smack.tcp.XmppTcpTransportModuleDescriptor;

public class Nio {
    public static void main(String[] args) throws SmackException, IOException, XMPPException, InterruptedException {
        Nio.doNio(args[0], args[1], args[2]);
    }

    public static void doNio(String username, String password, String service) throws SmackException, IOException, XMPPException, InterruptedException {
        boolean useTls = true;
        boolean useStreamMangement = false;
        boolean useCompression = true;
        boolean useFullFlush = true;
        boolean javaNetDebug = false;
        boolean smackDebug = true;
        if (useFullFlush) {
            XMPPInputOutputStream.setFlushMethod((XMPPInputOutputStream.FlushMethod)XMPPInputOutputStream.FlushMethod.FULL_FLUSH);
        }
        if (javaNetDebug) {
            System.setProperty("javax.net.debug", "all");
        }
        ConnectionConfiguration.SecurityMode securityMode = useTls ? ConnectionConfiguration.SecurityMode.required : ConnectionConfiguration.SecurityMode.disabled;
        Object smackDebuggerFactory = smackDebug ? ConsoleDebugger.Factory.INSTANCE : null;
        ModularXmppClientToServerConnectionConfiguration.Builder configurationBuilder = ((ModularXmppClientToServerConnectionConfiguration.Builder)((ModularXmppClientToServerConnectionConfiguration.Builder)((ModularXmppClientToServerConnectionConfiguration.Builder)((ModularXmppClientToServerConnectionConfiguration.Builder)ModularXmppClientToServerConnectionConfiguration.builder().setUsernameAndPassword((CharSequence)username, password)).setXmppDomain(service)).setDebuggerFactory(smackDebuggerFactory)).setSecurityMode(securityMode)).removeAllModules().addModule(XmppTcpTransportModuleDescriptor.class);
        if (useCompression) {
            configurationBuilder.addModule(CompressionModuleDescriptor.class);
            configurationBuilder.setCompressionEnabled(true);
        }
        if (useStreamMangement) {
            configurationBuilder.addModule(StreamManagementModuleDescriptor.class);
        }
        ModularXmppClientToServerConnectionConfiguration configuration = configurationBuilder.build();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8)));
        configuration.printStateGraphInDotFormat(printWriter, false);
        printWriter.flush();
        ModularXmppClientToServerConnection connection = new ModularXmppClientToServerConnection(configuration);
        connection.setReplyTimeout(300000L);
        XmppTools.modularConnectionTest(connection, "flo@geekplace.eu");
    }
}

