/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.offline;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.offline.OfflineMessageHeader;
import org.jivesoftware.smackx.offline.packet.OfflineMessageInfo;
import org.jivesoftware.smackx.offline.packet.OfflineMessageRequest;
import org.jivesoftware.smackx.xdata.Form;

public class OfflineMessageManager {
    private static final String namespace = "http://jabber.org/protocol/offline";
    private XMPPConnection connection;
    private PacketFilter packetFilter;

    public OfflineMessageManager(XMPPConnection connection) {
        this.connection = connection;
        this.packetFilter = new AndFilter(new PacketFilter[]{new PacketExtensionFilter("offline", namespace), new PacketTypeFilter(Message.class)});
    }

    public boolean supportsFlexibleRetrieval() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        return ServiceDiscoveryManager.getInstanceFor(this.connection).supportsFeature(this.connection.getServiceName(), namespace);
    }

    public int getMessageCount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        DiscoverInfo info = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverInfo(null, namespace);
        Form extendedInfo = Form.getFormFrom((Packet)info);
        if (extendedInfo != null) {
            String value = extendedInfo.getField("number_of_messages").getValues().get(0);
            return Integer.parseInt(value);
        }
        return 0;
    }

    public List<OfflineMessageHeader> getHeaders() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<OfflineMessageHeader> answer = new ArrayList<OfflineMessageHeader>();
        DiscoverItems items = ServiceDiscoveryManager.getInstanceFor(this.connection).discoverItems(null, namespace);
        for (DiscoverItems.Item item : items.getItems()) {
            answer.add(new OfflineMessageHeader(item));
        }
        return answer;
    }

    public List<Message> getMessages(final List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Message> messages = new ArrayList<Message>();
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("view");
            request.addItem(item);
        }
        AndFilter messageFilter = new AndFilter(new PacketFilter[]{this.packetFilter, new PacketFilter(){

            public boolean accept(Packet packet) {
                OfflineMessageInfo info = (OfflineMessageInfo)packet.getExtension("offline", OfflineMessageManager.namespace);
                return nodes.contains(info.getNode());
            }
        }});
        PacketCollector messageCollector = this.connection.createPacketCollector((PacketFilter)messageFilter);
        this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        Message message = (Message)messageCollector.nextResult();
        while (message != null) {
            messages.add(message);
            message = (Message)messageCollector.nextResult((long)SmackConfiguration.getDefaultPacketReplyTimeout());
        }
        messageCollector.cancel();
        return messages;
    }

    public List<Message> getMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ArrayList<Message> messages = new ArrayList<Message>();
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setFetch(true);
        this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        PacketCollector messageCollector = this.connection.createPacketCollector(this.packetFilter);
        Message message = (Message)messageCollector.nextResult();
        while (message != null) {
            messages.add(message);
            message = (Message)messageCollector.nextResult((long)SmackConfiguration.getDefaultPacketReplyTimeout());
        }
        messageCollector.cancel();
        return messages;
    }

    public void deleteMessages(List<String> nodes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        for (String node : nodes) {
            OfflineMessageRequest.Item item = new OfflineMessageRequest.Item(node);
            item.setAction("remove");
            request.addItem(item);
        }
        this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
    }

    public void deleteMessages() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        OfflineMessageRequest request = new OfflineMessageRequest();
        request.setPurge(true);
        this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
    }
}

