/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.delay;

import java.util.Date;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.delay.packet.DelayInformation;

public class DelayInformationManager {
    public static final String LEGACY_DELAYED_DELIVERY_NAMESPACE = "jabber:x:delay";
    public static final String LEGACY_DELAYED_DELIVERY_ELEMENT = "x";

    public static DelayInformation getXep203DelayInformation(Packet packet) {
        return DelayInformation.getFrom(packet);
    }

    public static DelayInformation getLegacyDelayInformation(Packet packet) {
        return (DelayInformation)packet.getExtension(LEGACY_DELAYED_DELIVERY_ELEMENT, LEGACY_DELAYED_DELIVERY_NAMESPACE);
    }

    public static DelayInformation getDelayInformation(Packet packet) {
        DelayInformation delayInformation = DelayInformationManager.getXep203DelayInformation(packet);
        if (delayInformation != null) {
            return delayInformation;
        }
        return DelayInformationManager.getLegacyDelayInformation(packet);
    }

    public static Date getDelayTimestamp(Packet packet) {
        DelayInformation delayInformation = DelayInformationManager.getDelayInformation(packet);
        if (delayInformation == null) {
            return null;
        }
        return delayInformation.getStamp();
    }

    public static boolean isDelayedStanza(Packet packet) {
        DelayInformation packetExtension = DelayInformationManager.getDelayInformation(packet);
        return packetExtension != null;
    }
}

