/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UnknownFormatConversionException;
import org.jivesoftware.smackx.pubsub.FormType;
import org.jivesoftware.smackx.pubsub.PresenceState;
import org.jivesoftware.smackx.pubsub.SubscribeOptionFields;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.util.XmppDateTime;

public class SubscribeForm
extends Form {
    public SubscribeForm(DataForm configDataForm) {
        super(configDataForm);
    }

    public SubscribeForm(Form subscribeOptionsForm) {
        super(subscribeOptionsForm.getDataFormToSend());
    }

    public SubscribeForm(FormType formType) {
        super(formType.toString());
    }

    public boolean isDeliverOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.deliver));
    }

    public void setDeliverOn(boolean deliverNotifications) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), deliverNotifications);
    }

    public boolean isDigestOn() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.digest));
    }

    public void setDigestOn(boolean digestOn) {
        this.addField(SubscribeOptionFields.deliver, "boolean");
        this.setAnswer(SubscribeOptionFields.deliver.getFieldName(), digestOn);
    }

    public int getDigestFrequency() {
        return Integer.parseInt(this.getFieldValue(SubscribeOptionFields.digest_frequency));
    }

    public void setDigestFrequency(int frequency) {
        this.addField(SubscribeOptionFields.digest_frequency, "text-single");
        this.setAnswer(SubscribeOptionFields.digest_frequency.getFieldName(), frequency);
    }

    public Date getExpiry() {
        String dateTime = this.getFieldValue(SubscribeOptionFields.expire);
        try {
            return XmppDateTime.parseDate((String)dateTime);
        }
        catch (ParseException e) {
            UnknownFormatConversionException exc = new UnknownFormatConversionException(dateTime);
            exc.initCause(e);
            throw exc;
        }
    }

    public void setExpiry(Date expire) {
        this.addField(SubscribeOptionFields.expire, "text-single");
        this.setAnswer(SubscribeOptionFields.expire.getFieldName(), XmppDateTime.formatXEP0082Date((Date)expire));
    }

    public boolean isIncludeBody() {
        return SubscribeForm.parseBoolean(this.getFieldValue(SubscribeOptionFields.include_body));
    }

    public void setIncludeBody(boolean include) {
        this.addField(SubscribeOptionFields.include_body, "boolean");
        this.setAnswer(SubscribeOptionFields.include_body.getFieldName(), include);
    }

    public List<PresenceState> getShowValues() {
        ArrayList<PresenceState> result = new ArrayList<PresenceState>(5);
        for (String state : this.getFieldValues(SubscribeOptionFields.show_values)) {
            result.add(PresenceState.valueOf(state));
        }
        return result;
    }

    public void setShowValues(Collection<PresenceState> stateValues) {
        ArrayList<String> values = new ArrayList<String>(stateValues.size());
        for (PresenceState state : stateValues) {
            values.add(state.toString());
        }
        this.addField(SubscribeOptionFields.show_values, "list-multi");
        this.setAnswer(SubscribeOptionFields.show_values.getFieldName(), values);
    }

    private static boolean parseBoolean(String fieldValue) {
        return "1".equals(fieldValue) || "true".equals(fieldValue);
    }

    private String getFieldValue(SubscribeOptionFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getValues().get(0);
    }

    private List<String> getFieldValues(SubscribeOptionFields field) {
        FormField formField = this.getField(field.getFieldName());
        return formField.getValues();
    }

    private void addField(SubscribeOptionFields nodeField, String type) {
        String fieldName = nodeField.getFieldName();
        if (this.getField(fieldName) == null) {
            FormField field = new FormField(fieldName);
            field.setType(type);
            this.addField(field);
        }
    }
}

