/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamSession;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public class InBandBytestreamRequestTest {
    String initiatorJID = "initiator@xmpp-server/Smack";
    String targetJID = "target@xmpp-server/Smack";
    String sessionID = "session_id";
    XMPPConnection connection;
    InBandBytestreamManager byteStreamManager;
    Open initBytestream;

    @Before
    public void setup() {
        this.connection = (XMPPConnection)Mockito.mock(XMPPConnection.class);
        this.byteStreamManager = InBandBytestreamManager.getByteStreamManager((XMPPConnection)this.connection);
        this.initBytestream = new Open(this.sessionID, 4096);
        this.initBytestream.setFrom(this.initiatorJID);
        this.initBytestream.setTo(this.targetJID);
    }

    @Test
    public void shouldReplyWithErrorIfRequestIsRejected() throws SmackException.NotConnectedException {
        InBandBytestreamRequest ibbRequest = new InBandBytestreamRequest(this.byteStreamManager, this.initBytestream);
        ibbRequest.reject();
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.error, (Object)((IQ)argument.getValue()).getType());
        Assert.assertEquals((Object)XMPPError.Condition.not_acceptable.toString(), (Object)((IQ)argument.getValue()).getError().getCondition());
    }

    @Test
    public void shouldReturnSessionIfRequestIsAccepted() throws Exception {
        InBandBytestreamRequest ibbRequest = new InBandBytestreamRequest(this.byteStreamManager, this.initBytestream);
        InBandBytestreamSession session = ibbRequest.accept();
        ArgumentCaptor argument = ArgumentCaptor.forClass(IQ.class);
        ((XMPPConnection)Mockito.verify((Object)this.connection)).sendPacket((Packet)argument.capture());
        Assert.assertEquals((Object)this.initiatorJID, (Object)((IQ)argument.getValue()).getTo());
        Assert.assertEquals((Object)IQ.Type.result, (Object)((IQ)argument.getValue()).getType());
        Assert.assertNotNull((Object)session);
        Assert.assertNotNull((Object)session.getInputStream());
        Assert.assertNotNull((Object)session.getOutputStream());
    }
}

